/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.activation.data.model;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\nH\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/activation/data/model/FixedDecimal;", "", "integral", "", "fractional", "<init>", "(JJ)V", "exponent", "(JJJ)V", "value", "", "(I)V", "(J)V", "getIntegral", "()J", "getFractional", "plus", "other", "minus", "times", "compareTo", "toString", "", "component1", "component2", "copy", "equals", "", "", "hashCode", "Companion", "intellij.ml.llm.activation.data.model"})
@SourceDebugExtension(value={"SMAP\nFixedDecimal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedDecimal.kt\ncom/intellij/ml/llm/activation/data/model/FixedDecimal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1#2:81\n1803#3,3:82\n*S KotlinDebug\n*F\n+ 1 FixedDecimal.kt\ncom/intellij/ml/llm/activation/data/model/FixedDecimal\n*L\n55#1:82,3\n*E\n"})
public final class FixedDecimal
implements Comparable<FixedDecimal> {
    @NotNull
    public static final Companion Companion;
    private final long integral;
    private final long fractional;
    public static final long EXPONENT = 1000000000000L;
    private static final int FRACTIONAL_DIGITS = 12;
    @NotNull
    private static final FixedDecimal Zero;

    public FixedDecimal(long integral, long fractional) {
        this.integral = integral;
        this.fractional = fractional;
        if (!(this.fractional >= 0L)) {
            boolean $i$a$-require-FixedDecimal$32 = false;
            String $i$a$-require-FixedDecimal$32 = "Fractional part of a fixed decimal must be non-negative";
            throw new IllegalArgumentException($i$a$-require-FixedDecimal$32.toString());
        }
        if (!(this.fractional < 1000000000000L)) {
            boolean bl = false;
            String string = "Fractional part of a fixed decimal must be less than 1000000000000";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final long getIntegral() {
        return this.integral;
    }

    public final long getFractional() {
        return this.fractional;
    }

    public FixedDecimal(long integral, long fractional, long exponent) {
        this(integral, fractional * (1000000000000L / exponent));
    }

    public FixedDecimal(int value) {
        this(value, 0L);
    }

    public FixedDecimal(long value) {
        this(value, 0L);
    }

    @NotNull
    public final FixedDecimal plus(@NotNull FixedDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long fractional = this.fractional + other.fractional;
        if (fractional >= 1000000000000L) {
            return new FixedDecimal(this.integral + other.integral + 1L, fractional - 1000000000000L);
        }
        return new FixedDecimal(this.integral + other.integral, fractional);
    }

    @NotNull
    public final FixedDecimal minus(@NotNull FixedDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long fractional = this.fractional - other.fractional;
        if (fractional < 0L) {
            return new FixedDecimal(this.integral - other.integral - 1L, fractional + 1000000000000L);
        }
        return new FixedDecimal(this.integral - other.integral, fractional);
    }

    @NotNull
    public final FixedDecimal times(int other) {
        long fractional = this.fractional * (long)other % 1000000000000L;
        long integral = this.integral * (long)other + this.fractional * (long)other / 1000000000000L;
        return new FixedDecimal(integral, fractional % 1000000000000L);
    }

    @Override
    public int compareTo(@NotNull FixedDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.integral != other.integral) {
            return Intrinsics.compare((long)this.integral, (long)other.integral);
        }
        return Intrinsics.compare((long)this.fractional, (long)other.fractional);
    }

    @NotNull
    public String toString() {
        return this.integral + "." + FixedDecimal.Companion.formatFractionString(this.fractional);
    }

    public final long component1() {
        return this.integral;
    }

    public final long component2() {
        return this.fractional;
    }

    @NotNull
    public final FixedDecimal copy(long integral, long fractional) {
        return new FixedDecimal(integral, fractional);
    }

    public static /* synthetic */ FixedDecimal copy$default(FixedDecimal fixedDecimal, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = fixedDecimal.integral;
        }
        if ((n & 2) != 0) {
            l2 = fixedDecimal.fractional;
        }
        return fixedDecimal.copy(l, l2);
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.integral);
        result2 = result2 * 31 + Long.hashCode(this.fractional);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FixedDecimal)) {
            return false;
        }
        FixedDecimal fixedDecimal = (FixedDecimal)other;
        if (this.integral != fixedDecimal.integral) {
            return false;
        }
        return this.fractional == fixedDecimal.fractional;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$fold$iv;
        void initial$iv;
        Companion = new Companion(null);
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)12);
        long l = 1L;
        long l2 = 1000000000000L;
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv = ((IntIterator)iterator).nextInt();
            void acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc * (long)10;
        }
        void var13_11 = accumulator$iv;
        if (!(l2 == var13_11)) {
            boolean bl = false;
            String string = "EXPONENT must be 10^FRACTIONAL_DIGITS";
            throw new IllegalStateException(string.toString());
        }
        Zero = new FixedDecimal(0L, 0L);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\u00020\u0001*\u00020\u0005H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/activation/data/model/FixedDecimal$Companion;", "", "<init>", "()V", "EXPONENT", "", "FRACTIONAL_DIGITS", "", "formatFractionString", "fromString", "Lcom/intellij/ml/llm/activation/data/model/FixedDecimal;", "value", "", "Zero", "getZero", "()Lcom/intellij/ml/llm/activation/data/model/FixedDecimal;", "intellij.ml.llm.activation.data.model"})
    @SourceDebugExtension(value={"SMAP\nFixedDecimal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedDecimal.kt\ncom/intellij/ml/llm/activation/data/model/FixedDecimal$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,80:1\n140#2:81\n129#2,5:82\n*S KotlinDebug\n*F\n+ 1 FixedDecimal.kt\ncom/intellij/ml/llm/activation/data/model/FixedDecimal$Companion\n*L\n60#1:81\n60#1:82,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Object formatFractionString(long $this$formatFractionString) {
            CharSequence charSequence;
            block3: {
                if ($this$formatFractionString == 0L) {
                    return Character.valueOf('0');
                }
                String $this$trimEnd$iv = StringsKt.padStart((String)String.valueOf($this$formatFractionString), (int)12, (char)'0');
                boolean $i$f$trimEnd = false;
                CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                boolean $i$f$trimEnd2 = false;
                int n = $this$trimEnd$iv$iv.length() + -1;
                if (0 <= n) {
                    do {
                        int index$iv$iv = n--;
                        char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        if (it == '0') continue;
                        charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                        break block3;
                    } while (0 <= n);
                }
                charSequence = "";
            }
            return ((Object)charSequence).toString();
        }

        @NotNull
        public final FixedDecimal fromString(@NotNull String value) {
            long l;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object object = new char[]{'.'};
            char[] it = object = (Object)StringsKt.split$default((CharSequence)value, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            com.intellij.ml.llm.activation.data.model.FixedDecimal$Companion.fromString$requireNumberFormat(it.size() == 2, (Function0<String>)((Function0)() -> Companion.fromString$lambda$0$0(value)));
            char[] parts = object;
            long integral = Long.parseLong((String)parts.get(0));
            long it2 = l = Long.parseLong(StringsKt.padEnd((String)((String)parts.get(1)), (int)12, (char)'0'));
            boolean bl2 = false;
            com.intellij.ml.llm.activation.data.model.FixedDecimal$Companion.fromString$requireNumberFormat(0L <= it2 ? it2 < 1000000000000L : false, (Function0<String>)((Function0)() -> Companion.fromString$lambda$1$0(value)));
            long fractional = l;
            return new FixedDecimal(integral, fractional);
        }

        @NotNull
        public final FixedDecimal getZero() {
            return Zero;
        }

        private static final void fromString$requireNumberFormat(boolean condition, Function0<String> lazyMessage) {
            if (!condition) {
                throw new NumberFormatException((String)lazyMessage.invoke());
            }
        }

        private static final String fromString$lambda$0$0(String $value) {
            return "Invalid fixed decimal value: " + $value;
        }

        private static final String fromString$lambda$1$0(String $value) {
            return "Invalid fractional part of a fixed decimal: " + $value;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

