/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client;

import com.agentclientprotocol.model.ContentBlock;
import com.agentclientprotocol.model.PermissionOptionKind;
import com.agentclientprotocol.model.SessionUpdate;
import com.agentclientprotocol.model.ToolCallStatus;
import com.intellij.ml.llm.agents.A2UXEvent;
import com.intellij.ml.llm.agents.acp.client.InputRequestWrapper;
import com.intellij.ml.llm.agents.acp.client.ToolCallWrapper;
import com.intellij.ml.llm.agents.acp.process.AcpPathConverter;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.a2ux.api.ClientCapabilitiesAttachment;
import org.jetbrains.a2ux.api.CurrentDirectoryAttachment;
import org.jetbrains.a2ux.api.EnvironmentVariablesAttachment;
import org.jetbrains.a2ux.api.SelectedModelAttachment;
import org.jetbrains.a2ux.api.StepStatus;
import org.jetbrains.a2ux.api.TaskRequestAgentStateAttachment;
import org.jetbrains.a2ux.api.TaskRequestAttachment;
import org.jetbrains.a2ux.api.TaskRequestCustomAttachment;
import org.jetbrains.a2ux.api.TaskRequestFilesAttachment;
import org.jetbrains.a2ux.api.TaskRequestMcpServersAttachment;
import org.jetbrains.a2ux.api.TaskRequestOpenedFilesAttachment;
import org.jetbrains.a2ux.api.TaskRequestParametersAttachment;
import org.jetbrains.a2ux.api.TaskRequestRecentFilesAttachment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u000f*\u0004\u0018\u00010\u000f\"\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u0002*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0015\u0010\u0016\u001a\u00020\u000f*\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"convert", "", "Lcom/agentclientprotocol/model/ContentBlock;", "Lorg/jetbrains/a2ux/api/TaskRequestAttachment;", "pathConverter", "Lcom/intellij/ml/llm/agents/acp/process/AcpPathConverter;", "unsupported", "Lcom/intellij/ml/llm/agents/A2UXEvent;", "", "getToolStatus", "Lorg/jetbrains/a2ux/api/StepStatus;", "Lcom/intellij/ml/llm/agents/acp/client/ToolCallWrapper;", "toResourceLink", "Lcom/agentclientprotocol/model/ContentBlock$ResourceLink;", "filePath", "", "converter", "chunkContent", "Lcom/agentclientprotocol/model/SessionUpdate;", "getChunkContent", "(Lcom/agentclientprotocol/model/SessionUpdate;)Lcom/agentclientprotocol/model/ContentBlock;", "takeIfNotOutput", "permissionStepId", "Lcom/agentclientprotocol/model/ToolCallId;", "getPermissionStepId-yCh-2Ps", "(Ljava/lang/String;)Ljava/lang/String;", "intellij.ml.llm.agents.acp"})
@SourceDebugExtension(value={"SMAP\nAcpToA2UXConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpToA2UXConverter.kt\ncom/intellij/ml/llm/agents/acp/client/AcpToA2UXConverterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,340:1\n1563#2:341\n1634#2,3:342\n23#3:345\n*S KotlinDebug\n*F\n+ 1 AcpToA2UXConverter.kt\ncom/intellij/ml/llm/agents/acp/client/AcpToA2UXConverterKt\n*L\n291#1:341\n291#1:342,3\n304#1:345\n*E\n"})
public final class AcpToA2UXConverterKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContentBlock> convert(@NotNull TaskRequestAttachment $this$convert, @NotNull AcpPathConverter pathConverter) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$convert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        TaskRequestAttachment taskRequestAttachment = $this$convert;
        if (taskRequestAttachment instanceof TaskRequestAgentStateAttachment) {
            list = CollectionsKt.emptyList();
        } else if (taskRequestAttachment instanceof TaskRequestFilesAttachment) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((TaskRequestFilesAttachment)$this$convert).getAttachedFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(AcpToA2UXConverterKt.toResourceLink((String)it, pathConverter));
            }
            list = (List)destination$iv$iv;
        } else if (taskRequestAttachment instanceof TaskRequestOpenedFilesAttachment) {
            list = CollectionsKt.emptyList();
        } else if (taskRequestAttachment instanceof TaskRequestParametersAttachment) {
            list = CollectionsKt.emptyList();
        } else if (taskRequestAttachment instanceof TaskRequestRecentFilesAttachment) {
            list = CollectionsKt.emptyList();
        } else if (taskRequestAttachment instanceof TaskRequestCustomAttachment) {
            list = CollectionsKt.emptyList();
        } else if (taskRequestAttachment instanceof ClientCapabilitiesAttachment) {
            list = CollectionsKt.emptyList();
        } else if (taskRequestAttachment instanceof CurrentDirectoryAttachment) {
            list = CollectionsKt.emptyList();
        } else if (taskRequestAttachment instanceof EnvironmentVariablesAttachment) {
            list = CollectionsKt.emptyList();
        } else if (taskRequestAttachment instanceof SelectedModelAttachment) {
            list = CollectionsKt.emptyList();
        } else if (taskRequestAttachment instanceof TaskRequestMcpServersAttachment) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private static final List<A2UXEvent> unsupported(Object $this$unsupported) {
        Object $this$thisLogger$iv = $this$unsupported;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Unsupported event type: " + $this$unsupported.getClass());
        return CollectionsKt.emptyList();
    }

    private static final StepStatus getToolStatus(ToolCallWrapper $this$getToolStatus) {
        InputRequestWrapper inputRequestWrapper = $this$getToolStatus.getInputRequest();
        PermissionOptionKind responseKind = inputRequestWrapper != null && (inputRequestWrapper = inputRequestWrapper.getAnswer()) != null ? inputRequestWrapper.getKind() : null;
        boolean isRejected = responseKind == PermissionOptionKind.REJECT_ALWAYS || responseKind == PermissionOptionKind.REJECT_ONCE;
        ToolCallStatus toolCallStatus = $this$getToolStatus.getStatus();
        return switch (toolCallStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toolCallStatus.ordinal()]) {
            case 1 -> StepStatus.IN_PROGRESS;
            case 2 -> StepStatus.IN_PROGRESS;
            case 3 -> {
                if (isRejected) {
                    yield StepStatus.REJECTED;
                }
                yield StepStatus.COMPLETED;
            }
            case 4 -> {
                if (isRejected) {
                    yield StepStatus.REJECTED;
                }
                yield StepStatus.FAILED;
            }
            case -1 -> StepStatus.IN_PROGRESS;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final ContentBlock.ResourceLink toResourceLink(String filePath, AcpPathConverter converter) {
        Path path = Paths.get(filePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = Paths.get(converter.toAgentPath(path), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path path3 = path2;
        String string = PathsKt.getName((Path)path3);
        String string2 = path3.toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new ContentBlock.ResourceLink(string, string2, null, null, null, null, null, null, 252, null);
    }

    @Nullable
    public static final ContentBlock getChunkContent(@NotNull SessionUpdate $this$chunkContent) {
        Intrinsics.checkNotNullParameter((Object)$this$chunkContent, (String)"<this>");
        SessionUpdate sessionUpdate = $this$chunkContent;
        return sessionUpdate instanceof SessionUpdate.AgentMessageChunk ? ((SessionUpdate.AgentMessageChunk)$this$chunkContent).getContent() : (sessionUpdate instanceof SessionUpdate.AgentThoughtChunk ? ((SessionUpdate.AgentThoughtChunk)$this$chunkContent).getContent() : (sessionUpdate instanceof SessionUpdate.UserMessageChunk ? ((SessionUpdate.UserMessageChunk)$this$chunkContent).getContent() : null));
    }

    @Nullable
    public static final String takeIfNotOutput(@Nullable String $this$takeIfNotOutput) {
        if ($this$takeIfNotOutput == null) {
            return null;
        }
        if (StringsKt.startsWith$default((String)$this$takeIfNotOutput, (String)"```sh\n", (boolean)false, (int)2, null)) {
            return null;
        }
        return $this$takeIfNotOutput;
    }

    @NotNull
    public static final String getPermissionStepId-yCh-2Ps(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-agentclientprotocol-model-ToolCallId$-$this$permissionStepId$0");
        return string + "-permission";
    }

    public static final /* synthetic */ StepStatus access$getToolStatus(ToolCallWrapper $receiver) {
        return AcpToA2UXConverterKt.getToolStatus($receiver);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolCallStatus.values().length];
            try {
                nArray[ToolCallStatus.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolCallStatus.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolCallStatus.COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolCallStatus.FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

