/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.client.auth;

import com.agentclientprotocol.client.Client;
import com.agentclientprotocol.model.AuthMethod;
import com.agentclientprotocol.model.AuthMethodId;
import com.intellij.ml.llm.agents.acp.client.JsonRpcUtilKt;
import com.intellij.ml.llm.agents.acp.client.auth.AuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.AuthHandlerResult;
import com.intellij.ml.llm.agents.acp.client.auth.TerminalAuthHandler;
import com.intellij.ml.llm.agents.acp.client.auth.TerminalAuthHandlerKt;
import com.intellij.ml.llm.agents.acp.client.auth.TerminalAuthMetadata;
import com.intellij.ml.llm.agents.acp.client.auth.TerminalAuthParams;
import com.intellij.ml.llm.agents.acp.config.AcpAgentStartConfig;
import com.intellij.ml.llm.agents.acp.config.LocalAcpAgentConfig;
import com.intellij.ml.llm.agents.acp.process.AcpCommandResolver;
import com.intellij.ml.llm.agents.acp.process.ResolvedTerminalCommand;
import com.intellij.ml.llm.agents.acp.registry.AcpRuntimeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0081@\u00a2\u0006\u0004\b\u0017\u0010\u0018J2\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J8\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J8\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J8\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/auth/TerminalAuthHandler;", "Lcom/intellij/ml/llm/agents/acp/client/auth/AuthHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "canHandle", "", "authMethod", "Lcom/agentclientprotocol/model/AuthMethod;", "extractTerminalAuthParams", "Lcom/intellij/ml/llm/agents/acp/client/auth/TerminalAuthParams;", "extractTerminalAuthParams$intellij_ml_llm_agents_acp", "handle", "Lcom/intellij/ml/llm/agents/acp/client/auth/AuthHandlerResult;", "client", "Lcom/agentclientprotocol/client/Client;", "config", "Lcom/intellij/ml/llm/agents/acp/config/LocalAcpAgentConfig;", "(Lcom/agentclientprotocol/client/Client;Lcom/agentclientprotocol/model/AuthMethod;Lcom/intellij/ml/llm/agents/acp/config/LocalAcpAgentConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildCommand", "Lcom/intellij/ml/llm/agents/acp/client/auth/TerminalAuthHandler$LoginCommand;", "authParams", "buildCommand$intellij_ml_llm_agents_acp", "(Lcom/intellij/ml/llm/agents/acp/client/auth/TerminalAuthParams;Lcom/intellij/ml/llm/agents/acp/config/LocalAcpAgentConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildEnvMap", "", "", "runtimeBinDir", "authEnv", "buildCommandList", "", "command", "authArgs", "envMap", "buildWindowsCommand", "buildPosixCommand", "LoginCommand", "intellij.ml.llm.agents.acp"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalAuthHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalAuthHandler.kt\ncom/intellij/ml/llm/agents/acp/client/auth/TerminalAuthHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,257:1\n1761#2,3:258\n756#2,10:261\n216#3,2:271\n*S KotlinDebug\n*F\n+ 1 TerminalAuthHandler.kt\ncom/intellij/ml/llm/agents/acp/client/auth/TerminalAuthHandler\n*L\n88#1:258,3\n89#1:261,10\n246#1:271,2\n*E\n"})
public final class TerminalAuthHandler
implements AuthHandler {
    @NotNull
    private final Project project;

    public TerminalAuthHandler(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public boolean canHandle(@NotNull AuthMethod authMethod) {
        Intrinsics.checkNotNullParameter((Object)authMethod, (String)"authMethod");
        if (authMethod instanceof AuthMethod.TerminalAuth) {
            return true;
        }
        return TerminalAuthMetadata.Companion.fromMeta(authMethod.get_meta()) != null;
    }

    @VisibleForTesting
    @Nullable
    public final TerminalAuthParams extractTerminalAuthParams$intellij_ml_llm_agents_acp(@NotNull AuthMethod authMethod) {
        Intrinsics.checkNotNullParameter((Object)authMethod, (String)"authMethod");
        if (authMethod instanceof AuthMethod.TerminalAuth) {
            Map map2;
            List list = ((AuthMethod.TerminalAuth)authMethod).getArgs();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if ((map2 = ((AuthMethod.TerminalAuth)authMethod).getEnv()) == null) {
                map2 = MapsKt.emptyMap();
            }
            return new TerminalAuthParams(list, map2, null);
        }
        TerminalAuthMetadata terminalAuthMetadata = TerminalAuthMetadata.Companion.fromMeta(authMethod.get_meta());
        if (terminalAuthMetadata == null) {
            return null;
        }
        TerminalAuthMetadata metadata = terminalAuthMetadata;
        String command = metadata.getCommand();
        List actualArgs = metadata.getArgs();
        if (command != null) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = (Iterable)AcpRuntimeManager.RuntimeType.getEntries();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AcpRuntimeManager.RuntimeType it = (AcpRuntimeManager.RuntimeType)((Object)element$iv);
                        boolean bl2 = false;
                        if (!StringsKt.endsWith$default((String)command, (String)it.getCommandName(), (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Iterable $this$dropWhile$iv = actualArgs;
                boolean $i$f$dropWhile = false;
                boolean yielding$iv = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$dropWhile$iv) {
                    if (yielding$iv) {
                        list$iv.add(item$iv);
                        continue;
                    }
                    String it = (String)item$iv;
                    boolean bl3 = false;
                    if (StringsKt.startsWith$default((String)it, (String)"-", (boolean)false, (int)2, null)) continue;
                    list$iv.add(item$iv);
                    yielding$iv = true;
                }
                actualArgs = CollectionsKt.drop((Iterable)list$iv, (int)1);
            }
        }
        return new TerminalAuthParams(actualArgs, metadata.getEnv(), metadata.getLabel());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handle(@NotNull Client client, @NotNull AuthMethod authMethod, @NotNull LocalAcpAgentConfig config, @NotNull Continuation<? super AuthHandlerResult> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var10_5 = $completion;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalAuthHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle(null, null, null, (Continuation<? super AuthHandlerResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                params = this.extractTerminalAuthParams$intellij_ml_llm_agents_acp(authMethod);
                if (params == null) {
                    TerminalAuthHandlerKt.access$getLogger$p().warn("TerminalAuthHandler called but no terminal-auth configuration found");
                    return new AuthHandlerResult.Failed("Invalid terminal-auth configuration");
                }
                TerminalAuthHandlerKt.access$getLogger$p().info("Starting terminal authentication for method: " + AuthMethodId.toString-impl((String)authMethod.getId-YMWAytM()));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$1 = authMethod;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$3 = params;
                $continuation.label = 1;
                v0 = this.buildCommand$intellij_ml_llm_agents_acp(params, config, (Continuation<? super LoginCommand>)$continuation);
                if (v0 == var11_7) {
                    return var11_7;
                }
                ** GOTO lbl33
            }
            case 1: {
                params = (TerminalAuthParams)$continuation.L$3;
                config = (LocalAcpAgentConfig)$continuation.L$2;
                authMethod = (AuthMethod)$continuation.L$1;
                client = (Client)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                if ((command = (LoginCommand)v0) == null) {
                    TerminalAuthHandlerKt.access$getLogger$p().warn("Failed to resolve agent command for terminal authentication");
                    return new AuthHandlerResult.Failed("Failed to resolve agent command");
                }
                TerminalAuthHandlerKt.access$getLogger$p().info("Executing terminal command: " + command);
                completionDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)authMethod);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)params);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.L$5 = completionDeferred;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(params, authMethod, this, command, (CompletableDeferred<Unit>)completionDeferred, null){
                    int label;
                    final /* synthetic */ TerminalAuthParams $params;
                    final /* synthetic */ AuthMethod $authMethod;
                    final /* synthetic */ TerminalAuthHandler this$0;
                    final /* synthetic */ LoginCommand $command;
                    final /* synthetic */ CompletableDeferred<Unit> $completionDeferred;
                    {
                        this.$params = $params;
                        this.$authMethod = $authMethod;
                        this.this$0 = $receiver;
                        this.$command = $command;
                        this.$completionDeferred = $completionDeferred;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                String string = this.$params.getLabel();
                                if (string == null) {
                                    string = this.$authMethod.getName();
                                }
                                String tabName = string;
                                TerminalToolWindowManager terminalToolWindowManager = TerminalToolWindowManager.getInstance((Project)TerminalAuthHandler.access$getProject$p(this.this$0));
                                Object object = this.$command.getWorkingDir();
                                if (object == null || (object = object.toString()) == null) {
                                    object = TerminalAuthHandler.access$getProject$p(this.this$0).getBasePath();
                                }
                                TerminalWidget terminalWidget = terminalToolWindowManager.createNewSession((String)object, tabName, this.$command.getCommandList(), true, false);
                                Intrinsics.checkNotNullExpressionValue((Object)terminalWidget, (String)"createNewSession(...)");
                                TerminalWidget terminalWidget2 = terminalWidget;
                                terminalWidget2.addTerminationCallback(() -> handle.2.invokeSuspend$lambda$0(this.$authMethod, this.$completionDeferred), (Disposable)terminalWidget2);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final void invokeSuspend$lambda$0(AuthMethod $authMethod, CompletableDeferred $completionDeferred) {
                        TerminalAuthHandlerKt.access$getLogger$p().info("Terminal authentication command completed for method: " + AuthMethodId.toString-impl((String)$authMethod.getId-YMWAytM()));
                        $completionDeferred.complete((Object)Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var11_7) goto lbl50
lbl49:
                // 1 sources

                return var11_7;
lbl50:
                // 1 sources

                ** GOTO lbl62
            }
            case 2: {
                completionDeferred = (CompletableDeferred)$continuation.L$5;
                command = (LoginCommand)$continuation.L$4;
                params = (TerminalAuthParams)$continuation.L$3;
                config = (LocalAcpAgentConfig)$continuation.L$2;
                authMethod = (AuthMethod)$continuation.L$1;
                client = (Client)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl62:
                // 2 sources

                TerminalAuthHandlerKt.access$getLogger$p().info("Waiting for terminal authentication command to complete...");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)authMethod);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)params);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)completionDeferred);
                $continuation.label = 3;
                v2 = completionDeferred.await((Continuation)$continuation);
                ** if (v2 != var11_7) goto lbl73
lbl72:
                // 1 sources

                return var11_7;
lbl73:
                // 1 sources

                ** GOTO lbl85
            }
            case 3: {
                completionDeferred = (CompletableDeferred)$continuation.L$5;
                command = (LoginCommand)$continuation.L$4;
                params = (TerminalAuthParams)$continuation.L$3;
                config = (LocalAcpAgentConfig)$continuation.L$2;
                authMethod = (AuthMethod)$continuation.L$1;
                client = (Client)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl85:
                    // 2 sources

                    TerminalAuthHandlerKt.access$getLogger$p().info("Terminal authentication completed successfully");
                    return AuthHandlerResult.Success.INSTANCE;
                }
                catch (Exception e) {
                    TerminalAuthHandlerKt.access$getLogger$p().warn("Terminal authentication failed", (Throwable)e);
                    return new AuthHandlerResult.Failed("Terminal authentication failed: " + JsonRpcUtilKt.getErrorMessage(e));
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @Nullable
    public final Object buildCommand$intellij_ml_llm_agents_acp(@NotNull TerminalAuthParams authParams, @NotNull LocalAcpAgentConfig config, @NotNull Continuation<? super LoginCommand> $completion) {
        if (!($completion instanceof buildCommand.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalAuthHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.buildCommand$intellij_ml_llm_agents_acp(null, null, (Continuation<? super LoginCommand>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = authParams;
                $continuation.L$1 = config;
                $continuation.label = 1;
                v0 = config.resolveAgentStartConfig((Continuation<? super AcpAgentStartConfig>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                config = (LocalAcpAgentConfig)$continuation.L$1;
                authParams = (TerminalAuthParams)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                startConfig = (AcpAgentStartConfig)v0;
                $continuation.L$0 = authParams;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)config);
                $continuation.L$2 = startConfig;
                $continuation.label = 2;
                v1 = AcpCommandResolver.INSTANCE.resolveForTerminal(config.getName(), startConfig, this.project, (Continuation<? super ResolvedTerminalCommand>)$continuation);
                if (v1 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl39
            }
            case 2: {
                startConfig = (AcpAgentStartConfig)$continuation.L$2;
                config = (LocalAcpAgentConfig)$continuation.L$1;
                authParams = (TerminalAuthParams)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                v2 = (ResolvedTerminalCommand)v1;
                if (v2 == null) {
                    return null;
                }
                resolved = v2;
                v3 = resolved.getRuntimeBinDir();
                envMap = this.buildEnvMap(v3 != null ? v3.toString() : null, authParams.getEnv());
                return new LoginCommand(this.buildCommandList(resolved.getCommand(), CollectionsKt.plus((Collection)startConfig.getBaseArgs(), (Iterable)authParams.getArgs()), envMap), resolved.getWorkingDirectory());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Map<String, String> buildEnvMap(String runtimeBinDir, Map<String, String> authEnv) {
        Map map2;
        if (runtimeBinDir == null && authEnv.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map $this$buildEnvMap_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        if (runtimeBinDir != null) {
            String pathSeparator = File.pathSeparator;
            String string = System.getenv("PATH");
            if (string == null) {
                string = "";
            }
            String currentPath = string;
            $this$buildEnvMap_u24lambda_u240.put("PATH", runtimeBinDir + pathSeparator + currentPath);
        }
        $this$buildEnvMap_u24lambda_u240.putAll(authEnv);
        return MapsKt.build((Map)map2);
    }

    private final List<String> buildCommandList(String command, List<String> authArgs, Map<String, String> envMap) {
        List<Object> list;
        if (envMap.isEmpty()) {
            List list2;
            List $this$buildCommandList_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$buildCommandList_u24lambda_u240.add(command);
            $this$buildCommandList_u24lambda_u240.addAll((Collection)authArgs);
            list = CollectionsKt.build((List)list2);
        } else {
            list = OS.CURRENT == OS.Windows ? this.buildWindowsCommand(command, authArgs, envMap) : this.buildPosixCommand(command, authArgs, envMap);
        }
        return list;
    }

    private final List<String> buildWindowsCommand(String command, List<String> authArgs, Map<String, String> envMap) {
        String setCommands = CollectionsKt.joinToString$default((Iterable)envMap.entrySet(), (CharSequence)" && ", null, null, (int)0, null, TerminalAuthHandler::buildWindowsCommand$lambda$0, (int)30, null);
        String fullCommand = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)authArgs, (CharSequence)" ", (CharSequence)(command + " "), null, (int)0, null, TerminalAuthHandler::buildWindowsCommand$lambda$1, (int)28, null))).toString();
        String combinedCommand = setCommands + " && " + fullCommand;
        Object[] objectArray = new String[]{"cmd", "/c", combinedCommand};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<String> buildPosixCommand(String command, List<String> authArgs, Map<String, String> envMap) {
        List list;
        List $this$buildPosixCommand_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$buildPosixCommand_u24lambda_u240.add("env");
        Map<String, String> $this$forEach$iv = envMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = entry.getKey();
            String value = entry.getValue();
            $this$buildPosixCommand_u24lambda_u240.add(key + "=" + value);
        }
        $this$buildPosixCommand_u24lambda_u240.add(command);
        $this$buildPosixCommand_u24lambda_u240.addAll((Collection)authArgs);
        return CollectionsKt.build((List)list);
    }

    private static final CharSequence buildWindowsCommand$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        return "set " + key + "=" + value;
    }

    private static final CharSequence buildWindowsCommand$lambda$1(String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return StringsKt.contains$default((CharSequence)arg, (CharSequence)" ", (boolean)false, (int)2, null) ? (CharSequence)("\"" + arg + "\"") : (CharSequence)arg;
    }

    public static final /* synthetic */ Project access$getProject$p(TerminalAuthHandler $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J%\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/agents/acp/client/auth/TerminalAuthHandler$LoginCommand;", "", "commandList", "", "", "workingDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/util/List;Ljava/nio/file/Path;)V", "getCommandList", "()Ljava/util/List;", "getWorkingDir", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.agents.acp"})
    @VisibleForTesting
    public static final class LoginCommand {
        @NotNull
        private final List<String> commandList;
        @Nullable
        private final Path workingDir;

        public LoginCommand(@NotNull List<String> commandList, @Nullable Path workingDir) {
            Intrinsics.checkNotNullParameter(commandList, (String)"commandList");
            this.commandList = commandList;
            this.workingDir = workingDir;
        }

        @NotNull
        public final List<String> getCommandList() {
            return this.commandList;
        }

        @Nullable
        public final Path getWorkingDir() {
            return this.workingDir;
        }

        @NotNull
        public final List<String> component1() {
            return this.commandList;
        }

        @Nullable
        public final Path component2() {
            return this.workingDir;
        }

        @NotNull
        public final LoginCommand copy(@NotNull List<String> commandList, @Nullable Path workingDir) {
            Intrinsics.checkNotNullParameter(commandList, (String)"commandList");
            return new LoginCommand(commandList, workingDir);
        }

        public static /* synthetic */ LoginCommand copy$default(LoginCommand loginCommand, List list, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                list = loginCommand.commandList;
            }
            if ((n & 2) != 0) {
                path = loginCommand.workingDir;
            }
            return loginCommand.copy(list, path);
        }

        @NotNull
        public String toString() {
            return "LoginCommand(commandList=" + this.commandList + ", workingDir=" + this.workingDir + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.commandList).hashCode();
            result2 = result2 * 31 + (this.workingDir == null ? 0 : ((Object)this.workingDir).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoginCommand)) {
                return false;
            }
            LoginCommand loginCommand = (LoginCommand)other;
            if (!Intrinsics.areEqual(this.commandList, loginCommand.commandList)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.workingDir, (Object)loginCommand.workingDir);
        }
    }
}

