/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.diagnostic;

import com.intellij.ml.llm.agents.acp.diagnostic.AcpLoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/agents/acp/diagnostic/LineBufferLogger;", "", "prefix", "", "<init>", "(Ljava/lang/String;)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "append", "", "b", "", "off", "", "len", "byte", "flush", "Companion", "intellij.ml.llm.agents.acp"})
public final class LineBufferLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String prefix;
    @NotNull
    private final StringBuilder buffer;
    private static final int BUFFER_LIMIT = 20000;
    @Nullable
    private static final Logger logger = AcpLoggerFactory.INSTANCE.getTransportLogger();

    public LineBufferLogger(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
        this.buffer = new StringBuilder();
    }

    public final void append(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = off + len;
        for (int i = off; i < n; ++i) {
            char c = (char)b[i];
            this.buffer.append(c);
            if (c != '\n' && this.buffer.length() < 20000) continue;
            this.flush();
        }
    }

    public final void append(int n) {
        if (n >= 0) {
            char c = (char)n;
            this.buffer.append(c);
            if (c == '\n' || this.buffer.length() >= 20000) {
                this.flush();
            }
        }
    }

    public final void flush() {
        if (((CharSequence)this.buffer).length() > 0) {
            Logger logger = LineBufferLogger.logger;
            if (logger != null) {
                String string = this.buffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                char[] cArray = new char[]{'\n'};
                logger.log(Level.FINE, this.prefix + StringsKt.trimEnd((String)string, (char[])cArray));
            }
            StringsKt.clear((StringBuilder)this.buffer);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/agents/acp/diagnostic/LineBufferLogger$Companion;", "", "<init>", "()V", "BUFFER_LIMIT", "", "logger", "Ljava/util/logging/Logger;", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

