/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.registry;

import com.intellij.ml.llm.agents.acp.registry.AcpAgentId;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000eJ(\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000eJ\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpPaths;", "", "<init>", "()V", "getBaseDir", "Ljava/nio/file/Path;", "getDataDir", "getIconsDir", "getRuntimesDir", "getDownloadsDir", "getDownloadDir", "agentId", "Lcom/intellij/ml/llm/agents/acp/registry/AcpAgentId;", "version", "", "getRegistryPath", "getInstalledPath", "getAgentDir", "getAgentVersionDir", "getIconPath", "isDark", "", "extension", "getVersionedIconPath", "getVersionedIconDir", "getRuntimeDir", "runtime", "Companion", "intellij.ml.llm.agents.acp"})
public final class AcpPaths {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String AGENTS_DIR = "acp-agents";
    @NotNull
    public static final String ICONS_DIR = ".icons";
    @NotNull
    public static final String RUNTIMES_DIR = ".runtimes";
    @NotNull
    public static final String DOWNLOADS_DIR = ".downloads";
    @NotNull
    public static final String REGISTRY_FILE = "registry.json";
    @NotNull
    public static final String INSTALLED_FILE = "installed.json";
    @TestOnly
    @Nullable
    private static volatile Path testBaseDirOverride;
    @TestOnly
    @Nullable
    private static volatile Path testDataDirOverride;

    @NotNull
    public final Path getBaseDir() {
        Path path = testBaseDirOverride;
        if (path == null) {
            Path path2 = Path.of(PathManager.getDefaultSystemPathFor((String)""), new String[0]).resolve(AGENTS_DIR);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        }
        return path;
    }

    @NotNull
    public final Path getDataDir() {
        Path path = testDataDirOverride;
        if (path == null) {
            Path path2 = PathManager.getCommonDataPath().resolve(AGENTS_DIR);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        }
        return path;
    }

    @NotNull
    public final Path getIconsDir() {
        Path path = this.getBaseDir().resolve(ICONS_DIR);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getRuntimesDir() {
        Path path = this.getBaseDir().resolve(RUNTIMES_DIR);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getDownloadsDir() {
        Path path = this.getBaseDir().resolve(DOWNLOADS_DIR);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getDownloadDir(@NotNull AcpAgentId agentId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Path path = this.getDownloadsDir().resolve(agentId.getRawId()).resolve(version);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getRegistryPath() {
        Path path = this.getBaseDir().resolve(REGISTRY_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getInstalledPath() {
        Path path = this.getDataDir().resolve(INSTALLED_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getAgentDir(@NotNull AcpAgentId agentId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Path path = this.getBaseDir().resolve(agentId.getRawId());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getAgentVersionDir(@NotNull AcpAgentId agentId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Path path = this.getAgentDir(agentId).resolve(version);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getIconPath(@NotNull AcpAgentId agentId, boolean isDark, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String suffix = isDark ? "_dark" : "";
        Path path = this.getIconsDir().resolve(agentId.getRawId() + suffix + "." + extension);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public static /* synthetic */ Path getIconPath$default(AcpPaths acpPaths, AcpAgentId acpAgentId, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "svg";
        }
        return acpPaths.getIconPath(acpAgentId, bl, string);
    }

    @NotNull
    public final Path getVersionedIconPath(@NotNull AcpAgentId agentId, @NotNull String version, boolean isDark, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String filename = isDark ? "icon_dark." + extension : "icon." + extension;
        Path path = this.getIconsDir().resolve(agentId.getRawId()).resolve(version).resolve(filename);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public static /* synthetic */ Path getVersionedIconPath$default(AcpPaths acpPaths, AcpAgentId acpAgentId, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "svg";
        }
        return acpPaths.getVersionedIconPath(acpAgentId, string, bl, string2);
    }

    @NotNull
    public final Path getVersionedIconDir(@NotNull AcpAgentId agentId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Path path = this.getIconsDir().resolve(agentId.getRawId()).resolve(version);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getRuntimeDir(@NotNull String runtime, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Path path = this.getRuntimesDir().resolve(runtime).resolve(version);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0004\u0018\u00010\f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0004\u0018\u00010\f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/agents/acp/registry/AcpPaths$Companion;", "", "<init>", "()V", "AGENTS_DIR", "", "ICONS_DIR", "RUNTIMES_DIR", "DOWNLOADS_DIR", "REGISTRY_FILE", "INSTALLED_FILE", "testBaseDirOverride", "Ljava/nio/file/Path;", "getTestBaseDirOverride$intellij_ml_llm_agents_acp", "()Ljava/nio/file/Path;", "setTestBaseDirOverride$intellij_ml_llm_agents_acp", "(Ljava/nio/file/Path;)V", "testDataDirOverride", "getTestDataDirOverride$intellij_ml_llm_agents_acp", "setTestDataDirOverride$intellij_ml_llm_agents_acp", "intellij.ml.llm.agents.acp"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path getTestBaseDirOverride$intellij_ml_llm_agents_acp() {
            return testBaseDirOverride;
        }

        public final void setTestBaseDirOverride$intellij_ml_llm_agents_acp(@Nullable Path path) {
            testBaseDirOverride = path;
        }

        @Nullable
        public final Path getTestDataDirOverride$intellij_ml_llm_agents_acp() {
            return testDataDirOverride;
        }

        public final void setTestDataDirOverride$intellij_ml_llm_agents_acp(@Nullable Path path) {
            testDataDirOverride = path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

