/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.claude.code.protocol;

import com.intellij.ml.llm.agents.claude.code.protocol.Base64Source;
import com.intellij.ml.llm.agents.claude.code.protocol.Content;
import com.intellij.ml.llm.agents.claude.code.protocol.CustomToolInput;
import com.intellij.ml.llm.agents.claude.code.protocol.MediaSource;
import com.intellij.ml.llm.agents.claude.code.protocol.ToolInput;
import com.intellij.ml.llm.agents.claude.code.protocol.ToolInputsKt;
import com.intellij.ml.llm.agents.claude.code.protocol.UnknownSource;
import com.intellij.ml.llm.agents.claude.code.protocol.UrlSource;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/protocol/ContentSerializer;", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/agents/claude/code/protocol/Content;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "intellij.ml.llm.agents.claude.code"})
@SourceDebugExtension(value={"SMAP\nContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Content.kt\ncom/intellij/ml/llm/agents/claude/code/protocol/ContentSerializer\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SerialDescriptors.kt\nkotlinx/serialization/descriptors/SerialDescriptorsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,158:1\n29#2,2:159\n29#2,3:162\n29#2,3:165\n31#2:168\n1#3:161\n347#4,8:169\n347#4,8:177\n347#4,8:185\n347#4,8:193\n347#4,8:201\n347#4,8:209\n347#4,8:217\n347#4,8:225\n13#5:233\n*S KotlinDebug\n*F\n+ 1 Content.kt\ncom/intellij/ml/llm/agents/claude/code/protocol/ContentSerializer\n*L\n125#1:159,2\n135#1:162,3\n140#1:165,3\n125#1:168\n63#1:169,8\n64#1:177,8\n65#1:185,8\n66#1:193,8\n67#1:201,8\n68#1:209,8\n69#1:217,8\n70#1:225,8\n60#1:233\n*E\n"})
public final class ContentSerializer
implements KSerializer<Content> {
    @NotNull
    public static final ContentSerializer INSTANCE = new ContentSerializer();
    @NotNull
    private static final Logger log;
    @NotNull
    private static final SerialDescriptor descriptor;

    private ContentSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Content deserialize(@NotNull Decoder decoder) {
        ToolInput toolInput;
        MediaSource source;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonDecoder jsonDecoder = (JsonDecoder)decoder;
        JsonObject obj = JsonElementKt.getJsonObject((JsonElement)jsonDecoder.decodeJsonElement());
        Object object = (JsonElement)obj.get((Object)"type");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
            object = "";
        }
        Object type2 = object;
        JsonElement jsonElement = (JsonElement)obj.get((Object)"text");
        String text2 = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null;
        JsonElement jsonElement2 = (JsonElement)obj.get((Object)"id");
        String id = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? jsonElement2.getContent() : null;
        JsonElement jsonElement3 = (JsonElement)obj.get((Object)"name");
        String name = jsonElement3 != null && (jsonElement3 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement3)) != null ? jsonElement3.getContent() : null;
        JsonElement jsonElement4 = (JsonElement)obj.get((Object)"tool_use_id");
        String toolUseId = jsonElement4 != null && (jsonElement4 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement4)) != null ? jsonElement4.getContent() : null;
        JsonElement content2 = (JsonElement)obj.get((Object)"content");
        JsonElement jsonElement5 = (JsonElement)obj.get((Object)"source");
        if (jsonElement5 != null) {
            MediaSource mediaSource;
            JsonElement srcElem = jsonElement5;
            boolean bl = false;
            try {
                MediaSource mediaSource2;
                String srcType;
                JsonObject srcObj = JsonElementKt.getJsonObject((JsonElement)srcElem);
                JsonElement jsonElement6 = (JsonElement)srcObj.get((Object)"type");
                String string = srcType = jsonElement6 != null && (jsonElement6 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement6)) != null ? jsonElement6.getContent() : null;
                if (Intrinsics.areEqual((Object)string, (Object)"base64")) {
                    mediaSource2 = (MediaSource)jsonDecoder.getJson().decodeFromJsonElement((DeserializationStrategy)Base64Source.Companion.serializer(), srcElem);
                } else if (Intrinsics.areEqual((Object)string, (Object)"url")) {
                    mediaSource2 = (MediaSource)jsonDecoder.getJson().decodeFromJsonElement((DeserializationStrategy)UrlSource.Companion.serializer(), srcElem);
                } else {
                    String string2 = srcType;
                    if (string2 == null) {
                        string2 = "unknown";
                    }
                    mediaSource2 = new UnknownSource(string2, srcElem);
                }
                mediaSource = mediaSource2;
            }
            catch (Throwable t) {
                log.warn("Failed to parse MediaSource", t);
                mediaSource = null;
            }
            v9 = mediaSource;
        } else {
            v9 = source = null;
        }
        if (Intrinsics.areEqual((Object)type2, (Object)"tool_use") && name != null && obj.get((Object)"input") != null) {
            Object object2 = obj.get((Object)"input");
            Intrinsics.checkNotNull((Object)object2);
            JsonObject rawInputObj = JsonElementKt.getJsonObject((JsonElement)((JsonElement)object2));
            toolInput = StringsKt.startsWith$default((String)name, (String)"mcp__", (boolean)false, (int)2, null) ? (ToolInput)new CustomToolInput(name, (JsonElement)rawInputObj) : ToolInputsKt.parseToolInput(name, rawInputObj, jsonDecoder.getJson());
        } else {
            toolInput = null;
        }
        ToolInput parsedInput = toolInput;
        return new Content((String)type2, text2, id, name, parsedInput, toolUseId, content2, source);
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Content value) {
        String it;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonEncoder jsonEncoder = (JsonEncoder)encoder;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$serialize_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        $this$serialize_u24lambda_u240.put("type", (JsonElement)JsonElementKt.JsonPrimitive((String)value.getType()));
        String string = value.getText();
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$serialize_u24lambda_u240.put("text", (JsonElement)JsonElementKt.JsonPrimitive((String)it));
        }
        String string2 = value.getId();
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$serialize_u24lambda_u240.put("id", (JsonElement)JsonElementKt.JsonPrimitive((String)it));
        }
        String string3 = value.getName();
        if (string3 != null) {
            it = string3;
            boolean bl4 = false;
            $this$serialize_u24lambda_u240.put("name", (JsonElement)JsonElementKt.JsonPrimitive((String)it));
        }
        String string4 = value.getTool_use_id();
        if (string4 != null) {
            it = string4;
            boolean bl5 = false;
            $this$serialize_u24lambda_u240.put("tool_use_id", (JsonElement)JsonElementKt.JsonPrimitive((String)it));
        }
        JsonElement jsonElement = value.getContent();
        if (jsonElement != null) {
            it = jsonElement;
            boolean bl6 = false;
            $this$serialize_u24lambda_u240.put("content", (JsonElement)it);
        }
        MediaSource mediaSource = value.getSource();
        if (mediaSource != null) {
            JsonElement jsonElement2;
            MediaSource src = mediaSource;
            boolean bl7 = false;
            MediaSource mediaSource2 = src;
            if (mediaSource2 instanceof Base64Source) {
                $i$f$buildJsonObject = false;
                JsonObjectBuilder $this$serialize_u24lambda_u240_u245_u240 = builder$iv = new JsonObjectBuilder();
                boolean bl8 = false;
                $this$serialize_u24lambda_u240_u245_u240.put("type", (JsonElement)JsonElementKt.JsonPrimitive((String)((Base64Source)src).getType()));
                String string5 = ((Base64Source)src).getMedia_type();
                if (string5 != null) {
                    it = string5;
                    boolean bl9 = false;
                    $this$serialize_u24lambda_u240_u245_u240.put("media_type", (JsonElement)JsonElementKt.JsonPrimitive((String)it));
                }
                String string6 = ((Base64Source)src).getData();
                if (string6 != null) {
                    it = string6;
                    boolean bl10 = false;
                    $this$serialize_u24lambda_u240_u245_u240.put("data", (JsonElement)JsonElementKt.JsonPrimitive((String)it));
                }
                jsonElement2 = (JsonElement)builder$iv.build();
            } else if (mediaSource2 instanceof UrlSource) {
                $i$f$buildJsonObject = false;
                JsonObjectBuilder $this$serialize_u24lambda_u240_u245_u241 = builder$iv = new JsonObjectBuilder();
                boolean bl11 = false;
                $this$serialize_u24lambda_u240_u245_u241.put("type", (JsonElement)JsonElementKt.JsonPrimitive((String)((UrlSource)src).getType()));
                String string7 = ((UrlSource)src).getUrl();
                if (string7 != null) {
                    it = string7;
                    boolean bl12 = false;
                    $this$serialize_u24lambda_u240_u245_u241.put("url", (JsonElement)JsonElementKt.JsonPrimitive((String)it));
                }
                jsonElement2 = (JsonElement)builder$iv.build();
            } else if (mediaSource2 instanceof UnknownSource) {
                jsonElement2 = ((UnknownSource)src).getRaw();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            JsonElement srcElem = jsonElement2;
            if (!Intrinsics.areEqual((Object)srcElem, (Object)JsonNull.INSTANCE)) {
                $this$serialize_u24lambda_u240.put("source", srcElem);
            }
        }
        ToolInput toolInput = value.getInput();
        if (toolInput != null) {
            ToolInput inp = toolInput;
            boolean bl13 = false;
            JsonObject encoded2 = JsonElementKt.getJsonObject((JsonElement)jsonEncoder.getJson().encodeToJsonElement((SerializationStrategy)ToolInput.Companion.serializer(), (Object)inp));
            $this$serialize_u24lambda_u240.put("input", (JsonElement)new JsonObject(MapsKt.minus((Map)((Map)encoded2), (Object)"type")));
        }
        JsonObject base = builder$iv.build();
        jsonEncoder.encodeJsonElement((JsonElement)base);
    }

    private static final Unit descriptor$lambda$0(ClassSerialDescriptorBuilder $this$buildClassSerialDescriptor) {
        ClassSerialDescriptorBuilder $this$element_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)$this$buildClassSerialDescriptor, (String)"$this$buildClassSerialDescriptor");
        ClassSerialDescriptorBuilder classSerialDescriptorBuilder = $this$buildClassSerialDescriptor;
        String elementName$iv = "type";
        List annotations$iv = CollectionsKt.emptyList();
        boolean isOptional$iv = false;
        boolean $i$f$element = false;
        SerialDescriptor descriptor$iv = StringSerializer.INSTANCE.getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        $this$element_u24default$iv = $this$buildClassSerialDescriptor;
        elementName$iv = "text";
        isOptional$iv = true;
        annotations$iv = CollectionsKt.emptyList();
        $i$f$element = false;
        descriptor$iv = StringSerializer.INSTANCE.getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        $this$element_u24default$iv = $this$buildClassSerialDescriptor;
        elementName$iv = "id";
        isOptional$iv = true;
        annotations$iv = CollectionsKt.emptyList();
        $i$f$element = false;
        descriptor$iv = StringSerializer.INSTANCE.getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        $this$element_u24default$iv = $this$buildClassSerialDescriptor;
        elementName$iv = "name";
        isOptional$iv = true;
        annotations$iv = CollectionsKt.emptyList();
        $i$f$element = false;
        descriptor$iv = StringSerializer.INSTANCE.getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        $this$element_u24default$iv = $this$buildClassSerialDescriptor;
        elementName$iv = "input";
        isOptional$iv = true;
        annotations$iv = CollectionsKt.emptyList();
        $i$f$element = false;
        descriptor$iv = ToolInput.Companion.serializer().getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        $this$element_u24default$iv = $this$buildClassSerialDescriptor;
        elementName$iv = "tool_use_id";
        isOptional$iv = true;
        annotations$iv = CollectionsKt.emptyList();
        $i$f$element = false;
        descriptor$iv = StringSerializer.INSTANCE.getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        $this$element_u24default$iv = $this$buildClassSerialDescriptor;
        elementName$iv = "content";
        isOptional$iv = true;
        annotations$iv = CollectionsKt.emptyList();
        $i$f$element = false;
        descriptor$iv = StringSerializer.INSTANCE.getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        $this$element_u24default$iv = $this$buildClassSerialDescriptor;
        elementName$iv = "source";
        isOptional$iv = true;
        annotations$iv = CollectionsKt.emptyList();
        $i$f$element = false;
        descriptor$iv = StringSerializer.INSTANCE.getDescriptor();
        $this$element_u24default$iv.element(elementName$iv, descriptor$iv, annotations$iv, isOptional$iv);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ContentSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        descriptor = SerialDescriptorsKt.buildClassSerialDescriptor((String)"Content", (SerialDescriptor[])new SerialDescriptor[0], ContentSerializer::descriptor$lambda$0);
    }
}

