/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.claude.code.proxy;

import ai.grazie.model.cloud.ContentType;
import ai.grazie.model.cloud.exceptions.HTTPStatusException;
import ai.grazie.model.llm.chat.caching.LLMCachePoint;
import ai.grazie.model.llm.chat.caching.LLMCachePoints;
import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessageText;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessageTool;
import ai.grazie.model.llm.chat.v5.LLMChatMediaMessage;
import ai.grazie.model.llm.chat.v5.LLMChatMessage;
import ai.grazie.model.llm.chat.v5.LLMChatSystemMessage;
import ai.grazie.model.llm.chat.v5.LLMChatToolMessage;
import ai.grazie.model.llm.chat.v5.LLMChatUserMessage;
import ai.grazie.model.llm.parameters.LLMParameters;
import ai.grazie.model.llm.profile.LLMProfileID;
import ai.grazie.model.llm.prompt.LLMPromptID;
import ai.grazie.utils.attributes.Attributes;
import ai.grazie.utils.json.JSON;
import com.intellij.ml.llm.agents.claude.code.proxy.Base64Source;
import com.intellij.ml.llm.agents.claude.code.proxy.ClaudeHttpRequestHandler;
import com.intellij.ml.llm.agents.claude.code.proxy.ClaudeHttpRequestHandlerKt;
import com.intellij.ml.llm.agents.claude.code.proxy.ClaudeResponseContentBuilder;
import com.intellij.ml.llm.agents.claude.code.proxy.DocumentContent;
import com.intellij.ml.llm.agents.claude.code.proxy.ImageContent;
import com.intellij.ml.llm.agents.claude.code.proxy.LlmFunctionConverterKt;
import com.intellij.ml.llm.agents.claude.code.proxy.Message;
import com.intellij.ml.llm.agents.claude.code.proxy.MessageContent;
import com.intellij.ml.llm.agents.claude.code.proxy.MessageRequest;
import com.intellij.ml.llm.agents.claude.code.proxy.MessageResponse;
import com.intellij.ml.llm.agents.claude.code.proxy.SystemContent;
import com.intellij.ml.llm.agents.claude.code.proxy.TextContent;
import com.intellij.ml.llm.agents.claude.code.proxy.Tool;
import com.intellij.ml.llm.agents.claude.code.proxy.ToolResultContent;
import com.intellij.ml.llm.agents.claude.code.proxy.ToolUseContent;
import com.intellij.ml.llm.agents.claude.code.proxy.Usage;
import com.intellij.ml.llm.core.models.LlmProfileService;
import com.intellij.ml.llm.core.models.api.AiaLlmStreamData;
import com.intellij.ml.llm.grazie.GrazieUtilsKt;
import com.intellij.ml.llm.grazie.client.GrazieApiClient;
import com.intellij.ml.llm.grazie.client.GrazieApiClientProvider;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.ml.llm.tokenizer.TokenizerAccessPointService;
import com.intellij.openapi.project.Project;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0002-.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\"\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001aH\u0002J\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010 J(\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002\u00a8\u0006/"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/proxy/ClaudeHttpRequestHandler;", "Lorg/jetbrains/ide/RestService;", "<init>", "()V", "getServiceName", "", "getMaxRequestsPerMinute", "", "isMethodSupported", "", "method", "Lio/netty/handler/codec/http/HttpMethod;", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "buildBackendMessages", "", "Lcom/intellij/ml/llm/agents/claude/code/proxy/ClaudeHttpRequestHandler$BackendMessage;", "Lcom/intellij/ml/llm/agents/claude/code/proxy/MessageRequest;", "removeCachedDuplicates", "messages", "buildCachePoints", "Lai/grazie/model/llm/chat/caching/LLMCachePoints;", "toAttributes", "Lai/grazie/utils/attributes/Attributes;", "buildAttributes", "profile", "Lai/grazie/model/llm/profile/LLMProfileID;", "(Lai/grazie/model/llm/profile/LLMProfileID;Lcom/intellij/ml/llm/agents/claude/code/proxy/MessageRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processCodeRequest", "Lcom/intellij/ml/llm/agents/claude/code/proxy/MessageResponse;", "project", "Lcom/intellij/openapi/project/Project;", "client", "Lcom/intellij/ml/llm/grazie/client/GrazieApiClient;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/grazie/client/GrazieApiClient;Lcom/intellij/ml/llm/agents/claude/code/proxy/MessageRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPromptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "patchToolCallIds", "Lai/grazie/model/llm/chat/v5/LLMChat;", "chat", "Companion", "BackendMessage", "intellij.ml.llm.agents.claude.code"})
@SourceDebugExtension(value={"SMAP\nClaudeHttpRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaudeHttpRequestHandler.kt\ncom/intellij/ml/llm/agents/claude/code/proxy/ClaudeHttpRequestHandler\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 JSON.kt\nai/grazie/utils/json/JSON\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,345:1\n222#2:346\n205#2:347\n335#3:348\n1583#4,11:349\n1878#4,2:360\n1880#4:363\n1594#4:364\n1583#4,11:365\n1878#4,2:376\n1880#4:379\n1594#4:380\n1869#4,2:382\n1563#4:384\n1634#4,3:385\n1563#4:390\n1634#4,3:391\n1#5:362\n1#5:378\n28#6:381\n37#7,2:388\n37#7,2:397\n13216#8,3:394\n*S KotlinDebug\n*F\n+ 1 ClaudeHttpRequestHandler.kt\ncom/intellij/ml/llm/agents/claude/code/proxy/ClaudeHttpRequestHandler\n*L\n71#1:346\n88#1:347\n133#1:348\n194#1:349,11\n194#1:360,2\n194#1:363\n194#1:364\n203#1:365,11\n203#1:376,2\n203#1:379\n203#1:380\n237#1:382,2\n249#1:384\n249#1:385,3\n261#1:390\n261#1:391,3\n194#1:362\n203#1:378\n220#1:381\n249#1:388,2\n338#1:397,2\n314#1:394,3\n*E\n"})
public final class ClaudeHttpRequestHandler
extends RestService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CLAUDE_API_PREFIX = "claude-proxy";

    @NotNull
    protected String getServiceName() {
        return CLAUDE_API_PREFIX;
    }

    protected int getMaxRequestsPerMinute() {
        return Integer.MAX_VALUE;
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return method == HttpMethod.GET || method == HttpMethod.POST;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context2) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        try {
            void $this$execute_u24lambda_u240;
            void this_$iv;
            MessageRequest this_$iv2;
            ByteBuf content2;
            String string;
            HttpMethod httpMethod = request2.method();
            if (Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.GET)) {
                String message;
                List list = (List)urlDecoder.parameters().get("message");
                String string2 = message = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
                if (message == null) {
                    RestService.LOG.warn("Unsupported request, 'message' parameter is expected in '" + urlDecoder.rawQuery() + "'");
                    return null;
                }
                string = message;
            } else if (Intrinsics.areEqual((Object)httpMethod, (Object)HttpMethod.POST)) {
                content2 = request2.content();
                byte[] bytes = new byte[content2.readableBytes()];
                content2.readBytes(bytes);
                string = new String(bytes, Charsets.UTF_8);
            } else {
                throw new IOException("Unsupported HTTP method: " + request2.method());
            }
            String message = string;
            try {
                content2 = ClaudeHttpRequestHandlerKt.getClaudeJson();
                String string$iv = message;
                boolean $i$f$decodeFromString = false;
                this_$iv2.getSerializersModule();
                this_$iv2 = (MessageRequest)this_$iv2.decodeFromString((DeserializationStrategy)MessageRequest.Companion.serializer(), string$iv);
            }
            catch (Exception e) {
                RestService.LOG.error("Failed to parse Claude Agent request", (Throwable)e);
                throw new IOException("Invalid request format: " + e.getMessage());
            }
            MessageRequest codeRequest = this_$iv2;
            Project project2 = RestService.Companion.getLastFocusedOrOpenedProject();
            if (project2 == null) {
                return null;
            }
            Project project3 = project2;
            GrazieApiClient grazieApiClient = GrazieApiClientProvider.Companion.getGrazieClient();
            if (grazieApiClient == null) {
                return null;
            }
            GrazieApiClient client2 = grazieApiClient;
            MessageResponse response2 = (MessageResponse)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MessageResponse>, Object>(this, project3, client2, codeRequest, null){
                int label;
                final /* synthetic */ ClaudeHttpRequestHandler this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ GrazieApiClient $client;
                final /* synthetic */ MessageRequest $codeRequest;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$client = $client;
                    this.$codeRequest = $codeRequest;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = ClaudeHttpRequestHandler.access$processCodeRequest(this.this$0, this.$project, this.$client, this.$codeRequest, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super MessageResponse> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            Object object = ClaudeHttpRequestHandlerKt.getClaudeJson();
            Object value$iv = response2;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String encodeToString = this_$iv.encodeToString((SerializationStrategy)BuiltinSerializersKt.getNullable(MessageResponse.Companion.serializer()), value$iv);
            object = encodeToString;
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Channel channel = context2.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            value$iv = object = new DefaultHttpHeaders();
            Channel channel2 = channel;
            FullHttpRequest fullHttpRequest = request2;
            String string3 = "response.json";
            byte[] byArray2 = byArray;
            ClaudeHttpRequestHandler claudeHttpRequestHandler = this;
            boolean bl = false;
            $this$execute_u24lambda_u240.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=utf-8");
            Unit unit = Unit.INSTANCE;
            claudeHttpRequestHandler.sendData(byArray2, string3, fullHttpRequest, channel2, (HttpHeaders)object);
            return null;
        }
        catch (Exception e) {
            HTTPStatusException grazieHttpException;
            HTTPStatusException hTTPStatusException = grazieHttpException = e instanceof HTTPStatusException ? (HTTPStatusException)((Object)e) : null;
            String traceId = hTTPStatusException != null ? hTTPStatusException.getTraceId() : null;
            RestService.LOG.error("Error processing Claude API request(grazie traceId=" + traceId + ")", (Throwable)e);
            if (grazieHttpException != null) {
                HttpResponseStatus httpResponseStatus = new HttpResponseStatus(grazieHttpException.getStatus(), grazieHttpException.getMessage());
                boolean bl = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request2));
                Channel channel = context2.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                RestService.Companion.sendStatus(httpResponseStatus, bl, channel);
                return null;
            }
            String string = e.getMessage();
            if (string == null) {
                string = e.toString();
            }
            return string;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<BackendMessage> buildBackendMessages(MessageRequest request2) {
        List list;
        Map toolIdToNameMap = new LinkedHashMap();
        List $this$buildBackendMessages_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (SystemContent systemContent : request2.getSystem()) {
            BackendMessage message2 = new BackendMessage((LLMChatMessage)new LLMChatSystemMessage(systemContent.getText()), systemContent.getCache_control() != null);
            $this$buildBackendMessages_u24lambda_u240.add(message2);
        }
        for (Message message : request2.getMessages()) {
            JsonElement content2 = message.getContent();
            if (content2 instanceof JsonPrimitive) {
                LLMChatMessage message3 = Intrinsics.areEqual((Object)message.getRole(), (Object)"user") ? (LLMChatMessage)new LLMChatUserMessage(((JsonPrimitive)content2).getContent()) : (LLMChatMessage)new LLMChatAssistantMessageText(((JsonPrimitive)content2).getContent(), null, 2, null);
                $this$buildBackendMessages_u24lambda_u240.add(new BackendMessage(message3, false));
                continue;
            }
            if (content2 instanceof JsonArray) {
                for (JsonElement element2 : (JsonArray)content2) {
                    try {
                        void $this$decodeFromJsonElement$iv;
                        Json json = ClaudeHttpRequestHandlerKt.getClaudeJson();
                        JsonElement json$iv = element2;
                        boolean $i$f$decodeFromJsonElement = false;
                        $this$decodeFromJsonElement$iv.getSerializersModule();
                        MessageContent contentItem = (MessageContent)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)MessageContent.Companion.serializer(), json$iv);
                        if (contentItem instanceof TextContent) {
                            LLMChatMessage message5 = Intrinsics.areEqual((Object)message.getRole(), (Object)"user") ? (LLMChatMessage)new LLMChatUserMessage(((TextContent)contentItem).getText()) : (LLMChatMessage)new LLMChatAssistantMessageText(((TextContent)contentItem).getText(), null, 2, null);
                            $this$buildBackendMessages_u24lambda_u240.add(new BackendMessage(message5, contentItem.getCache_control() != null));
                            continue;
                        }
                        if (contentItem instanceof ImageContent) {
                            if (((ImageContent)contentItem).getSource() instanceof Base64Source) {
                                LLMChatMediaMessage message4 = new LLMChatMediaMessage(ContentType.Companion.parse(((Base64Source)((ImageContent)contentItem).getSource()).getMedia_type()), ((Base64Source)((ImageContent)contentItem).getSource()).getData());
                                $this$buildBackendMessages_u24lambda_u240.add(new BackendMessage((LLMChatMessage)message4, contentItem.getCache_control() != null));
                                continue;
                            }
                            RestService.LOG.warn("Image source type " + Reflection.getOrCreateKotlinClass(((ImageContent)contentItem).getSource().getClass()) + " is not supported in LLMChat");
                            continue;
                        }
                        if (contentItem instanceof DocumentContent) {
                            RestService.LOG.warn("Document content is not supported in LLMChat");
                            continue;
                        }
                        if (contentItem instanceof ToolResultContent) {
                            String string = (String)toolIdToNameMap.get(((ToolResultContent)contentItem).getTool_use_id());
                            if (string == null) {
                                string = "";
                            }
                            String name = string;
                            LLMChatToolMessage message2 = new LLMChatToolMessage(((ToolResultContent)contentItem).getTool_use_id(), name, ((ToolResultContent)contentItem).getContent().toString());
                            $this$buildBackendMessages_u24lambda_u240.add(new BackendMessage((LLMChatMessage)message2, contentItem.getCache_control() != null));
                            continue;
                        }
                        if (contentItem instanceof ToolUseContent) {
                            toolIdToNameMap.put(((ToolUseContent)contentItem).getId(), ((ToolUseContent)contentItem).getName());
                            LLMChatAssistantMessageTool message3 = new LLMChatAssistantMessageTool(((ToolUseContent)contentItem).getId(), ((ToolUseContent)contentItem).getName(), ((ToolUseContent)contentItem).getInput().toString(), null, 8, null);
                            $this$buildBackendMessages_u24lambda_u240.add(new BackendMessage((LLMChatMessage)message3, contentItem.getCache_control() != null));
                            continue;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    catch (Exception e) {
                        RestService.LOG.error("Failed to parse content item: " + element2, (Throwable)e);
                    }
                }
                continue;
            }
            RestService.LOG.warn("Unsupported content format: " + content2);
        }
        List messages = CollectionsKt.build((List)list);
        return this.removeCachedDuplicates(messages);
    }

    private final List<BackendMessage> removeCachedDuplicates(List<BackendMessage> messages) {
        List list;
        Set witnessed = new LinkedHashSet();
        List $this$removeCachedDuplicates_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (BackendMessage message : CollectionsKt.asReversed(messages)) {
            boolean wasAdded = witnessed.add(message.getMessage());
            if (wasAdded) {
                $this$removeCachedDuplicates_u24lambda_u240.add(message);
                continue;
            }
            RestService.LOG.debug("Duplicated message removed: " + message);
        }
        List messages2 = CollectionsKt.build((List)list);
        return CollectionsKt.asReversed((List)messages2);
    }

    /*
     * WARNING - void declaration
     */
    private final LLMCachePoints buildCachePoints(List<BackendMessage> messages) {
        void $this$mapIndexedNotNullTo$iv$iv;
        void $this$mapIndexedNotNullTo$iv$iv2;
        Iterable $this$mapIndexedNotNull$iv = messages;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Iterable<LLMCachePoint> destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv2;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            LLMCachePoint it$iv$iv;
            void message;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            BackendMessage backendMessage = (BackendMessage)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            LLMChatMessage lLMChatMessage = message.getMessage();
            if ((lLMChatMessage instanceof LLMChatAssistantMessageTool || lLMChatMessage instanceof LLMChatToolMessage ? null : (message.isCached() ? new LLMCachePoint(index + 1) : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List messageCachePoints = (List)destination$iv$iv;
        Iterable $this$mapIndexedNotNull$iv2 = messages;
        boolean $i$f$mapIndexedNotNull2 = false;
        destination$iv$iv = $this$mapIndexedNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo2 = false;
        void $this$forEachIndexed$iv$iv$iv2 = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv$iv$iv2 = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv2) {
            LLMCachePoint it$iv$iv;
            void message;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object index$iv$iv = item$iv$iv$iv;
            int index$iv$iv2 = n;
            boolean bl = false;
            BackendMessage index = (BackendMessage)element$iv$iv;
            int index2 = index$iv$iv2;
            boolean bl4 = false;
            LLMChatMessage lLMChatMessage = message.getMessage();
            if ((lLMChatMessage instanceof LLMChatAssistantMessageTool || lLMChatMessage instanceof LLMChatToolMessage ? (message.isCached() ? new LLMCachePoint(index2) : null) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List toolCachePoints = (List)destination$iv$iv2;
        List list = CollectionsKt.emptyList();
        LLMCachePoints cachePoints = new LLMCachePoints(list, messageCachePoints, toolCachePoints);
        return cachePoints;
    }

    /*
     * WARNING - void declaration
     */
    private final Attributes toAttributes(LLMCachePoints $this$toAttributes) {
        void this_$iv;
        if ($this$toAttributes.getMessages().isEmpty() && $this$toAttributes.getTools().isEmpty() && $this$toAttributes.getFunctions().isEmpty()) {
            return Attributes.Companion.invoke(MapsKt.emptyMap());
        }
        JSON jSON = (JSON)JSON.Default.INSTANCE;
        LLMCachePoints value$iv = $this$toAttributes;
        boolean $i$f$string = false;
        Attributes.Value.Json encoded2 = new Attributes.Value.Json(this_$iv.string((SerializationStrategy)LLMCachePoints.Companion.serializer(), (Object)value$iv), null, 2, null);
        return Attributes.Companion.invoke(MapsKt.mapOf((Pair)TuplesKt.to((Object)LLMParameters.INSTANCE.getCachePoints(), (Object)encoded2)));
    }

    /*
     * Unable to fully structure code
     */
    private final Object buildAttributes(LLMProfileID profile, MessageRequest request, Continuation<? super Attributes> $completion) {
        if (!($completion instanceof buildAttributes.1)) ** GOTO lbl-1000
        var19_4 = $completion;
        if ((var19_4.label & -2147483648) != 0) {
            var19_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ClaudeHttpRequestHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ClaudeHttpRequestHandler.access$buildAttributes(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new Integer[2];
                var16_8 = 0;
                var15_9 = var5_7;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)profile);
                $continuation.L$1 = request;
                $continuation.L$2 = var5_7;
                $continuation.L$3 = var15_9;
                $continuation.I$0 = var16_8;
                $continuation.label = 1;
                v0 = LlmProfileService.Companion.getInstance().getModelMaxOutputTokens(GrazieUtilsKt.fromLLMProfileID((LLMProfileID)profile), (Continuation)$continuation);
                if (v0 == var20_6) {
                    return var20_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                var16_8 = $continuation.I$0;
                var15_9 = (Integer[])$continuation.L$3;
                var5_7 = (Integer[])$continuation.L$2;
                request = (MessageRequest)$continuation.L$1;
                profile = (LLMProfileID)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                var15_9[var16_8] = var17_10 = v0;
                var5_7[1] = request.getMax_tokens();
                maxOutputTokens = (Integer)CollectionsKt.minOrNull((Iterable)CollectionsKt.listOfNotNull((Object[])var5_7));
                $this$buildAttributes_u24lambda_u240 = var6_12 = MapsKt.createMapBuilder();
                $i$a$-buildMap-ClaudeHttpRequestHandler$buildAttributes$attributes$1 = false;
                if (maxOutputTokens != null) {
                    $this$buildAttributes_u24lambda_u240.put(LLMParameters.INSTANCE.getLength(), new Attributes.Value.Long((long)maxOutputTokens.intValue(), null, 2, null));
                }
                if (request.getTemperature() != null) {
                    $this$buildAttributes_u24lambda_u240.put(LLMParameters.INSTANCE.getTemperature(), new Attributes.Value.Double(request.getTemperature().doubleValue(), null, 2, null));
                }
                if (request.getTop_p() != null) {
                    $this$buildAttributes_u24lambda_u240.put(LLMParameters.INSTANCE.getTopP(), new Attributes.Value.Double(request.getTop_p().doubleValue(), null, 2, null));
                }
                $this$forEach$iv = request.getStop_sequences();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    $i$a$-forEach-ClaudeHttpRequestHandler$buildAttributes$attributes$1$1 = false;
                    $this$buildAttributes_u24lambda_u240.put(LLMParameters.INSTANCE.getStopToken(), new Attributes.Value.Text(it, null, 2, null));
                }
                $this$buildAttributes_u24lambda_u240.put(LLMParameters.INSTANCE.getParallelToolCalls(), new Attributes.Value.Bool(true, null, 2, null));
                attributes = MapsKt.build((Map)var6_12);
                return Attributes.Companion.invoke(attributes);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object processCodeRequest(Project project, GrazieApiClient client, MessageRequest request, Continuation<? super MessageResponse> $completion) {
        if (!($completion instanceof processCodeRequest.1)) ** GOTO lbl-1000
        var33_5 = $completion;
        if ((var33_5.label & -2147483648) != 0) {
            var33_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                Object L$14;
                Object L$15;
                Object L$16;
                Object L$17;
                /* synthetic */ Object result;
                final /* synthetic */ ClaudeHttpRequestHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ClaudeHttpRequestHandler.access$processCodeRequest(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var45_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                messages = this.buildBackendMessages(request);
                var7_9 = messages;
                var22_10 = this;
                $i$f$map = false;
                var9_13 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var14_19 = (BackendMessage)item$iv$iv /* !! */ ;
                    var25_23 = destination$iv$iv;
                    $i$a$-map-ClaudeHttpRequestHandler$processCodeRequest$chat$1 = false;
                    var25_23.add(it.getMessage());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                var34_24 = thisCollection$iv.toArray(new LLMChatMessage[0]);
                chat = var22_10.patchToolCallIds(new LLMChat(var34_24));
                promptId = this.getPromptId(request);
                $continuation.L$0 = project;
                $continuation.L$1 = client;
                $continuation.L$2 = request;
                $continuation.L$3 = messages;
                $continuation.L$4 = chat;
                $continuation.L$5 = promptId;
                $continuation.label = 1;
                v0 = LlmProfileService.Companion.getInstance().getLlmProfileId(promptId, (Continuation)$continuation);
                if (v0 == var45_7) {
                    return var45_7;
                }
                ** GOTO lbl53
            }
            case 1: {
                promptId = (LLMPromptID)$continuation.L$5;
                chat = (LLMChat)$continuation.L$4;
                messages = (List)$continuation.L$3;
                request = (MessageRequest)$continuation.L$2;
                client = (GrazieApiClient)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl53:
                // 2 sources

                profile = (LLMProfileID)v0;
                cachePoints = this.buildCachePoints(messages);
                $continuation.L$0 = project;
                $continuation.L$1 = client;
                $continuation.L$2 = request;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)messages);
                $continuation.L$4 = chat;
                $continuation.L$5 = promptId;
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)profile);
                $continuation.L$7 = cachePoints;
                $continuation.label = 2;
                v1 = this.buildAttributes(profile, request, (Continuation<? super Attributes>)$continuation);
                if (v1 == var45_7) {
                    return var45_7;
                }
                ** GOTO lbl79
            }
            case 2: {
                cachePoints = (LLMCachePoints)$continuation.L$7;
                profile = (LLMProfileID)$continuation.L$6;
                promptId = (LLMPromptID)$continuation.L$5;
                chat = (LLMChat)$continuation.L$4;
                messages = (List)$continuation.L$3;
                request = (MessageRequest)$continuation.L$2;
                client = (GrazieApiClient)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl79:
                // 2 sources

                attributes = ((Attributes)v1).plus(this.toAttributes(cachePoints));
                item$iv$iv /* !! */  = request.getTools();
                var26_26 = attributes;
                var25_23 = chat;
                var24_27 = promptId;
                var23_28 = project;
                var22_10 = client;
                $i$f$map = false;
                $i$a$-map-ClaudeHttpRequestHandler$processCodeRequest$chat$1 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var20_33 = (Tool)item$iv$iv;
                    var27_35 = destination$iv$iv;
                    $i$a$-map-ClaudeHttpRequestHandler$processCodeRequest$flow$1 = false;
                    var27_35.add(LlmFunctionConverterKt.toLlmFunctionDescriptor((Tool)it));
                }
                var27_35 = (List)destination$iv$iv;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$2 = request;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)messages);
                $continuation.L$4 = chat;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)promptId);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)profile);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)cachePoints);
                $continuation.L$8 = attributes;
                $continuation.label = 3;
                v2 = var22_10.sendChatRequestPrivacyUnsafe(var23_28, (LLMPromptID)var24_27, (LLMChat)var25_23, (Attributes)var26_26, (List)var27_35, false, true, (Continuation)$continuation);
                if (v2 == var45_7) {
                    return var45_7;
                }
                ** GOTO lbl124
            }
            case 3: {
                attributes = (Attributes)$continuation.L$8;
                cachePoints = (LLMCachePoints)$continuation.L$7;
                profile = (LLMProfileID)$continuation.L$6;
                promptId = (LLMPromptID)$continuation.L$5;
                chat = (LLMChat)$continuation.L$4;
                messages = (List)$continuation.L$3;
                request = (MessageRequest)$continuation.L$2;
                client = (GrazieApiClient)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl124:
                // 2 sources

                v3 = (Flow)v2;
                if (v3 == null) {
                    return null;
                }
                flow = v3;
                contentBuilder = new ClaudeResponseContentBuilder();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$2 = request;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)messages);
                $continuation.L$4 = chat;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)promptId);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)profile);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)cachePoints);
                $continuation.L$8 = attributes;
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)flow);
                $continuation.L$10 = contentBuilder;
                $continuation.label = 4;
                v4 = flow.collect(new FlowCollector(contentBuilder){
                    final /* synthetic */ ClaudeResponseContentBuilder $contentBuilder;
                    {
                        this.$contentBuilder = $contentBuilder;
                    }

                    public final Object emit(AiaLlmStreamData it, Continuation<? super Unit> $completion) {
                        this.$contentBuilder.append(it);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation);
                if (v4 == var45_7) {
                    return var45_7;
                }
                ** GOTO lbl159
            }
            case 4: {
                contentBuilder = (ClaudeResponseContentBuilder)$continuation.L$10;
                flow = (Flow)$continuation.L$9;
                attributes = (Attributes)$continuation.L$8;
                cachePoints = (LLMCachePoints)$continuation.L$7;
                profile = (LLMProfileID)$continuation.L$6;
                promptId = (LLMPromptID)$continuation.L$5;
                chat = (LLMChat)$continuation.L$4;
                messages = (List)$continuation.L$3;
                request = (MessageRequest)$continuation.L$2;
                client = (GrazieApiClient)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl159:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$2 = request;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)messages);
                $continuation.L$4 = chat;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)promptId);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)profile);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)cachePoints);
                $continuation.L$8 = attributes;
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)flow);
                $continuation.L$10 = contentBuilder;
                $continuation.label = 5;
                v5 = TokenizerAccessPointService.Companion.getInstance().getTokenizer((Continuation<? super Tokenizer>)$continuation);
                if (v5 == var45_7) {
                    return var45_7;
                }
                ** GOTO lbl189
            }
            case 5: {
                contentBuilder = (ClaudeResponseContentBuilder)$continuation.L$10;
                flow = (Flow)$continuation.L$9;
                attributes = (Attributes)$continuation.L$8;
                cachePoints = (LLMCachePoints)$continuation.L$7;
                profile = (LLMProfileID)$continuation.L$6;
                promptId = (LLMPromptID)$continuation.L$5;
                chat = (LLMChat)$continuation.L$4;
                messages = (List)$continuation.L$3;
                request = (MessageRequest)$continuation.L$2;
                client = (GrazieApiClient)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl189:
                // 2 sources

                tokenizer = (Tokenizer)v5;
                var30_36 = null;
                var29_37 = contentBuilder.getStopReason();
                var28_38 = contentBuilder.build();
                var27_35 = request.getModel();
                var26_26 = "assistant";
                var25_23 = "message";
                var24_27 = "msg_" + System.currentTimeMillis();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)messages);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)chat);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)promptId);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)profile);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)cachePoints);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)attributes);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)flow);
                $continuation.L$10 = contentBuilder;
                $continuation.L$11 = tokenizer;
                $continuation.L$12 = var24_27;
                $continuation.L$13 = var25_23;
                $continuation.L$14 = var26_26;
                $continuation.L$15 = var27_35;
                $continuation.L$16 = var28_38;
                $continuation.L$17 = var29_37;
                $continuation.label = 6;
                v6 = tokenizer.countTokensInChat(chat, attributes, (Continuation<? super Integer>)$continuation);
                if (v6 == var45_7) {
                    return var45_7;
                }
                ** GOTO lbl242
            }
            case 6: {
                var30_36 = null;
                var29_37 = (String)$continuation.L$17;
                var28_38 = (List<MessageContent>)$continuation.L$16;
                var27_35 = (String)$continuation.L$15;
                var26_26 = (String)$continuation.L$14;
                var25_23 = (String)$continuation.L$13;
                var24_27 = (String)$continuation.L$12;
                tokenizer = (Tokenizer)$continuation.L$11;
                contentBuilder = (ClaudeResponseContentBuilder)$continuation.L$10;
                flow = (Flow)$continuation.L$9;
                attributes = (Attributes)$continuation.L$8;
                cachePoints = (LLMCachePoints)$continuation.L$7;
                profile = (LLMProfileID)$continuation.L$6;
                promptId = (LLMPromptID)$continuation.L$5;
                chat = (LLMChat)$continuation.L$4;
                messages = (List)$continuation.L$3;
                request = (MessageRequest)$continuation.L$2;
                client = (GrazieApiClient)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl242:
                // 2 sources

                var31_39 = v6;
                var35_40 = contentBuilder.getTokensCount(tokenizer);
                var36_41 = ((Number)var31_39).intValue();
                var37_42 = new Usage(var36_41, var35_40);
                var38_43 = var30_36;
                var39_44 = var29_37;
                var40_45 = var28_38;
                var41_46 = var27_35;
                var42_47 = var26_26;
                var43_48 = var25_23;
                var44_49 = var24_27;
                return new MessageResponse((String)var44_49, (String)var43_48, var42_47, (String)var41_46, var40_45, var39_44, var38_43, var37_42);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final LLMPromptID getPromptId(MessageRequest request2) {
        LLMPromptID lLMPromptID;
        if (StringsKt.startsWith$default((String)request2.getModel(), (String)"claude-sonnet-4", (boolean)false, (int)2, null)) {
            lLMPromptID = new LLMPromptID("ij.anthropic.proxy.to.sonnet-4");
        } else if (StringsKt.startsWith$default((String)request2.getModel(), (String)"claude-3-5-sonnet", (boolean)false, (int)2, null)) {
            lLMPromptID = new LLMPromptID("ij.anthropic.proxy.to.sonnet-3-5");
        } else if (StringsKt.startsWith$default((String)request2.getModel(), (String)"claude-opus-4", (boolean)false, (int)2, null)) {
            lLMPromptID = new LLMPromptID("ij.anthropic.proxy.to.opus-4");
        } else if (StringsKt.startsWith$default((String)request2.getModel(), (String)"claude-haiku", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)request2.getModel(), (String)"claude-3-5-haiku", (boolean)false, (int)2, null)) {
            lLMPromptID = new LLMPromptID("ij.anthropic.proxy.to.haiku");
        } else {
            RestService.LOG.error("Unsupported claude model: '" + request2.getModel() + "', fallback to sonnet");
            lLMPromptID = new LLMPromptID("ij.anthropic.proxy.to.sonnet");
        }
        return lLMPromptID;
    }

    /*
     * WARNING - void declaration
     */
    private final LLMChat patchToolCallIds(LLMChat chat) {
        void $this$fold$iv;
        void initial$iv22;
        LLMChatMessage[] lLMChatMessageArray = chat.getMessages();
        List list = new ArrayList();
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv22;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void msg;
            void element$iv;
            void var10_14 = element$iv = $this$fold$iv[i];
            void acc = accumulator$iv;
            boolean bl = false;
            KClass key = Reflection.getOrCreateKotlinClass(msg.getClass());
            if (acc.isEmpty() || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(CollectionsKt.last((List)((List)CollectionsKt.last((List)acc))).getClass()), (Object)key)) {
                Object[] objectArray = new LLMChatMessage[]{msg};
                v0 = acc.add(CollectionsKt.mutableListOf((Object[])objectArray));
            } else {
                v0 = ((List)CollectionsKt.last((List)acc)).add(msg);
            }
            accumulator$iv = acc;
        }
        void groupedMessages = accumulator$iv;
        int initial$iv22 = CollectionsKt.getLastIndex((List)groupedMessages);
        for (int i = 0; i < initial$iv22; ++i) {
            List group1 = (List)groupedMessages.get(i);
            List group2 = (List)groupedMessages.get(i + 1);
            if (!(CollectionsKt.last((List)group1) instanceof LLMChatAssistantMessageTool) || !(CollectionsKt.last((List)group2) instanceof LLMChatToolMessage)) continue;
            if (group1.size() != group2.size()) {
                throw new IllegalStateException("Unexpected format of tool calls and tool responses, each call should have a response");
            }
            n = group1.size();
            for (int j = 0; j < n; ++j) {
                String toolUseId = "toolu_" + System.currentTimeMillis() + i + j;
                List list2 = (List)groupedMessages.get(i);
                Object e = group1.get(j);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type ai.grazie.model.llm.chat.v5.LLMChatAssistantMessageTool");
                list2.set(j, LLMChatAssistantMessageTool.copy$default((LLMChatAssistantMessageTool)((LLMChatAssistantMessageTool)e), (String)toolUseId, null, null, null, (int)14, null));
                List list3 = (List)groupedMessages.get(i + 1);
                Object e2 = group2.get(j);
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type ai.grazie.model.llm.chat.v5.LLMChatToolMessage");
                list3.set(j, LLMChatToolMessage.copy$default((LLMChatToolMessage)((LLMChatToolMessage)e2), (String)toolUseId, null, null, (int)6, null));
            }
        }
        Collection $this$toTypedArray$iv = CollectionsKt.flatten((Iterable)((Iterable)groupedMessages));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new LLMChat(thisCollection$iv.toArray(new LLMChatMessage[0]));
    }

    public static final /* synthetic */ Object access$processCodeRequest(ClaudeHttpRequestHandler $this, Project project2, GrazieApiClient client2, MessageRequest request2, Continuation $completion) {
        return $this.processCodeRequest(project2, client2, request2, (Continuation<? super MessageResponse>)$completion);
    }

    public static final /* synthetic */ Object access$buildAttributes(ClaudeHttpRequestHandler $this, LLMProfileID profile2, MessageRequest request2, Continuation $completion) {
        return $this.buildAttributes(profile2, request2, (Continuation<? super Attributes>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/proxy/ClaudeHttpRequestHandler$BackendMessage;", "", "message", "Lai/grazie/model/llm/chat/v5/LLMChatMessage;", "isCached", "", "<init>", "(Lai/grazie/model/llm/chat/v5/LLMChatMessage;Z)V", "getMessage", "()Lai/grazie/model/llm/chat/v5/LLMChatMessage;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.ml.llm.agents.claude.code"})
    private static final class BackendMessage {
        @NotNull
        private final LLMChatMessage message;
        private final boolean isCached;

        public BackendMessage(@NotNull LLMChatMessage message, boolean isCached) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.message = message;
            this.isCached = isCached;
        }

        @NotNull
        public final LLMChatMessage getMessage() {
            return this.message;
        }

        public final boolean isCached() {
            return this.isCached;
        }

        @NotNull
        public final LLMChatMessage component1() {
            return this.message;
        }

        public final boolean component2() {
            return this.isCached;
        }

        @NotNull
        public final BackendMessage copy(@NotNull LLMChatMessage message, boolean isCached) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new BackendMessage(message, isCached);
        }

        public static /* synthetic */ BackendMessage copy$default(BackendMessage backendMessage, LLMChatMessage lLMChatMessage, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                lLMChatMessage = backendMessage.message;
            }
            if ((n & 2) != 0) {
                bl = backendMessage.isCached;
            }
            return backendMessage.copy(lLMChatMessage, bl);
        }

        @NotNull
        public String toString() {
            return "BackendMessage(message=" + this.message + ", isCached=" + this.isCached + ")";
        }

        public int hashCode() {
            int result2 = this.message.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isCached);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BackendMessage)) {
                return false;
            }
            BackendMessage backendMessage = (BackendMessage)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)backendMessage.message)) {
                return false;
            }
            return this.isCached == backendMessage.isCached;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/agents/claude/code/proxy/ClaudeHttpRequestHandler$Companion;", "", "<init>", "()V", "CLAUDE_API_PREFIX", "", "intellij.ml.llm.agents.claude.code"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

