/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.diff.codeFormatter;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.ml.llm.codeGeneration.diff.AIImportFixer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/codeGeneration/diff/codeFormatter/AICodeFormatter;", "", "<init>", "()V", "reformat", "", "file", "Lcom/intellij/psi/PsiFile;", "ranges", "", "Lcom/intellij/openapi/editor/RangeMarker;", "optimizeImports", "scheduleImportFixes", "editor", "Lcom/intellij/openapi/editor/Editor;", "finalizeChangeRanges", "", "Lcom/intellij/openapi/util/TextRange;", "changeRanges", "documentLength", "", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nAICodeFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AICodeFormatter.kt\ncom/intellij/ml/llm/codeGeneration/diff/codeFormatter/AICodeFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1869#2,2:53\n1056#2:55\n774#2:56\n865#2,2:57\n1563#2:59\n1634#2,3:60\n*S KotlinDebug\n*F\n+ 1 AICodeFormatter.kt\ncom/intellij/ml/llm/codeGeneration/diff/codeFormatter/AICodeFormatter\n*L\n16#1:53,2\n31#1:55\n48#1:56\n48#1:57,2\n49#1:59\n49#1:60,3\n*E\n"})
public final class AICodeFormatter {
    @NotNull
    public static final AICodeFormatter INSTANCE = new AICodeFormatter();
    public static final int $stable;

    private AICodeFormatter() {
    }

    public final void reformat(@NotNull PsiFile file2, @NotNull List<? extends RangeMarker> ranges2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        if (ranges2.isEmpty()) {
            return;
        }
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        Iterable $this$forEach$iv = ranges2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeMarker range = (RangeMarker)element$iv;
            boolean bl = false;
            CodeStyleManager.getInstance((Project)project3).reformatText(file2, range.getStartOffset(), range.getEndOffset());
        }
    }

    public final void optimizeImports(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        new OptimizeImportsProcessor(file2.getProject(), file2).run();
    }

    public final void scheduleImportFixes(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull List<? extends RangeMarker> ranges2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        AIImportFixer.Companion.scheduleAutoImport(file2, editor2, ranges2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> finalizeChangeRanges(@NotNull List<? extends TextRange> changeRanges, int documentLength) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TextRange it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(changeRanges, (String)"changeRanges");
        if (changeRanges.isEmpty()) {
            return new ArrayList();
        }
        Iterable $this$sortedBy$iv = CollectionsKt.toSet((Iterable)changeRanges);
        boolean $i$f$sortedBy = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange p0 = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(p0.getStartOffset());
                p0 = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getStartOffset()));
            }
        });
        List finalizedRanges = new ArrayList();
        Iterator rangeIterator = sortedRanges.iterator();
        TextRange currentRange = (TextRange)rangeIterator.next();
        while (rangeIterator.hasNext()) {
            TextRange nextRange = (TextRange)rangeIterator.next();
            if (currentRange.getEndOffset() >= nextRange.getStartOffset()) {
                int endOfIntersect = Math.max(currentRange.getEndOffset(), nextRange.getEndOffset());
                currentRange = new TextRange(currentRange.getStartOffset(), endOfIntersect);
                continue;
            }
            finalizedRanges.add(currentRange);
            currentRange = nextRange;
        }
        finalizedRanges.add(new TextRange(currentRange.getStartOffset(), currentRange.getEndOffset()));
        Iterable $this$filter$iv = finalizedRanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TextRange)element$iv$iv;
            boolean bl = false;
            if (!(it.getStartOffset() <= documentLength)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TextRange(it.getStartOffset(), Math.min(it.getEndOffset(), documentLength)));
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }
}

