/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.logging.file;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.StepEntry;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.logging.file.LogFileWriter;
import com.intellij.ml.llm.codeGeneration.lightAgent.steps.events.logging.file.SessionWriterManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.CoroutineScopeKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/SessionWriterManager;", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "logDir", "Ljava/nio/file/Path;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Ljava/nio/file/Path;)V", "writers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/SessionWriterManager$SessionWriter;", "writeEntry", "", "stepEntry", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/StepEntry;", "createSessionWriter", "sessionId", "prepareLogFile", "file", "dispose", "SessionWriter", "intellij.ml.llm.codeGeneration"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSessionWriterManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionWriterManager.kt\ncom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/SessionWriterManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1869#2,2:81\n*S KotlinDebug\n*F\n+ 1 SessionWriterManager.kt\ncom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/SessionWriterManager\n*L\n53#1:81,2\n*E\n"})
public final class SessionWriterManager
implements Disposable {
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Path logDir;
    @NotNull
    private final ConcurrentHashMap<String, SessionWriter> writers;
    public static final int $stable = 8;

    public SessionWriterManager(@NotNull CoroutineScope scope, @NotNull Path logDir) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)logDir, (String)"logDir");
        this.scope = scope;
        this.logDir = logDir;
        this.writers = new ConcurrentHashMap();
    }

    public final void writeEntry(@NotNull StepEntry stepEntry) {
        Intrinsics.checkNotNullParameter((Object)stepEntry, (String)"stepEntry");
        SessionWriter sessionWriter = this.writers.computeIfAbsent(stepEntry.getSessionId(), arg_0 -> SessionWriterManager.writeEntry$lambda$1(arg_0 -> SessionWriterManager.writeEntry$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sessionWriter, (String)"computeIfAbsent(...)");
        SessionWriter writer = sessionWriter;
        writer.writeEntry(stepEntry);
    }

    private final SessionWriter createSessionWriter(String sessionId) {
        Path file2 = this.logDir.resolve(sessionId + ".log");
        Intrinsics.checkNotNull((Object)file2);
        this.prepareLogFile(file2, sessionId);
        return new SessionWriter(this.scope, sessionId, file2);
    }

    private final void prepareLogFile(Path file2, String sessionId) {
        try {
            Path path = file2.getParent();
            if (path != null) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path2 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                v3 = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(...)");
            } else {
                v3 = null;
            }
        }
        catch (Exception e) {
            SessionWriterManagerKt.access$getLOG$p().warn("Failed to prepare dump file for session " + sessionId + " at " + file2, (Throwable)e);
        }
    }

    public void dispose() {
        Collection<SessionWriter> collection = this.writers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SessionWriter it = (SessionWriter)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.writers.clear();
    }

    private static final SessionWriter writeEntry$lambda$0(SessionWriterManager this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createSessionWriter(it);
    }

    private static final SessionWriter writeEntry$lambda$1(Function1 $tmp0, Object p0) {
        return (SessionWriter)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/SessionWriterManager$SessionWriter;", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "sessionId", "", "file", "Ljava/nio/file/Path;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;Ljava/nio/file/Path;)V", "getSessionId", "()Ljava/lang/String;", "getFile", "()Ljava/nio/file/Path;", "channel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/StepEntry;", "job", "", "Lkotlin/Unit;", "dispose", "writeEntry", "entry", "intellij.ml.llm.codeGeneration"})
    @SourceDebugExtension(value={"SMAP\nSessionWriterManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionWriterManager.kt\ncom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/SessionWriterManager$SessionWriter\n+ 2 Channel.kt\nkotlinx/coroutines/channels/ChannelKt\n*L\n1#1,80:1\n1029#2,2:81\n*S KotlinDebug\n*F\n+ 1 SessionWriterManager.kt\ncom/intellij/ml/llm/codeGeneration/lightAgent/steps/events/logging/file/SessionWriterManager$SessionWriter\n*L\n75#1:81,2\n*E\n"})
    private static final class SessionWriter
    implements Disposable {
        @NotNull
        private final String sessionId;
        @NotNull
        private final Path file;
        @NotNull
        private final Channel<StepEntry> channel;
        @NotNull
        private final Unit job;

        public SessionWriter(@NotNull CoroutineScope scope, @NotNull String sessionId, @NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.sessionId = sessionId;
            this.file = file2;
            this.channel = ChannelKt.Channel$default((int)1024, (BufferOverflow)BufferOverflow.DROP_OLDEST, null, (int)4, null);
            CoroutineScopeKt.cancelOnDispose((Job)BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("LightAgentSessionDumpWriter-" + this.sessionId)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ SessionWriter this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object invokeSuspend(Object $result) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            try {
                                var2_3 = SessionWriter.access$getChannel$p(this.this$0).iterator();
                            }
                            catch (Throwable t) {
                                if (t instanceof CancellationException || t instanceof ControlFlowException) {
                                    throw t;
                                }
                                SessionWriterManagerKt.access$getLOG$p().warn("Writer coroutine failed for session " + this.this$0.getSessionId(), t);
                                return Unit.INSTANCE;
                            }
lbl14:
                            // 2 sources

                            while (true) {
                                this.L$0 = var2_3;
                                this.label = 1;
                                v0 = var2_3.hasNext((Continuation)this);
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl26
                                break;
                            }
                        }
                        case 1: {
                            var2_3 = (ChannelIterator)this.L$0;
                            {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl26:
                                // 2 sources

                                if (!((Boolean)v0).booleanValue()) return Unit.INSTANCE;
                                entry = (StepEntry)var2_3.next();
                                LogFileWriter.Companion.writeEntry(this.this$0.getFile(), entry);
                                ** continue;
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null), (Disposable)this);
            this.job = Unit.INSTANCE;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public final Path getFile() {
            return this.file;
        }

        public void dispose() {
            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.channel), null, (int)1, null);
        }

        public final void writeEntry(@NotNull StepEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Object $this$onFailure_u2dWpGqRn0$iv = this.channel.trySend-JP2dKIU((Object)entry);
            boolean bl = false;
            if ($this$onFailure_u2dWpGqRn0$iv instanceof ChannelResult.Failed) {
                Throwable it = ChannelResult.exceptionOrNull-impl((Object)$this$onFailure_u2dWpGqRn0$iv);
                boolean bl2 = false;
                SessionWriterManagerKt.access$getLOG$p().warn("Failed to enqueue Light Agent dump entry for session " + this.sessionId, it);
            }
        }

        public static final /* synthetic */ Channel access$getChannel$p(SessionWriter $this) {
            return $this.channel;
        }
    }
}

