/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.actions;

import com.intellij.ml.llm.context.actions.RequestTreeBucketNode;
import com.intellij.ml.llm.context.actions.RequestTreeLeafNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.time.Duration;
import java.time.Instant;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/context/actions/RequestCellRenderer;", "Lcom/intellij/ui/CheckboxTree$CheckboxTreeCellRenderer;", "<init>", "()V", "timestamp", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "customizeRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.ml.llm.context"})
final class RequestCellRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    private final Instant timestamp = Instant.now();

    public void customizeRenderer(@NotNull JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
        if (value instanceof RequestTreeBucketNode) {
            Duration elapsedTime = Duration.between(((RequestTreeBucketNode)((Object)value)).getLatestRequestTimestamp(), this.timestamp);
            String bucketName = ((RequestTreeBucketNode)((Object)value)).getRequestType().getSimpleName() + " (" + elapsedTime.toSeconds() + "s ago)";
            textRenderer.append(bucketName, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        } else if (value instanceof RequestTreeLeafNode) {
            Duration elapsedTime = Duration.between(((RequestTreeLeafNode)((Object)value)).getExecution().getTimestamp(), this.timestamp);
            String string = StringUtil.shortenTextWithEllipsis((String)((RequestTreeLeafNode)((Object)value)).getRequest().toString(), (int)64, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            String shortRequestName = string;
            textRenderer.append(shortRequestName + " (" + elapsedTime.toSeconds() + "s ago)", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        }
    }
}

