/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.airules.context;

import com.intellij.DynamicBundle;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.context.airules.AiRulesLLMBundle;
import com.intellij.ml.llm.context.airules.context.AiRuleContextAttachment;
import com.intellij.ml.llm.context.airules.context.AiRuleContextSource;
import com.intellij.ml.llm.context.airules.metadata.AiRuleType;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.RenderableChatAttachment;
import com.intellij.ml.llm.core.chat.attachments.VisibleChatAttachment;
import com.intellij.ml.llm.core.chat.context.renderer.ChatAttachmentRenderBuilder;
import com.intellij.ml.llm.core.chat.context.renderer.ChatAttachmentTagsRegistry;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachment;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/context/airules/context/AiRuleChatAttachment;", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "Lcom/intellij/ml/llm/core/chat/attachments/VisibleChatAttachment;", "Lcom/intellij/ml/llm/core/chat/attachments/RenderableChatAttachment;", "project", "Lcom/intellij/openapi/project/Project;", "aiRuleFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "Lcom/intellij/ml/llm/privacy/PSString;", "ruleType", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;)V", "toContextAttachment", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachment;", "renderMetadata", "", "builder", "Lcom/intellij/ml/llm/core/chat/context/renderer/ChatAttachmentRenderBuilder;", "intellij.ml.llm.context.airules"})
public final class AiRuleChatAttachment
extends ChatAttachment
implements VisibleChatAttachment,
RenderableChatAttachment {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile aiRuleFile;
    @NotNull
    private final AiRuleType ruleType;

    public AiRuleChatAttachment(@NotNull Project project2, @NotNull VirtualFile aiRuleFile, @NotNull PSString content2, @NotNull AiRuleType ruleType2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)aiRuleFile, (String)"aiRuleFile");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)ruleType2), (String)"ruleType");
        PSString pSString = ExtensionsKtKt.getPrivacySafe(aiRuleFile).getName();
        ChatAttachment.Kind kind = ChatAttachment.Kind.Visible;
        AiRuleContextSource aiRuleContextSource = new AiRuleContextSource(ruleType2.retrieverType());
        LightFilePointer lightFilePointer = new LightFilePointer(aiRuleFile);
        super(pSString, content2, kind, (VirtualFilePointer)lightFilePointer, (ContextEntitySource)((Object)aiRuleContextSource), content2, null, 64, null);
        this.project = project2;
        this.aiRuleFile = aiRuleFile;
        this.ruleType = ruleType2;
    }

    @NotNull
    public ContextAttachment toContextAttachment() {
        return (ContextAttachment)new AiRuleContextAttachment(this.project, this.aiRuleFile, this.getRawText(), this.ruleType, null, 16, null);
    }

    public void renderMetadata(@NotNull ChatAttachmentRenderBuilder builder) {
        ChatAttachmentRenderBuilder chatAttachmentRenderBuilder;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ChatAttachmentRenderBuilder $this$renderMetadata_u24lambda_u240 = chatAttachmentRenderBuilder = builder;
        boolean bl = false;
        $this$renderMetadata_u24lambda_u240.tag(ChatAttachmentTagsRegistry.DESCRIPTION, AiRuleChatAttachment::renderMetadata$lambda$0$0);
    }

    private static final Unit renderMetadata$lambda$0$0(ChatAttachmentRenderBuilder $this$tag) {
        Intrinsics.checkNotNullParameter((Object)$this$tag, (String)"$this$tag");
        $this$tag.text(PSStringOperatorsKt.getMessagePrivacySafe((DynamicBundle)AiRulesLLMBundle.INSTANCE, (String)"ai.rule.model.instruction"));
        return Unit.INSTANCE;
    }
}

