/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.provider.postprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e*\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000e0\u0010*\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/JaccardSimilarity;", "", "<init>", "()V", "tokenRegex", "Lkotlin/text/Regex;", "threshold", "", "isSimilar", "", "first", "", "second", "tokenize", "", "threeGrams", "", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nJaccardSimilarity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JaccardSimilarity.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/JaccardSimilarity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,21:1\n774#2:22\n865#2:23\n866#2:26\n774#2:27\n865#2:28\n866#2:31\n1563#2:32\n1634#2,3:33\n1069#3,2:24\n1069#3,2:29\n*S KotlinDebug\n*F\n+ 1 JaccardSimilarity.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/JaccardSimilarity\n*L\n9#1:22\n9#1:23\n9#1:26\n10#1:27\n10#1:28\n10#1:31\n20#1:32\n20#1:33,3\n9#1:24,2\n10#1:29,2\n*E\n"})
public final class JaccardSimilarity {
    @NotNull
    public static final JaccardSimilarity INSTANCE = new JaccardSimilarity();
    @NotNull
    private static final Regex tokenRegex = new Regex("[A-Za-z_]\\w*|\\d+|[^\\s\\w]");
    private static final double threshold = 0.6;

    private JaccardSimilarity() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSimilar(@NotNull String first, @Nullable String second) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        if (second == null) {
            return false;
        }
        Iterable $this$filter$iv = this.tokenize(((Object)StringsKt.trim((CharSequence)first)).toString());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            boolean bl;
            block6: {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                CharSequence $this$all$iv = it;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$all$iv.charAt(i);
                    boolean bl3 = false;
                    if (Character.isLetterOrDigit(c)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List firstTokens = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = this.tokenize(((Object)StringsKt.trim((CharSequence)second)).toString());
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block7: {
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                CharSequence $this$all$iv = it;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$all$iv.charAt(i);
                    boolean bl5 = false;
                    if (Character.isLetterOrDigit(c)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List secondTokens = (List)destination$iv$iv2;
        int intersection = CollectionsKt.intersect((Iterable)firstTokens, (Iterable)secondTokens).size();
        int union = CollectionsKt.union((Iterable)firstTokens, (Iterable)secondTokens).size();
        if (union == 0) {
            return true;
        }
        double jaccard = (double)intersection / (double)union;
        return jaccard >= 0.6;
    }

    private final List<String> tokenize(String $this$tokenize) {
        String string = $this$tokenize.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)tokenRegex, (CharSequence)string, (int)0, (int)2, null), JaccardSimilarity::tokenize$lambda$0));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<List<String>> threeGrams(List<String> $this$threeGrams) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)new IntRange(0, $this$threeGrams.size() - 3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($this$threeGrams.subList((int)it, (int)(it + 3)));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final String tokenize$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }
}

