/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.logs;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.LongListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.ml.llm.core.settings.SettingsSources;
import com.intellij.ml.llm.daemon.insight.InsightEventListener;
import com.intellij.ml.llm.daemon.insight.rating.InsightRating;
import com.intellij.ml.llm.daemon.insight.settings.InsightsFrequency;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010%\u001a\u00020\u0005H\u0016J*\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+J\u0016\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0015J\u0016\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0015J\u0016\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\u000fJ\u000e\u00107\u001a\u00020'2\u0006\u00105\u001a\u00020,J\u0016\u00108\u001a\u00020'2\u0006\u00105\u001a\u00020,2\u0006\u00109\u001a\u00020\u0017J\u000e\u0010:\u001a\u00020'2\u0006\u00105\u001a\u00020,J\u000e\u0010;\u001a\u00020'2\u0006\u00105\u001a\u00020,J&\u0010<\u001a\u00020'2\u0006\u00105\u001a\u00020,2\u0006\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/ml/llm/daemon/insight/logs/InsightsFUSCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "NEW_PROCESSED_LINES", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "NEW_POSTPROCESSED_INSIGHTS", "Lcom/intellij/internal/statistic/eventLog/events/LongListEventField;", "CACHED_POSTPROCESSED_INSIGHTS", "INSIGHT_ID", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "RATING", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$Rating;", "INSIGHTS_ENABLED", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "INSIGHTS_FREQUENCY", "Lcom/intellij/ml/llm/daemon/insight/settings/InsightsFrequency;", "SETTINGS_SOURCE", "Lcom/intellij/ml/llm/core/settings/SettingsSources;", "COMMENT_TYPE", "Lcom/intellij/ml/llm/daemon/insight/InsightEventListener$InsertedAsComment$CommentType;", "GOTO_TOTAL_COUNT", "GOTO_WITHIN_INSIGHT_RANGE_COUNT", "CARET_MOVES_COUNT", "requestEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "enabledChangedEvent", "frequencyChangedEvent", "ratedEvent", "copiedEvent", "insertedAsCommentEvent", "hiddenEvent", "hoveredEvent", "interactionBatchedEvent", "getGroup", "logRequestEvent", "", "newProcessedLines", "", "newPostProcessedInsightIds", "", "", "cachedPostProcessedInsightIds", "logEnabledChanged", "enabled", "", "source", "logFrequencyChanged", "frequency", "logRatedEvent", "insightId", "rating", "logCopiedInsight", "logInsertedAsComment", "commentType", "logHiddenInsight", "logHovered", "logInteractionBatched", "gotoTotal", "gotoWithinInsightRange", "caretMoves", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightsFUSCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightsFUSCollector.kt\ncom/intellij/ml/llm/daemon/insight/logs/InsightsFUSCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,164:1\n261#2,3:165\n261#2,3:168\n261#2,3:171\n261#2,3:174\n*S KotlinDebug\n*F\n+ 1 InsightsFUSCollector.kt\ncom/intellij/ml/llm/daemon/insight/logs/InsightsFUSCollector\n*L\n25#1:165,3\n28#1:168,3\n29#1:171,3\n31#1:174,3\n*E\n"})
public final class InsightsFUSCollector
extends CounterUsagesCollector {
    @NotNull
    public static final InsightsFUSCollector INSTANCE;
    @NotNull
    private static final EventLogGroup group;
    @NotNull
    private static final IntEventField NEW_PROCESSED_LINES;
    @NotNull
    private static final LongListEventField NEW_POSTPROCESSED_INSIGHTS;
    @NotNull
    private static final LongListEventField CACHED_POSTPROCESSED_INSIGHTS;
    @NotNull
    private static final LongEventField INSIGHT_ID;
    @NotNull
    private static final EnumEventField<InsightRating.Rating> RATING;
    @NotNull
    private static final BooleanEventField INSIGHTS_ENABLED;
    @NotNull
    private static final EnumEventField<InsightsFrequency> INSIGHTS_FREQUENCY;
    @NotNull
    private static final EnumEventField<SettingsSources> SETTINGS_SOURCE;
    @NotNull
    private static final EnumEventField<InsightEventListener.InsertedAsComment.CommentType> COMMENT_TYPE;
    @NotNull
    private static final IntEventField GOTO_TOTAL_COUNT;
    @NotNull
    private static final IntEventField GOTO_WITHIN_INSIGHT_RANGE_COUNT;
    @NotNull
    private static final IntEventField CARET_MOVES_COUNT;
    @NotNull
    private static final VarargEventId requestEvent;
    @NotNull
    private static final VarargEventId enabledChangedEvent;
    @NotNull
    private static final VarargEventId frequencyChangedEvent;
    @NotNull
    private static final VarargEventId ratedEvent;
    @NotNull
    private static final VarargEventId copiedEvent;
    @NotNull
    private static final VarargEventId insertedAsCommentEvent;
    @NotNull
    private static final VarargEventId hiddenEvent;
    @NotNull
    private static final VarargEventId hoveredEvent;
    @NotNull
    private static final VarargEventId interactionBatchedEvent;

    private InsightsFUSCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return group;
    }

    public final void logRequestEvent(int newProcessedLines, @NotNull List<Long> newPostProcessedInsightIds, @NotNull List<Long> cachedPostProcessedInsightIds) {
        Intrinsics.checkNotNullParameter(newPostProcessedInsightIds, (String)"newPostProcessedInsightIds");
        Intrinsics.checkNotNullParameter(cachedPostProcessedInsightIds, (String)"cachedPostProcessedInsightIds");
        Object[] objectArray = new EventPair[]{NEW_PROCESSED_LINES.with((Object)newProcessedLines), NEW_POSTPROCESSED_INSIGHTS.with(newPostProcessedInsightIds), CACHED_POSTPROCESSED_INSIGHTS.with(cachedPostProcessedInsightIds)};
        requestEvent.log(CollectionsKt.listOf((Object[])objectArray));
    }

    public final void logEnabledChanged(boolean enabled, @NotNull SettingsSources source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object[] objectArray = new EventPair[]{INSIGHTS_ENABLED.with((Object)enabled), SETTINGS_SOURCE.with((Object)source)};
        enabledChangedEvent.log(CollectionsKt.listOf((Object[])objectArray));
    }

    public final void logFrequencyChanged(@NotNull InsightsFrequency frequency, @NotNull SettingsSources source) {
        Intrinsics.checkNotNullParameter((Object)((Object)frequency), (String)"frequency");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object[] objectArray = new EventPair[]{INSIGHTS_FREQUENCY.with((Object)frequency), SETTINGS_SOURCE.with((Object)source)};
        frequencyChangedEvent.log(CollectionsKt.listOf((Object[])objectArray));
    }

    public final void logRatedEvent(long insightId, @NotNull InsightRating.Rating rating) {
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        Object[] objectArray = new EventPair[]{INSIGHT_ID.with((Object)insightId), RATING.with((Object)rating)};
        ratedEvent.log(CollectionsKt.listOf((Object[])objectArray));
    }

    public final void logCopiedInsight(long insightId) {
        EventPair[] eventPairArray = new EventPair[]{INSIGHT_ID.with((Object)insightId)};
        copiedEvent.log(eventPairArray);
    }

    public final void logInsertedAsComment(long insightId, @NotNull InsightEventListener.InsertedAsComment.CommentType commentType) {
        Intrinsics.checkNotNullParameter((Object)((Object)commentType), (String)"commentType");
        Object[] objectArray = new EventPair[]{INSIGHT_ID.with((Object)insightId), COMMENT_TYPE.with((Object)commentType)};
        insertedAsCommentEvent.log(CollectionsKt.listOf((Object[])objectArray));
    }

    public final void logHiddenInsight(long insightId) {
        EventPair[] eventPairArray = new EventPair[]{INSIGHT_ID.with((Object)insightId)};
        hiddenEvent.log(eventPairArray);
    }

    public final void logHovered(long insightId) {
        EventPair[] eventPairArray = new EventPair[]{INSIGHT_ID.with((Object)insightId)};
        hoveredEvent.log(eventPairArray);
    }

    public final void logInteractionBatched(long insightId, int gotoTotal, int gotoWithinInsightRange, int caretMoves) {
        Object[] objectArray = new EventPair[]{INSIGHT_ID.with((Object)insightId), GOTO_TOTAL_COUNT.with((Object)gotoTotal), GOTO_WITHIN_INSIGHT_RANGE_COUNT.with((Object)gotoWithinInsightRange), CARET_MOVES_COUNT.with((Object)caretMoves)};
        interactionBatchedEvent.log(CollectionsKt.listOf((Object[])objectArray));
    }

    static {
        EventFields $this$iv;
        INSTANCE = new InsightsFUSCollector();
        group = new EventLogGroup("llm.daemon", 6, "FUS", "AI Insights metrics", null, 16, null);
        NEW_PROCESSED_LINES = EventFields.Int((String)"new_processed_lines");
        NEW_POSTPROCESSED_INSIGHTS = EventFields.LongList$default((String)"new_postprocessed_insights", null, (int)2, null);
        CACHED_POSTPROCESSED_INSIGHTS = EventFields.LongList$default((String)"cached_postprocessed_insights", null, (int)2, null);
        INSIGHT_ID = EventFields.Long$default((String)"insight_id", null, (int)2, null);
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "rating";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        RATING = new EnumEventField(name$iv, InsightRating.Rating.class, null, transform$iv);
        INSIGHTS_ENABLED = EventFields.Boolean((String)"insights_enabled");
        $this$iv = EventFields.INSTANCE;
        name$iv = "insights_frequency";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        INSIGHTS_FREQUENCY = new EnumEventField(name$iv, InsightsFrequency.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "settings_source";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        SETTINGS_SOURCE = new EnumEventField(name$iv, SettingsSources.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "comment_type";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        COMMENT_TYPE = new EnumEventField(name$iv, InsightEventListener.InsertedAsComment.CommentType.class, null, transform$iv);
        GOTO_TOTAL_COUNT = EventFields.Int((String)"goto_total_count");
        GOTO_WITHIN_INSIGHT_RANGE_COUNT = EventFields.Int((String)"goto_within_insight_range_count");
        CARET_MOVES_COUNT = EventFields.Int((String)"caret_moves_count");
        eventFieldArray = new EventField[]{NEW_PROCESSED_LINES, NEW_POSTPROCESSED_INSIGHTS, CACHED_POSTPROCESSED_INSIGHTS};
        requestEvent = group.registerVarargEvent("request", eventFieldArray);
        eventFieldArray = new EventField[]{INSIGHTS_ENABLED, SETTINGS_SOURCE};
        enabledChangedEvent = group.registerVarargEvent("enabled_changed", "Insight enabled/disabled state has been changed", eventFieldArray);
        eventFieldArray = new EventField[]{INSIGHTS_FREQUENCY, SETTINGS_SOURCE};
        frequencyChangedEvent = group.registerVarargEvent("frequency_changed", "Insights frequency setting has been changed", eventFieldArray);
        eventFieldArray = new EventField[]{INSIGHT_ID, RATING};
        ratedEvent = group.registerVarargEvent("rated", eventFieldArray);
        eventFieldArray = new EventField[]{INSIGHT_ID};
        copiedEvent = group.registerVarargEvent("copied", eventFieldArray);
        eventFieldArray = new EventField[]{INSIGHT_ID, COMMENT_TYPE};
        insertedAsCommentEvent = group.registerVarargEvent("insert_as_comment", eventFieldArray);
        eventFieldArray = new EventField[]{INSIGHT_ID};
        hiddenEvent = group.registerVarargEvent("hidden", eventFieldArray);
        eventFieldArray = new EventField[]{INSIGHT_ID};
        hoveredEvent = group.registerVarargEvent("hovered", eventFieldArray);
        eventFieldArray = new EventField[]{INSIGHT_ID, GOTO_TOTAL_COUNT, GOTO_WITHIN_INSIGHT_RANGE_COUNT, CARET_MOVES_COUNT};
        interactionBatchedEvent = group.registerVarargEvent("interaction_batched", eventFieldArray);
    }
}

