/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.ml.llm.daemon.MLLlmDaemonIcons;
import com.intellij.ml.llm.daemon.insight.ui.InsightRenderTextBlock;
import com.intellij.ml.llm.daemon.insight.ui.InsightRendererUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0011\u001a\u00020\f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J,\u0010\u0014\u001a\u00020\u00152\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightPlaceholderRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "placeholderText", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "block", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderTextBlock;", "insightIconX", "", "iconY", "insightIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "dispose", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightPlaceholderRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightPlaceholderRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightPlaceholderRenderer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,61:1\n648#2,5:62\n648#2,5:67\n*S KotlinDebug\n*F\n+ 1 InsightPlaceholderRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightPlaceholderRenderer\n*L\n31#1:62,5\n48#1:67,5\n*E\n"})
public final class InsightPlaceholderRenderer
implements EditorCustomElementRenderer,
Disposable {
    @NotNull
    private final Editor editor;
    @NotNull
    private final InsightRenderTextBlock block;
    private int insightIconX;
    private int iconY;
    @NotNull
    private final Icon insightIcon;

    public InsightPlaceholderRenderer(@NotNull Editor editor2, @NotNull String placeholderText) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)placeholderText, (String)"placeholderText");
        this.editor = editor2;
        this.block = new InsightRenderTextBlock(this.editor, InsightRendererUtil.INSTANCE.formatTabs(placeholderText, this.editor), null, 4, null);
        this.insightIconX = -1;
        this.iconY = -1;
        Icon icon2 = MLLlmDaemonIcons.InsightIcon;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"InsightIcon");
        this.insightIcon = icon2;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        String string;
        block1: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            String $this$takeWhile$iv = this.block.getText();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = $this$takeWhile$iv;
        }
        String blankPrefix = string;
        Font font = this.block.getFontType();
        FontMetrics fontMetrics = this.editor.getContentComponent().getFontMetrics(font);
        float iconTargetHeight = InsightRendererUtil.INSTANCE.getTargetIconHeight(font);
        return EditorUtil.getPlainSpaceWidth((Editor)this.editor) * blankPrefix.length() + InsightRendererUtil.INSTANCE.getActualIconWidth(this.insightIcon, iconTargetHeight) + InsightRendererUtil.INSTANCE.getIconGap() + fontMetrics.stringWidth(StringsKt.drop((String)this.block.getText(), (int)blankPrefix.length()));
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        String string;
        float targetIconHeight;
        block2: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            if (((CharSequence)this.block.getText()).length() == 0) {
                return;
            }
            g.setFont(this.block.getFontType());
            g.setColor((Color)this.block.getForegroundColor());
            this.iconY = targetRegion.y + g.getFontMetrics().getDescent();
            Font font = g.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            targetIconHeight = InsightRendererUtil.INSTANCE.getTargetIconHeight(font);
            String $this$takeWhile$iv = this.block.getText();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block2;
            }
            string = $this$takeWhile$iv;
        }
        String blankPrefix = string;
        this.insightIconX = targetRegion.x + EditorUtil.getPlainSpaceWidth((Editor)this.editor) * blankPrefix.length();
        Icon insightIconToPaint = this.insightIcon;
        InsightRendererUtil.INSTANCE.doPaintIcon(insightIconToPaint, this.editor, g, this.insightIconX, this.iconY, targetIconHeight);
        int textX = this.insightIconX + InsightRendererUtil.INSTANCE.getActualIconWidth(insightIconToPaint, targetIconHeight) + InsightRendererUtil.INSTANCE.getIconGap();
        String renderText = StringsKt.removePrefix((String)this.block.getText(), (CharSequence)blankPrefix);
        g.drawString(renderText, textX, targetRegion.y + this.editor.getAscent());
    }

    public void dispose() {
    }
}

