/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.domains.ide.utils;

import com.intellij.ml.llm.domains.DomainProvider;
import com.intellij.ml.llm.domains.associations.DomainAssociation;
import com.intellij.ml.llm.domains.associations.DomainAssociationDescriptor;
import com.intellij.ml.llm.domains.associations.DomainAssociationType;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010(\n\u0002\b\u0004\u0018\u0000 \u00142\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u0007J\u0012\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002H\u0016J\"\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002H\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/domains/ide/utils/DomainAssociationsGraph;", "Lcom/intellij/util/graph/Graph;", "Lcom/intellij/ml/llm/domains/DomainProvider;", "<init>", "()V", "nodes", "", "", "edges", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/ml/llm/domains/associations/DomainAssociationType;", "getProvider", "id", "getNodes", "", "getOut", "", "node", "getIn", "Companion", "intellij.ml.llm.domains.ide"})
@SourceDebugExtension(value={"SMAP\nDomainAssociationsGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DomainAssociationsGraph.kt\ncom/intellij/ml/llm/domains/ide/utils/DomainAssociationsGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1617#2,9:59\n1869#2:68\n1870#2:70\n1626#2:71\n774#2:72\n865#2:73\n1761#2,3:74\n866#2:77\n1617#2,9:78\n1869#2:87\n1870#2:89\n1626#2:90\n1#3:69\n1#3:88\n*S KotlinDebug\n*F\n+ 1 DomainAssociationsGraph.kt\ncom/intellij/ml/llm/domains/ide/utils/DomainAssociationsGraph\n*L\n43#1:59,9\n43#1:68\n43#1:70\n43#1:71\n49#1:72\n49#1:73\n49#1:74,3\n49#1:77\n50#1:78,9\n50#1:87\n50#1:89\n50#1:90\n43#1:69\n50#1:88\n*E\n"})
public final class DomainAssociationsGraph
implements Graph<DomainProvider<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, DomainProvider<?>> nodes = new HashMap();
    @NotNull
    private final MultiMap<String, Pair<String, DomainAssociationType>> edges = new MultiMap();
    @NotNull
    private static final DomainAssociationsGraph instance = new DomainAssociationsGraph();

    private DomainAssociationsGraph() {
        for (DomainProvider<?> domainProvider : DomainProvider.Companion.getProviders()) {
            this.nodes.put(domainProvider.getId(), domainProvider);
        }
        for (DomainAssociation domainAssociation : DomainAssociation.Companion.getAssociations()) {
            DomainAssociationDescriptor descriptor2 = domainAssociation.getDescriptor();
            DomainProvider from = descriptor2.getFrom();
            DomainProvider to = descriptor2.getTo();
            if (from == null || to == null) continue;
            this.edges.putValue((Object)from.getId(), (Object)Pair.create((Object)to.getId(), (Object)descriptor2.getType()));
        }
    }

    @Nullable
    public final DomainProvider<?> getProvider(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        for (DomainProvider<?> provider : this.nodes.values()) {
            if (!Intrinsics.areEqual((Object)id, (Object)provider.getId())) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public Collection<DomainProvider<?>> getNodes() {
        return this.nodes.values();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterator<DomainProvider<?>> getOut(@Nullable DomainProvider<?> node) {
        void $this$mapNotNullTo$iv$iv;
        DomainProvider<?> domainProvider = node;
        Collection collection = this.edges.get((Object)(domainProvider != null ? domainProvider.getId() : null));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection pairs = collection;
        Iterable $this$mapNotNull$iv = pairs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DomainProvider<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            if (this.nodes.get(pair.first) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return ((List)destination$iv$iv).iterator();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterator<DomainProvider<?>> getIn(@Nullable DomainProvider<?> node) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        DomainProvider<?> domainProvider = node;
        if (domainProvider == null || (domainProvider = domainProvider.getId()) == null) {
            return SetsKt.emptySet().iterator();
        }
        DomainProvider<?> nodeId = domainProvider;
        Set set = this.edges.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block6: {
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                Iterable $this$any$iv = (Iterable)v;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.first, (Object)nodeId)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DomainProvider<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl4 = false;
            if (this.nodes.get(entry.getKey()) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).iterator();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/domains/ide/utils/DomainAssociationsGraph$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/ml/llm/domains/ide/utils/DomainAssociationsGraph;", "getInstance", "()Lcom/intellij/ml/llm/domains/ide/utils/DomainAssociationsGraph;", "intellij.ml.llm.domains.ide"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DomainAssociationsGraph getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

