/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.editor.common.progress;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u0014\u001a\u00020\tH$J\b\u0010\u0015\u001a\u00020\tH$J\b\u0010\u0016\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00110\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/editor/common/progress/MagicWandManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "start", "", "token", "", "stop", "isActive", "", "tokensKey", "Lcom/intellij/openapi/util/Key;", "", "getTokensKey", "()Lcom/intellij/openapi/util/Key;", "doStartWand", "doStopWand", "dispose", "intellij.ml.llm.editor.common"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMagicWandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MagicWandManager.kt\ncom/intellij/ml/llm/editor/common/progress/MagicWandManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public abstract class MagicWandManager
implements Disposable {
    @NotNull
    private final Editor editor;

    public MagicWandManager(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    @NotNull
    protected final Editor getEditor() {
        return this.editor;
    }

    @RequiresEdt
    public final void start(@NotNull String token) {
        Set currentTokens;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Set set = (Set)this.editor.getUserData(this.getTokensKey());
        if (set == null) {
            set = new LinkedHashSet();
        }
        if ((currentTokens = set).isEmpty()) {
            this.doStartWand();
        }
        currentTokens.add(token);
        this.editor.putUserData(this.getTokensKey(), (Object)currentTokens);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void stop(@NotNull String token) {
        void it;
        Set set;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Set set2 = (Set)this.editor.getUserData(this.getTokensKey());
        if (set2 == null) {
            set2 = new LinkedHashSet();
        }
        Set currentTokens = set2;
        currentTokens.remove(token);
        if (currentTokens.isEmpty()) {
            this.doStopWand();
        }
        Set set3 = set = currentTokens;
        Key<Set<String>> key = this.getTokensKey();
        Editor editor2 = this.editor;
        boolean bl = false;
        boolean bl2 = !((Collection)it).isEmpty();
        editor2.putUserData(key, (Object)(bl2 ? set : null));
    }

    @RequiresEdt
    public final boolean isActive() {
        ThreadingAssertions.assertEventDispatchThread();
        Set set = (Set)this.editor.getUserData(this.getTokensKey());
        return set != null ? !((Collection)set).isEmpty() : false;
    }

    @NotNull
    protected abstract Key<Set<String>> getTokensKey();

    protected abstract void doStartWand();

    protected abstract void doStopWand();

    public void dispose() {
        this.editor.putUserData(this.getTokensKey(), null);
    }
}

