/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.editor.frontend.progress;

import com.intellij.ml.llm.editor.common.progress.AICaretAttributeKeys;
import com.intellij.ml.llm.editor.common.progress.MagicWandManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import java.awt.Color;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R \u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/editor/frontend/progress/FrontendMagicWandManager;", "Lcom/intellij/ml/llm/editor/common/progress/MagicWandManager;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "tokensKey", "Lcom/intellij/openapi/util/Key;", "", "", "getTokensKey", "()Lcom/intellij/openapi/util/Key;", "doStartWand", "", "doStopWand", "dispose", "magicCaretAttributes", "Lcom/intellij/openapi/editor/CaretVisualAttributes;", "currentCaretVisualAttributes", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Holder", "Companion", "intellij.ml.llm.editor.frontend"})
public final class FrontendMagicWandManager
extends MagicWandManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Holder<Color>> USUAL_CARET_COLOR_KEY;
    @NotNull
    private static final Key<Set<String>> TOKENS_KEY;

    public FrontendMagicWandManager(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        super(editor2);
    }

    @Override
    @NotNull
    protected Key<Set<String>> getTokensKey() {
        return TOKENS_KEY;
    }

    @Override
    protected void doStartWand() {
        Caret caret = this.getEditor().getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret caret2 = caret;
        CaretVisualAttributes caretVisualAttributes = caret2.getVisualAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)caretVisualAttributes, (String)"getVisualAttributes(...)");
        CaretVisualAttributes currentCaretVisualAttributes = caretVisualAttributes;
        this.getEditor().putUserData(USUAL_CARET_COLOR_KEY, new Holder<Color>(currentCaretVisualAttributes.getColor()));
        EditorColorsScheme editorColorsScheme = this.getEditor().getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        caret2.setVisualAttributes(this.magicCaretAttributes(currentCaretVisualAttributes, editorColorsScheme));
    }

    @Override
    protected void doStopWand() {
        Caret caret = this.getEditor().getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret caret2 = caret;
        Holder prevCaretColor = (Holder)this.getEditor().getUserData(USUAL_CARET_COLOR_KEY);
        if (prevCaretColor != null) {
            this.getEditor().putUserData(USUAL_CARET_COLOR_KEY, null);
            CaretVisualAttributes caretVisualAttributes = caret2.getVisualAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)caretVisualAttributes, (String)"getVisualAttributes(...)");
            CaretVisualAttributes currentCaretVisualAttributes = caretVisualAttributes;
            caret2.setVisualAttributes(new CaretVisualAttributes((Color)prevCaretColor.getValue(), currentCaretVisualAttributes.getWeight(), currentCaretVisualAttributes.getShape(), currentCaretVisualAttributes.getThickness()));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getEditor().putUserData(USUAL_CARET_COLOR_KEY, null);
    }

    private final CaretVisualAttributes magicCaretAttributes(CaretVisualAttributes currentCaretVisualAttributes, EditorColorsScheme scheme) {
        TextAttributes attributes = scheme.getAttributes(AICaretAttributeKeys.INLINE_PROMPT_ATTRS);
        return new CaretVisualAttributes(attributes.getForegroundColor(), currentCaretVisualAttributes.getWeight(), currentCaretVisualAttributes.getShape(), currentCaretVisualAttributes.getThickness());
    }

    static {
        Key key = Key.create((String)"USUAL_CARET_COLOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        USUAL_CARET_COLOR_KEY = key;
        Key key2 = Key.create((String)"intellij.ml.llm.editor.frontend.magic.wand.tokens");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        TOKENS_KEY = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R-\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\n\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \b*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b0\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/editor/frontend/progress/FrontendMagicWandManager$Companion;", "", "<init>", "()V", "USUAL_CARET_COLOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/editor/frontend/progress/FrontendMagicWandManager$Holder;", "Ljava/awt/Color;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "TOKENS_KEY", "", "", "intellij.ml.llm.editor.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/editor/frontend/progress/FrontendMagicWandManager$Holder;", "T", "", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lcom/intellij/ml/llm/editor/frontend/progress/FrontendMagicWandManager$Holder;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.editor.frontend"})
    private static final class Holder<T> {
        @Nullable
        private final T value;

        public Holder(@Nullable T value) {
            this.value = value;
        }

        @Nullable
        public final T getValue() {
            return this.value;
        }

        @Nullable
        public final T component1() {
            return this.value;
        }

        @NotNull
        public final Holder<T> copy(@Nullable T value) {
            return new Holder<T>(value);
        }

        public static /* synthetic */ Holder copy$default(Holder holder, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = holder.value;
            }
            return holder.copy(object);
        }

        @NotNull
        public String toString() {
            return "Holder(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Holder)) {
                return false;
            }
            Holder holder = (Holder)other;
            return Intrinsics.areEqual(this.value, holder.value);
        }
    }
}

