/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.java.writeDocumentation;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.editorActions.FixDocCommentAction;
import com.intellij.ml.llm.core.LLMDocumentationSupportWithBlockComments;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.grazie.tasks.documentation.WdPromptCustomization;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J,\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006)"}, d2={"Lcom/intellij/ml/llm/java/writeDocumentation/LLMJavaDocumentationSupport;", "Lcom/intellij/ml/llm/core/LLMDocumentationSupportWithBlockComments;", "<init>", "()V", "emptyDocumentation", "", "getEmptyDocumentation", "()Ljava/lang/String;", "commentStart", "getCommentStart", "commentEnd", "getCommentEnd", "useChatCodeContextProvider", "", "getDocComment", "Lcom/intellij/psi/PsiElement;", "element", "findExampleDoc", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/privacy/PSString;", "documentationTarget", "updateDoc", "Lcom/intellij/openapi/editor/RangeMarker;", "editor", "Lcom/intellij/openapi/editor/Editor;", "documentationRange", "newDocText", "findDocTargetsInSelection", "", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "root", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "findNearestDocumentationTarget", "findNearestDocumentationTargetForCaret", "reformatDocumentation", "", "promptCustomization", "Lcom/intellij/ml/llm/grazie/tasks/documentation/WdPromptCustomization;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.java"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nLLMJavaDocumentationSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMJavaDocumentationSupport.kt\ncom/intellij/ml/llm/java/writeDocumentation/LLMJavaDocumentationSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1#2:150\n1400#3,2:151\n3919#3:153\n4434#3,2:154\n3919#3:156\n4434#3,2:157\n3919#3:159\n4434#3,2:160\n4225#3,11:173\n808#4,11:162\n774#4:184\n865#4,2:185\n2423#4,14:187\n*S KotlinDebug\n*F\n+ 1 LLMJavaDocumentationSupport.kt\ncom/intellij/ml/llm/java/writeDocumentation/LLMJavaDocumentationSupport\n*L\n76#1:151,2\n80#1:153\n80#1:154,2\n89#1:156\n89#1:157,2\n91#1:159\n91#1:160,2\n118#1:173,11\n91#1:162,11\n118#1:184\n118#1:185,2\n120#1:187,14\n*E\n"})
public final class LLMJavaDocumentationSupport
implements LLMDocumentationSupportWithBlockComments {
    @NotNull
    public String getEmptyDocumentation() {
        return "/**\n*\n*/";
    }

    @NotNull
    public String getCommentStart() {
        return "/**";
    }

    @NotNull
    public String getCommentEnd() {
        return "*/";
    }

    public boolean useChatCodeContextProvider() {
        return true;
    }

    @Nullable
    public PsiElement getDocComment(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiDocCommentOwner psiDocCommentOwner = element2 instanceof PsiDocCommentOwner ? (PsiDocCommentOwner)element2 : null;
        Object object = psiDocCommentOwner != null ? (PsiJavaDocumentedElement)psiDocCommentOwner : (element2 instanceof PsiJavaDocumentedElement ? (PsiJavaDocumentedElement)element2 : null);
        return (PsiElement)(object != null ? object.getDocComment() : null);
    }

    @Nullable
    public Pair<PSString, PSString> findExampleDoc(@NotNull PsiElement documentationTarget) {
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        return null;
    }

    @Nullable
    public RangeMarker updateDoc(@NotNull Editor editor2, @NotNull PsiElement documentationTarget, @Nullable RangeMarker documentationRange, @NotNull String newDocText) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        Intrinsics.checkNotNullParameter((Object)newDocText, (String)"newDocText");
        Project project2 = documentationTarget.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project3);
        PsiDocComment psiDocComment = factory.createDocCommentFromText(newDocText);
        Intrinsics.checkNotNullExpressionValue((Object)psiDocComment, (String)"createDocCommentFromText(...)");
        PsiDocComment newDocComment = psiDocComment;
        try {
            RangeMarker rangeMarker;
            PsiJavaDocumentedElement psiJavaDocumentedElement;
            PsiJavaDocumentedElement commentedDeclaration;
            PsiDocCommentOwner psiDocCommentOwner = documentationTarget instanceof PsiDocCommentOwner ? (PsiDocCommentOwner)documentationTarget : null;
            PsiJavaDocumentedElement psiJavaDocumentedElement2 = commentedDeclaration = psiDocCommentOwner != null ? (PsiJavaDocumentedElement)psiDocCommentOwner : (documentationTarget instanceof PsiJavaDocumentedElement ? (PsiJavaDocumentedElement)documentationTarget : null);
            if ((psiJavaDocumentedElement2 != null ? psiJavaDocumentedElement2.getDocComment() : null) == null && documentationTarget instanceof PsiClass && ((PsiClass)documentationTarget).isEnum()) {
                FixDocCommentAction.generateOrFixComment((PsiElement)documentationTarget, (Project)((PsiClass)documentationTarget).getProject(), (Editor)editor2);
                PsiDocumentManager.getInstance((Project)project3).commitDocument(editor2.getDocument());
            }
            if ((psiJavaDocumentedElement = commentedDeclaration) == null || (psiJavaDocumentedElement = psiJavaDocumentedElement.getDocComment()) == null || (psiJavaDocumentedElement = psiJavaDocumentedElement.replace((PsiElement)newDocComment)) == null) {
                throw new IncorrectOperationException();
            }
            PsiDocComment psiDocComment2 = commentedDeclaration.getDocComment();
            if (psiDocComment2 != null && (psiDocComment2 = psiDocComment2.getTextRange()) != null) {
                PsiDocComment it = psiDocComment2;
                boolean bl = false;
                rangeMarker = editor2.getDocument().createRangeMarker((TextRange)it);
            } else {
                rangeMarker = null;
            }
            return rangeMarker;
        }
        catch (IncorrectOperationException e) {
            if (documentationRange != null) {
                RangeMarker it = documentationRange;
                boolean bl = false;
                editor2.getDocument().replaceString(documentationRange.getStartOffset(), documentationRange.getEndOffset(), (CharSequence)newDocText);
                return documentationRange;
            }
            LLMJavaDocumentationSupport $this$updateDoc_u24lambda_u242 = this;
            boolean bl = false;
            documentationTarget.addBefore((PsiElement)newDocComment, documentationTarget.getFirstChild());
            return editor2.getDocument().createRangeMarker(documentationTarget.getFirstChild().getTextRange());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PsiNameIdentifierOwner> findDocTargetsInSelection(@NotNull PsiElement root, @NotNull SelectionModel selectionModel) {
        List list;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        boolean $i$f$filter22;
        Object[] $this$filter$iv2;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        PsiElement psiElement = CollectHighlightsUtil.findCommonParent((PsiElement)root, (int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement commonParent = psiElement;
        if (commonParent instanceof PsiJavaFile) {
            Object object;
            block10: {
                TextRange commonParentTrimmedRange = this.getTextRangeWithoutLeadingCommentsAndWhitespaces(commonParent);
                PsiElement[] psiElementArray = ((PsiJavaFile)commonParent).getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                Object[] $this$firstOrNull$iv = psiElementArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!it.getTextRange().equals((Object)commonParentTrimmedRange)) continue;
                    object = element$iv;
                    break block10;
                }
                object = null;
            }
            PsiElement equalRangeElement = (PsiElement)object;
            if (equalRangeElement == null) {
                void $this$filterTo$iv$iv2;
                PsiClass[] psiClassArray = ((PsiJavaFile)commonParent).getClasses();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
                $this$filter$iv2 = psiClassArray;
                $i$f$filter22 = false;
                Object[] objectArray = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv2) {
                    PsiClass it = (PsiClass)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.containsWithoutComments(selectionModel, (PsiElement)it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            commonParent = equalRangeElement;
        }
        PsiNameIdentifierOwner psiNameIdentifierOwner = this.findNearestDocumentationTarget(commonParent);
        if (psiNameIdentifierOwner == null) {
            return CollectionsKt.emptyList();
        }
        PsiNameIdentifierOwner closestNamedElement = psiNameIdentifierOwner;
        if (!(closestNamedElement instanceof PsiClass) || this.containsWithoutComments(selectionModel, (PsiElement)closestNamedElement)) {
            return CollectionsKt.listOf((Object)closestNamedElement);
        }
        PsiField[] psiFieldArray = ((PsiClass)closestNamedElement).getFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
        $this$filter$iv2 = psiFieldArray;
        $i$f$filter22 = false;
        Object[] $this$filterTo$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv2.length;
        for (int it = 0; it < n; ++it) {
            Object element$iv$iv = $this$filterTo$iv$iv2[it];
            PsiField it2 = (PsiField)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            if (!this.containsWithoutComments(selectionModel, (PsiElement)it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fieldsInRange = (List)destination$iv$iv;
        PsiMethod[] psiMethodArray = ((PsiClass)closestNamedElement).getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
        Object[] $i$f$filter22 = psiMethodArray;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            PsiMethod it = (PsiMethod)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.containsWithoutComments(selectionModel, (PsiElement)it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethod)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List methodsInRange = (List)destination$iv$iv2;
        List $this$findDocTargetsInSelection_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$findDocTargetsInSelection_u24lambda_u244.addAll(fieldsInRange);
        $this$findDocTargetsInSelection_u24lambda_u244.addAll(methodsInRange);
        return CollectionsKt.build((List)list);
    }

    @Nullable
    public PsiNameIdentifierOwner findNearestDocumentationTarget(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof PsiMethod || element2 instanceof PsiClass) {
            return (PsiNameIdentifierOwner)element2;
        }
        PsiNameIdentifierOwner closestIdentifierOwner = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiNameIdentifierOwner.class);
        if (!(closestIdentifierOwner instanceof PsiMethod)) {
            PsiMethod methodParent = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiMethod.class);
            if (methodParent != null) {
                return (PsiNameIdentifierOwner)methodParent;
            }
            PsiJavaModule moduleParent = (PsiJavaModule)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiJavaModule.class);
            if (moduleParent != null) {
                return (PsiNameIdentifierOwner)moduleParent;
            }
            return closestIdentifierOwner;
        }
        return closestIdentifierOwner;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiNameIdentifierOwner findNearestDocumentationTargetForCaret(@NotNull Editor editor2) {
        Object v2;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement psiElement = PsiUtilBase.getElementAtCaret((Editor)editor2);
        if (psiElement == null) {
            return null;
        }
        PsiElement element2 = psiElement;
        PsiNamedElement closestNamedElement = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiNamedElement.class, (boolean)false);
        int caretOffset = editor2.getCaretModel().getOffset();
        if (!(closestNamedElement instanceof PsiJavaFile)) {
            return this.findNearestDocumentationTarget(element2);
        }
        PsiClass[] psiClassArray = ((PsiJavaFile)closestNamedElement).getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
        Object $this$filterIsInstance$iv = psiClassArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiNameIdentifierOwner)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiNameIdentifierOwner it = (PsiNameIdentifierOwner)element$iv$iv;
            boolean bl = false;
            if (!(it.getTextRange().getStartOffset() >= caretOffset)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                PsiNameIdentifierOwner it = (PsiNameIdentifierOwner)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getTextRange().getStartOffset() - caretOffset;
                do {
                    Object e$iv = iterator$iv.next();
                    PsiNameIdentifierOwner it2 = (PsiNameIdentifierOwner)e$iv;
                    $i$a$-minByOrNull-LLMJavaDocumentationSupport$findNearestDocumentationTargetForCaret$2 = false;
                    int v$iv = it2.getTextRange().getStartOffset() - caretOffset;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        return v2;
    }

    public void reformatDocumentation(@NotNull Editor editor2, @NotNull PsiElement documentationTarget) {
        int docCommentEndLine;
        int siblingEndLine;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)documentationTarget, (String)"documentationTarget");
        PsiElement psiElement = this.getDocComment(documentationTarget);
        if (psiElement == null) {
            return;
        }
        PsiElement docComment = psiElement;
        PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)docComment);
        if (psiElement2 == null) {
            return;
        }
        PsiElement nextSibling = psiElement2;
        if (nextSibling instanceof PsiComment && (siblingEndLine = editor2.getDocument().getLineNumber(((PsiComment)nextSibling).getTextRange().getEndOffset())) == (docCommentEndLine = editor2.getDocument().getLineNumber(docComment.getTextRange().getEndOffset()))) {
            PsiParserFacade psiParserFacade = PsiParserFacade.getInstance((Project)documentationTarget.getProject());
            documentationTarget.addAfter(psiParserFacade.createWhiteSpaceFromText("\n"), docComment);
        }
    }

    @Nullable
    public WdPromptCustomization promptCustomization(@NotNull Project project2) {
        WdPromptCustomization.User user;
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("AIAssistant.WriteDocumentation.Java");
        if (aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null) {
            PSString it = pSString;
            boolean bl = false;
            user = new WdPromptCustomization.User(it);
        } else {
            user = null;
        }
        return (WdPromptCustomization)user;
    }
}

