/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.common.inlays;

import com.intellij.ide.KeyboardAwareFocusOwner;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionPromoterKt;
import com.intellij.lang.Language;
import com.intellij.ml.llm.codeGeneration.AICodeGenerationProgressListener;
import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationHistoryStorage;
import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationPopupActionKt;
import com.intellij.ml.llm.codeGeneration.popup.AICodeGenerationPopupInputTextField;
import com.intellij.ml.llm.codeGeneration.popup.PersistentState;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.chat.ui.AIAssistantChatUtil;
import com.intellij.ml.llm.jupyter.common.JupyterLLMCommonBundle;
import com.intellij.ml.llm.jupyter.common.inlays.AICodeGenerationJupyterPromptWithEditorTextField;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.notebooks.visualization.ui.EditorComponentWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.AlignedPopup;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.TextAccessor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B \u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000f\b\u0002\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0014J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\u0014H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u0004\u0018\u00010+J\u0014\u0010,\u001a\u00020\u00142\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0014\u0010.\u001a\u00020\u00142\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0014\u00100\u001a\u00020\u00142\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0006\u00102\u001a\u00020\u0014J\u0006\u00103\u001a\u00020\u0014J\u0010\u00104\u001a\u00020$2\u0006\u00105\u001a\u000206H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/ml/llm/jupyter/common/inlays/AICodeGenerationJupyterPromptWithEditorTextField;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/ide/KeyboardAwareFocusOwner;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "hint", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "editorTextField", "Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopupInputTextField;", "getEditorTextField", "()Lcom/intellij/ml/llm/codeGeneration/popup/AICodeGenerationPopupInputTextField;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "onSubmitByEnterCallback", "Lkotlin/Function0;", "", "onCancelByEscCallback", "onStopGenerationCallback", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "dispose", "hidePopup", "updateTextFieldBackground", "color", "Ljava/awt/Color;", "showHistoryPopup", "setupDocument", "setupEditorTextField", "setupCustomKeyboardShortcuts", "selectHistoryElement", "forward", "", "addNotify", "removeNotify", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getText", "Lcom/intellij/ml/llm/privacy/PSString;", "setOnSubmitByEnter", "onSubmit", "setOnStopGeneration", "onStopGeneration", "setOnCancelByEsc", "onCancel", "setGenerationInProgress", "setReadyForPrompt", "skipKeyEventDispatcher", "event", "Ljava/awt/event/KeyEvent;", "intellij.ml.llm.jupyter.common"})
@SourceDebugExtension(value={"SMAP\nAICodeGenerationJupyterPromptWithEditorTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AICodeGenerationJupyterPromptWithEditorTextField.kt\ncom/intellij/ml/llm/jupyter/common/inlays/AICodeGenerationJupyterPromptWithEditorTextField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n1#2:301\n*E\n"})
public final class AICodeGenerationJupyterPromptWithEditorTextField
extends BorderLayoutPanel
implements KeyboardAwareFocusOwner,
UiDataProvider,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final AICodeGenerationPopupInputTextField editorTextField;
    @Nullable
    private MessageBusConnection messageBusConnection;
    @Nullable
    private Function0<Unit> onSubmitByEnterCallback;
    @Nullable
    private Function0<Unit> onCancelByEscCallback;
    @Nullable
    private Function0<Unit> onStopGenerationCallback;
    @Nullable
    private JBPopup popup;

    public AICodeGenerationJupyterPromptWithEditorTextField(@NotNull Project project2, @Nullable String hint) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.editorTextField = new AICodeGenerationPopupInputTextField(this.project);
        this.setupEditorTextField();
        this.setupCustomKeyboardShortcuts();
        this.setupDocument();
        if (hint != null) {
            this.editorTextField.setPlaceholder(hint);
        }
        DumbAwareAction.create(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField._init_$lambda$1(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField._init_$lambda$0(this, arg_0), arg_0)).registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowSearchHistory"), (JComponent)((Object)this.editorTextField));
    }

    public /* synthetic */ AICodeGenerationJupyterPromptWithEditorTextField(Project project2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(project2, string);
    }

    @NotNull
    public final AICodeGenerationPopupInputTextField getEditorTextField() {
        return this.editorTextField;
    }

    public void dispose() {
        this.hidePopup();
    }

    private final void hidePopup() {
        JBPopup jBPopup = this.popup;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this.popup = null;
    }

    public final void updateTextFieldBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.editorTextField.setBackground(color);
    }

    public final void showHistoryPopup() {
        block1: {
            JBPopup jBPopup;
            List<String> history = ((PersistentState)AICodeGenerationHistoryStorage.Companion.getInstance().getState()).getHistory();
            if (history.isEmpty()) {
                return;
            }
            this.hidePopup();
            JBPopup jBPopup2 = this.popup = (JBPopup)JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(history, this){
                final /* synthetic */ AICodeGenerationJupyterPromptWithEditorTextField this$0;
                {
                    this.this$0 = $receiver;
                    super(null, $history);
                }

                public String getTextFor(String value) {
                    Object result2;
                    if (value == null) {
                        return "";
                    }
                    Sequence lines2 = SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)value), showHistoryPopup.1::getTextFor$lambda$0);
                    Object object = (String)SequencesKt.firstOrNull((Sequence)lines2);
                    if (object == null) {
                        object = result2 = "";
                    }
                    if (SequencesKt.toList((Sequence)lines2).size() > 1) {
                        result2 = (String)result2 + "\u2026";
                    }
                    return result2;
                }

                public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                    if (selectedValue != null) {
                        this.this$0.getEditorTextField().setText(selectedValue);
                    }
                    return BaseListPopupStep.FINAL_CHOICE;
                }

                private static final boolean getTextFor$lambda$0(String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                }
            });
            if (jBPopup2 == null) break block1;
            JBPopup $this$showHistoryPopup_u24lambda_u240 = jBPopup = jBPopup2;
            boolean bl = false;
            $this$showHistoryPopup_u24lambda_u240.setRequestFocus(true);
            AlignedPopup.showUnderneathWithoutAlignment((JBPopup)$this$showHistoryPopup_u24lambda_u240, (Component)((Component)((Object)this.editorTextField)));
        }
    }

    private final void setupDocument() {
        boolean chatInputLanguageEnabled = Registry.Companion.is("llm.chat.input.language.in.inlay");
        String fileExtension = chatInputLanguageEnabled ? "chatInput" : "txt";
        String fileName = "AIAssistantInput-" + UUID.randomUUID() + "." + fileExtension;
        String languageName = chatInputLanguageEnabled ? "ChatInput" : "TEXT";
        Language language = AIAssistantChatUtil.INSTANCE.findLanguage(languageName);
        ApplicationManager.getApplication().runReadAction(() -> AICodeGenerationJupyterPromptWithEditorTextField.setupDocument$lambda$0(this, fileName, language));
    }

    private final void setupEditorTextField() {
        this.addToCenter((Component)((Object)this.editorTextField));
        Ref.IntRef previousSoftWrapCount = new Ref.IntRef();
        this.editorTextField.addEditorAddedListener(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupEditorTextField$lambda$0(previousSoftWrapCount, this, arg_0));
    }

    private final void setupCustomKeyboardShortcuts() {
        Shortcut[] shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(10, 64), null), new KeyboardShortcut(KeyStroke.getKeyStroke(10, 128), null)};
        DumbAwareAction.create(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$1(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$0(this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.editorTextField));
        shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null)};
        DumbAwareAction.create(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$3(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$2(this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.editorTextField));
        shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(27, 0), null)};
        DumbAwareAction.create(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$5(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$4(this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.editorTextField));
        shortcutArray = new Shortcut[]{new KeyboardShortcut(SearchTextField.ALT_SHOW_HISTORY_KEYSTROKE, null)};
        DumbAwareAction.create(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$7(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$6(this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.editorTextField));
        shortcutArray = new Shortcut[]{new KeyboardShortcut(SearchTextField.SHOW_HISTORY_KEYSTROKE, null)};
        DumbAwareAction.create(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$9(arg_0 -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$8(this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.editorTextField));
    }

    public final void selectHistoryElement(boolean forward) {
        block2: {
            Editor editor2;
            List<String> history = ((PersistentState)AICodeGenerationHistoryStorage.Companion.getInstance().getState()).getHistory();
            if (history.isEmpty()) {
                return;
            }
            int currentIndex = history.indexOf(this.editorTextField.getText());
            if (currentIndex == -1) {
                this.editorTextField.setText((String)CollectionsKt.first(history));
                return;
            }
            int index = RangesKt.coerceIn((int)(forward ? currentIndex + 1 : currentIndex - 1), (int)0, (int)(history.size() - 1));
            this.editorTextField.setText(history.get(index));
            Editor editor3 = this.editorTextField.getEditor();
            if (editor3 == null) break block2;
            Editor $this$selectHistoryElement_u24lambda_u240 = editor2 = editor3;
            boolean bl = false;
            $this$selectHistoryElement_u24lambda_u240.getCaretModel().moveToOffset(0);
            $this$selectHistoryElement_u24lambda_u240.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            $this$selectHistoryElement_u24lambda_u240.getSelectionModel().removeSelection();
        }
    }

    public void addNotify() {
        block0: {
            super.addNotify();
            this.messageBusConnection = this.project.getMessageBus().connect();
            AnActionListener enterToSubmitActionListener2 = new AnActionListener(this){
                final /* synthetic */ AICodeGenerationJupyterPromptWithEditorTextField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void afterActionPerformed(AnAction action2, AnActionEvent event2, AnActionResult result2) {
                    Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                    Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    if (event2.getDataContext().getData(CommonDataKeys.EDITOR) != this.this$0.getEditorTextField().getEditor()) {
                        return;
                    }
                    if (!(action2 instanceof EnterAction)) {
                        return;
                    }
                    String string = this.this$0.getEditorTextField().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (((CharSequence)string).length() > 0) {
                        Editor editor2 = AICodeGenerationPopupActionKt.getEditor(event2);
                        if (editor2 == null) {
                            return;
                        }
                        Editor editor3 = editor2;
                        AICodeGenerationProgressListener.Companion.submit$default(AICodeGenerationProgressListener.Companion, editor3, ChatSourceAction.GENERATE_CODE_INPLACE, false, 4, null);
                    }
                }
            };
            MessageBusConnection messageBusConnection = this.messageBusConnection;
            if (messageBusConnection == null) break block0;
            Topic topic = AnActionListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)enterToSubmitActionListener2);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        MessageBusConnection messageBusConnection = this.messageBusConnection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.messageBusConnection = null;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(JupyterEditorActionPromoterKt.getDISABLE_JUPYTER_EDITOR_ACTION_PROMOTER_KEY(), (Object)true);
    }

    @Nullable
    public final PSString getText() {
        return SharedExtensionsKtKt.getPrivacySafe((TextAccessor)((TextAccessor)this.editorTextField)).getText();
    }

    public final void setOnSubmitByEnter(@NotNull Function0<Unit> onSubmit2) {
        Intrinsics.checkNotNullParameter(onSubmit2, (String)"onSubmit");
        this.onSubmitByEnterCallback = onSubmit2;
    }

    public final void setOnStopGeneration(@NotNull Function0<Unit> onStopGeneration) {
        Intrinsics.checkNotNullParameter(onStopGeneration, (String)"onStopGeneration");
        this.onStopGenerationCallback = onStopGeneration;
    }

    public final void setOnCancelByEsc(@NotNull Function0<Unit> onCancel) {
        Intrinsics.checkNotNullParameter(onCancel, (String)"onCancel");
        this.onCancelByEscCallback = onCancel;
    }

    public final void setGenerationInProgress() {
        this.editorTextField.setText("");
        this.editorTextField.setPlaceholder(JupyterLLMCommonBundle.message("autopilot.text.field.generation", new Object[0]));
    }

    public final void setReadyForPrompt() {
        this.editorTextField.setPlaceholder(null);
    }

    public boolean skipKeyEventDispatcher(@NotNull KeyEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        return true;
    }

    private static final Unit _init_$lambda$0(AICodeGenerationJupyterPromptWithEditorTextField this$0, AnActionEvent it) {
        this$0.showHistoryPopup();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void setupDocument$lambda$0(AICodeGenerationJupyterPromptWithEditorTextField this$0, String $fileName, Language $language) {
        void $this$setupDocument_u24lambda_u240_u240;
        LightVirtualFile lightVirtualFile;
        LightVirtualFile lightVirtualFile2 = lightVirtualFile = new LightVirtualFile($fileName, $language, (CharSequence)"");
        AICodeGenerationPopupInputTextField aICodeGenerationPopupInputTextField = this$0.editorTextField;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)$this$setupDocument_u24lambda_u240_u240.getFileType(), (Object)UnknownFileType.INSTANCE)) {
            $this$setupDocument_u24lambda_u240_u240.setFileType((FileType)PlainTextFileType.INSTANCE);
        }
        Document document2 = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)lightVirtualFile));
        if (document2 == null) {
            throw new IllegalStateException("Can't create inmemory document".toString());
        }
        aICodeGenerationPopupInputTextField.setDocument(document2);
    }

    private static final void setupEditorTextField$lambda$0(Ref.IntRef $previousSoftWrapCount, AICodeGenerationJupyterPromptWithEditorTextField this$0, Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        SoftWrapModel softWrapModel = editor2.getSoftWrapModel();
        Intrinsics.checkNotNullExpressionValue((Object)softWrapModel, (String)"getSoftWrapModel(...)");
        SoftWrapModel softWrapModel2 = softWrapModel;
        $previousSoftWrapCount.element = AICodeGenerationJupyterPromptWithEditorTextField.setupEditorTextField$lambda$0$getCurrentLineSoftWrapCount(editor2, softWrapModel2);
        editor2.getDocument().addDocumentListener(new DocumentListener($previousSoftWrapCount, this$0, editor2, softWrapModel2){
            final /* synthetic */ Ref.IntRef $previousSoftWrapCount;
            final /* synthetic */ AICodeGenerationJupyterPromptWithEditorTextField this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ SoftWrapModel $softWrapModel;
            {
                this.$previousSoftWrapCount = $previousSoftWrapCount;
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$softWrapModel = $softWrapModel;
            }

            public void documentChanged(DocumentEvent event2) {
                block4: {
                    block3: {
                        boolean softWrapChanged;
                        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                        Function1 countNewlines = setupEditorTextField.1.1::documentChanged$lambda$0;
                        Function1 countCarriageReturns = setupEditorTextField.1.1::documentChanged$lambda$1;
                        int newSoftWrapCount = AICodeGenerationJupyterPromptWithEditorTextField.access$setupEditorTextField$lambda$0$getCurrentLineSoftWrapCount(this.$editor, this.$softWrapModel);
                        boolean bl = softWrapChanged = this.$previousSoftWrapCount.element != newSoftWrapCount;
                        if (softWrapChanged) {
                            this.$previousSoftWrapCount.element = newSoftWrapCount;
                            Container container2 = SwingUtilities.getAncestorOfClass(EditorComponentWrapper.class, (Component)((Object)this.this$0));
                            if (container2 != null) {
                                container2.validate();
                            }
                        }
                        CharSequence charSequence = event2.getNewFragment();
                        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                        int n = ((Number)countNewlines.invoke((Object)charSequence)).intValue();
                        CharSequence charSequence2 = event2.getOldFragment();
                        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getOldFragment(...)");
                        if (n != ((Number)countNewlines.invoke((Object)charSequence2)).intValue()) break block3;
                        CharSequence charSequence3 = event2.getNewFragment();
                        Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getNewFragment(...)");
                        int n2 = ((Number)countCarriageReturns.invoke((Object)charSequence3)).intValue();
                        CharSequence charSequence4 = event2.getOldFragment();
                        Intrinsics.checkNotNullExpressionValue((Object)charSequence4, (String)"getOldFragment(...)");
                        if (n2 == ((Number)countCarriageReturns.invoke((Object)charSequence4)).intValue()) break block4;
                    }
                    Container container3 = SwingUtilities.getAncestorOfClass(EditorComponentWrapper.class, (Component)((Object)this.this$0));
                    if (container3 != null) {
                        container3.validate();
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private static final int documentChanged$lambda$0(CharSequence text2) {
                void var3_3;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                CharSequence $this$count$iv = text2;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                return (int)var3_3;
            }

            /*
             * WARNING - void declaration
             */
            private static final int documentChanged$lambda$1(CharSequence text2) {
                void var3_3;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                CharSequence $this$count$iv = text2;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '\r')) continue;
                    ++count$iv;
                }
                return (int)var3_3;
            }
        }, (Disposable)this$0);
    }

    private static final int setupEditorTextField$lambda$0$getCurrentLineSoftWrapCount(Editor $editor, SoftWrapModel softWrapModel) {
        int caretLine = $editor.getCaretModel().getLogicalPosition().line;
        return softWrapModel.getSoftWrapsForLine(caretLine).size();
    }

    private static final Unit setupCustomKeyboardShortcuts$lambda$0(AICodeGenerationJupyterPromptWithEditorTextField this$0, AnActionEvent it) {
        block0: {
            Editor editor2 = this$0.editorTextField.getEditor();
            if (editor2 == null) break block0;
            Editor it2 = editor2;
            boolean bl = false;
            CommandProcessor.getInstance().executeCommand(this$0.project, () -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$0$0$0(it2, this$0), null, null);
        }
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$0$0$0(Editor $it, AICodeGenerationJupyterPromptWithEditorTextField this$0) {
        ApplicationManager.getApplication().runWriteAction(() -> AICodeGenerationJupyterPromptWithEditorTextField.setupCustomKeyboardShortcuts$lambda$0$0$0$0($it, this$0));
    }

    private static final void setupCustomKeyboardShortcuts$lambda$0$0$0$0(Editor $it, AICodeGenerationJupyterPromptWithEditorTextField this$0) {
        String eol = "\n";
        int caretOffset = $it.getCaretModel().getOffset();
        this$0.editorTextField.getDocument().insertString(caretOffset, (CharSequence)eol);
        $it.getCaretModel().moveToOffset(caretOffset + eol.length());
        EditorModificationUtil.scrollToCaret((Editor)$it);
    }

    private static final void setupCustomKeyboardShortcuts$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupCustomKeyboardShortcuts$lambda$2(AICodeGenerationJupyterPromptWithEditorTextField this$0, AnActionEvent it) {
        block0: {
            Function0<Unit> function0 = this$0.onSubmitByEnterCallback;
            if (function0 == null) break block0;
            Function0<Unit> it2 = function0;
            boolean bl = false;
            it2.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupCustomKeyboardShortcuts$lambda$4(AICodeGenerationJupyterPromptWithEditorTextField this$0, AnActionEvent it) {
        block0: {
            Function0<Unit> function0 = this$0.onCancelByEscCallback;
            if (function0 == null) break block0;
            Function0<Unit> it2 = function0;
            boolean bl = false;
            it2.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupCustomKeyboardShortcuts$lambda$6(AICodeGenerationJupyterPromptWithEditorTextField this$0, AnActionEvent it) {
        this$0.selectHistoryElement(false);
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setupCustomKeyboardShortcuts$lambda$8(AICodeGenerationJupyterPromptWithEditorTextField this$0, AnActionEvent it) {
        this$0.selectHistoryElement(true);
        return Unit.INSTANCE;
    }

    private static final void setupCustomKeyboardShortcuts$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$setupEditorTextField$lambda$0$getCurrentLineSoftWrapCount(Editor $editor, SoftWrapModel softWrapModel) {
        return AICodeGenerationJupyterPromptWithEditorTextField.setupEditorTextField$lambda$0$getCurrentLineSoftWrapCount($editor, softWrapModel);
    }
}

