/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.python.tables.inspections.prompt;

import com.intellij.ml.llm.jupyter.common.agent.privacy.IdeFormerSafeStringPrivacyWrapperKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.scientific.py.tables.inspections.api.Inspection;
import com.intellij.scientific.py.tables.inspections.api.quickFix.InspectionQuickFixInput;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0005J\f\u0010\f\u001a\u00020\u0005*\u00020\tH\u0002R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/jupyter/python/tables/inspections/prompt/TableInspectionPromptsProvider;", "", "<init>", "()V", "getPromptAllInspections", "Lcom/intellij/ml/llm/privacy/PSString;", "dataframeVariableName", "inspectionQuickFixInputs", "", "Lcom/intellij/scientific/py/tables/inspections/api/quickFix/InspectionQuickFixInput;", "columnsStatisticsData", "SUGGEST_CODE_TO_FIX_DATA_QUALITY_ISSUES_IN_PANDAS_PROMPT_TEMPLATE", "getInspectionString", "intellij.ml.llm.jupyter.python"})
public final class TableInspectionPromptsProvider {
    @NotNull
    public static final TableInspectionPromptsProvider INSTANCE = new TableInspectionPromptsProvider();
    @NotNull
    private static final PSString SUGGEST_CODE_TO_FIX_DATA_QUALITY_ISSUES_IN_PANDAS_PROMPT_TEMPLATE = ConstantsKt.getPrivacyConst((String)"\nGiven pandas dataframe name, its describe information and all found problem description in format:\nDataframe name:\n%s\n\nDataframe %s summary:\n%s\n\nProblems description:\n%s\n\nYou need to write Python code that will fix these problems with data.\nRules for code generation:\n- Be an advanced pandas user. Write code in accordance with best practices.\n- Avoid code duplication: if some of fixes repeats then introduce a function for this and use it to fix issues in the dataframe.\n- Take into account all problems at once. Fixing one problem MUST NOT create more problems.\n- If the action requires other work to be done before, don't suggest it, only suggest the python code that will fix the problem. \n- DO NOT SUGGEST run code! \n- DO NOT SUGGEST \"Run ...\" because it is impossible to run it is possible only to write code.\n- Please notice that this dataframe is already created and you do not need to create it again.\n- Return only python code that will fix the problem.\n- IT'S BETTER TO USE THIS SYNTAX df[col] = df[col].method(value), to perform the operation inplace on the original object.\n\nExample:\n 1. Input:\n     - For Out[1] it was detected that in column 'age' there are 1000 None values.\n 2. Output:\n     Out[1]['age'] = Out[1]['age'].fillna(Out[1]['age'].mean())\n\n").trimIndent();

    private TableInspectionPromptsProvider() {
    }

    @NotNull
    public final PSString getPromptAllInspections(@NotNull PSString dataframeVariableName2, @NotNull List<InspectionQuickFixInput> inspectionQuickFixInputs, @NotNull PSString columnsStatisticsData) {
        Intrinsics.checkNotNullParameter((Object)dataframeVariableName2, (String)"dataframeVariableName");
        Intrinsics.checkNotNullParameter(inspectionQuickFixInputs, (String)"inspectionQuickFixInputs");
        Intrinsics.checkNotNullParameter((Object)columnsStatisticsData, (String)"columnsStatisticsData");
        String inspectionResultsDescription = CollectionsKt.joinToString$default((Iterable)inspectionQuickFixInputs, (CharSequence)"\n", null, null, (int)0, null, TableInspectionPromptsProvider::getPromptAllInspections$lambda$0, (int)30, null);
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{dataframeVariableName2, dataframeVariableName2, columnsStatisticsData, IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe(inspectionResultsDescription)};
        return SUGGEST_CODE_TO_FIX_DATA_QUALITY_ISSUES_IN_PANDAS_PROMPT_TEMPLATE.format(pSStringConvertibleArray).toPSString();
    }

    private final PSString getInspectionString(InspectionQuickFixInput $this$getInspectionString) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getInspectionString.getInspection().ordinal()]) {
            case 1 -> IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe("For " + $this$getInspectionString.getTableVariableName() + " it was detected that in column " + $this$getInspectionString.getColumnName() + " there are " + $this$getInspectionString.getValue() + " None values");
            case 2 -> IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe("For " + $this$getInspectionString.getTableVariableName() + " it was detected there are " + $this$getInspectionString.getValue() + " duplicate rows");
            case 3 -> IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe("For " + $this$getInspectionString.getTableVariableName() + " it was detected that in column " + $this$getInspectionString.getColumnName() + " there are " + $this$getInspectionString.getValue() + " outliers calculate using - 1.5 \u00d7 IQR rule");
            case 4 -> IdeFormerSafeStringPrivacyWrapperKt.getPrivacySafe("For " + $this$getInspectionString.getTableVariableName() + " it was detected that the column " + $this$getInspectionString.getColumnName() + " contains only 1 unique value - " + $this$getInspectionString.getValue());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final CharSequence getPromptAllInspections$lambda$0(InspectionQuickFixInput it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)INSTANCE.getInspectionString(it);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Inspection.values().length];
            try {
                nArray[Inspection.NONE_COUNT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Inspection.DUPLICATE_ROWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Inspection.OUTLIERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Inspection.CONSTANT_COLUMNS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

