/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.ml.llm.mcp.client.McpClient;
import com.intellij.ml.llm.mcp.client.McpClientServiceBase;
import com.intellij.ml.llm.mcp.client.McpTool;
import com.intellij.ml.llm.mcp.client.endpoints.McpToolEndpoint;
import com.intellij.ml.llm.mcp.client.settings.McpApplicationServerConfigurationService;
import com.intellij.ml.llm.mcp.client.settings.McpProjectServerConfigurationService;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfiguration;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpClientService;", "Lcom/intellij/ml/llm/mcp/client/McpClientServiceBase;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "logs", "", "", "dispose", "", "getToolEndpoints", "", "Lcom/intellij/ml/llm/mcp/client/endpoints/McpToolEndpoint;", "getClients", "Lcom/intellij/ml/llm/mcp/client/McpClient;", "project", "Lcom/intellij/openapi/project/Project;", "configurationMoved", "serverConfiguration", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "registerLog", "name", "unregisterLog", "Companion", "McpProjectClientService", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpClientService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClientService.kt\ncom/intellij/ml/llm/mcp/client/McpClientService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1563#2:151\n1634#2,3:152\n1#3:155\n*S KotlinDebug\n*F\n+ 1 McpClientService.kt\ncom/intellij/ml/llm/mcp/client/McpClientService\n*L\n63#1:151\n63#1:152,3\n*E\n"})
public final class McpClientService
extends McpClientServiceBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> logs;
    @NotNull
    private static final List<String> loggerNames;

    public McpClientService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(cs);
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.logs = keySetView;
        McpApplicationServerConfigurationService configurationService = McpApplicationServerConfigurationService.Companion.getInstance();
        configurationService.addListener(this.getListener());
        this.registerClients(configurationService.getConfigurations());
        Companion.disableTransportLogger();
    }

    public void dispose() {
        McpApplicationServerConfigurationService.Companion.getInstance().removeListener(this.getListener());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<McpToolEndpoint> getToolEndpoints() {
        List result2 = new ArrayList();
        for (McpClient client2 : this.getClients$intellij_ml_llm_mcp()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (!client2.getServerConfiguration().getEnabled() || !client2.isRunning()) continue;
            Iterable iterable = client2.getTools();
            List list = result2;
            boolean $i$f$map = false;
            Project project2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void tool;
                McpTool mcpTool = (McpTool)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new McpToolEndpoint((McpTool)tool, client2, null));
            }
            list.addAll((List)destination$iv$iv);
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project2 : projectArray) {
            Intrinsics.checkNotNull((Object)project2);
            Project project3 = project2;
            result2.addAll((Collection)McpProjectClientService.Companion.getInstance(project3).getToolEndpoints());
        }
        return result2;
    }

    @NotNull
    public final List<McpClient> getClients(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return CollectionsKt.plus((Collection)this.getClients$intellij_ml_llm_mcp(), (Iterable)McpProjectClientService.Companion.getInstance(project2).getProjectClients());
    }

    @Override
    protected void configurationMoved(@NotNull McpServerConfiguration serverConfiguration) {
        Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project2 : projectArray) {
            Object v1;
            List<McpClient> projectClients;
            block2: {
                Intrinsics.checkNotNull((Object)project2);
                Project project3 = project2;
                projectClients = McpProjectClientService.Companion.getInstance(project3).getProjectClients();
                Iterable iterable = projectClients;
                for (Object t : iterable) {
                    McpClient it = (McpClient)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getServerConfiguration(), (Object)serverConfiguration)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            McpClient mcpClient = v1;
            if (mcpClient == null) continue;
            McpClient client2 = mcpClient;
            projectClients.remove(client2);
            this.getClients$intellij_ml_llm_mcp().add(client2);
            return;
        }
    }

    @NotNull
    public final String registerLog(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.logs.add(name)) {
            return name;
        }
        int index = 1;
        while (!this.logs.add(name + "-" + index)) {
            ++index;
        }
        return name + "-" + index;
    }

    public final void unregisterLog(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.logs.remove(name);
    }

    @JvmStatic
    @NotNull
    public static final McpClientService getInstance() {
        return Companion.getInstance();
    }

    static {
        Object[] objectArray = new String[]{"io.modelcontextprotocol.kotlin.sdk.client.StdioClientTransport", "io.modelcontextprotocol.kotlin.sdk.client.StreamableHttpClientTransport", "io.modelcontextprotocol.kotlin.sdk.client.SseClientTransport", "io.modelcontextprotocol.kotlin.sdk.client.Client"};
        loggerNames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpClientService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/mcp/client/McpClientService;", "loggerNames", "", "", "disableTransportLogger", "", "intellij.ml.llm.mcp"})
    @SourceDebugExtension(value={"SMAP\nMcpClientService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClientService.kt\ncom/intellij/ml/llm/mcp/client/McpClientService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,150:1\n30#2,2:151\n*S KotlinDebug\n*F\n+ 1 McpClientService.kt\ncom/intellij/ml/llm/mcp/client/McpClientService$Companion\n*L\n28#1:151,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final McpClientService getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<McpClientService> serviceClass$iv = McpClientService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (McpClientService)object;
        }

        public final void disableTransportLogger() {
            for (String name : loggerNames) {
                Logger transportLogger = Logger.getLogger(name);
                if (transportLogger.getLevel() != null) continue;
                transportLogger.setLevel(Level.OFF);
                KotlinLogging.INSTANCE.logger(name);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpClientService$McpProjectClientService;", "Lcom/intellij/ml/llm/mcp/client/McpClientServiceBase;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "dispose", "", "getToolEndpoints", "", "Lcom/intellij/ml/llm/mcp/client/endpoints/McpToolEndpoint;", "getProjectClients", "", "Lcom/intellij/ml/llm/mcp/client/McpClient;", "registerClient", "Lcom/intellij/openapi/application/AccessToken;", "serverConfiguration", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "registerClient$intellij_ml_llm_mcp", "configurationMoved", "Companion", "intellij.ml.llm.mcp"})
    @SourceDebugExtension(value={"SMAP\nMcpClientService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClientService.kt\ncom/intellij/ml/llm/mcp/client/McpClientService$McpProjectClientService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1374#2:151\n1460#2,2:152\n1563#2:154\n1634#2,3:155\n1462#2,3:158\n1#3:161\n*S KotlinDebug\n*F\n+ 1 McpClientService.kt\ncom/intellij/ml/llm/mcp/client/McpClientService$McpProjectClientService\n*L\n120#1:151\n120#1:152,2\n122#1:154\n122#1:155,3\n120#1:158,3\n*E\n"})
    public static final class McpProjectClientService
    extends McpClientServiceBase {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Project project;

        public McpProjectClientService(@NotNull Project project2, @NotNull CoroutineScope cs) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            super(cs);
            this.project = project2;
            McpProjectServerConfigurationService configurationService = McpProjectServerConfigurationService.Companion.getInstance(this.project);
            configurationService.addListener(this.getListener());
            this.registerClients(configurationService.getConfigurations());
        }

        public void dispose() {
            McpProjectServerConfigurationService.Companion.getInstance(this.project).removeListener(this.getListener());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<McpToolEndpoint> getToolEndpoints() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.getClients$intellij_ml_llm_mcp();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                McpClient client2 = (McpClient)element$iv$iv;
                boolean bl = false;
                if (client2.getServerConfiguration().getEnabled() && client2.isRunning()) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = client2.getTools();
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void tool;
                        McpTool mcpTool = (McpTool)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(new McpToolEndpoint((McpTool)tool, client2, this.project));
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<McpClient> getProjectClients() {
            return this.getClients$intellij_ml_llm_mcp();
        }

        @Override
        @NotNull
        public AccessToken registerClient$intellij_ml_llm_mcp(@NotNull McpServerConfiguration serverConfiguration) {
            Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
            if (!TrustedProjects.isProjectTrusted((Project)this.project)) {
                return new AccessToken(){

                    public void finish() {
                    }
                };
            }
            return super.registerClient$intellij_ml_llm_mcp(serverConfiguration);
        }

        @Override
        protected void configurationMoved(@NotNull McpServerConfiguration serverConfiguration) {
            Object v0;
            List<McpClient> applicationClients;
            block3: {
                Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
                if (!TrustedProjects.isProjectTrusted((Project)this.project)) {
                    return;
                }
                applicationClients = Companion.getInstance().getClients$intellij_ml_llm_mcp();
                Iterable iterable = applicationClients;
                for (Object t : iterable) {
                    McpClient it = (McpClient)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getServerConfiguration(), (Object)serverConfiguration)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            McpClient mcpClient = v0;
            if (mcpClient == null) {
                return;
            }
            McpClient client2 = mcpClient;
            applicationClients.remove(client2);
            this.getClients$intellij_ml_llm_mcp().add(client2);
        }

        @JvmStatic
        @NotNull
        public static final McpProjectClientService getInstance(@NotNull Project project2) {
            return Companion.getInstance(project2);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpClientService$McpProjectClientService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/mcp/client/McpClientService$McpProjectClientService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.mcp"})
        @SourceDebugExtension(value={"SMAP\nMcpClientService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClientService.kt\ncom/intellij/ml/llm/mcp/client/McpClientService$McpProjectClientService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,150:1\n30#2,2:151\n*S KotlinDebug\n*F\n+ 1 McpClientService.kt\ncom/intellij/ml/llm/mcp/client/McpClientService$McpProjectClientService$Companion\n*L\n106#1:151,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final McpProjectClientService getInstance(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                ComponentManager $this$service$iv = (ComponentManager)project2;
                boolean $i$f$service = false;
                Class<McpProjectClientService> serviceClass$iv = McpProjectClientService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (McpProjectClientService)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

