/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.ml.llm.mcp.client.McpSettingsChangedNotification;
import com.intellij.ml.llm.mcp.client.aie.AieBridgeService;
import com.intellij.ml.llm.mcp.client.aie.HttpMcpProvisioningServerConfig;
import com.intellij.ml.llm.mcp.client.aie.McpProvisioningServer;
import com.intellij.ml.llm.mcp.client.aie.McpProvisioningServerConfig;
import com.intellij.ml.llm.mcp.client.aie.McpProvisioningSettings;
import com.intellij.ml.llm.mcp.client.aie.StdioMcpProvisioningServerConfig;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeSource;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeType;
import com.intellij.ml.llm.mcp.client.settings.McpHashEncryptionKt;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfiguration;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationServiceBase;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationSource;
import com.intellij.ml.llm.mcp.client.settings.McpServerURL;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@State(name="McpApplicationServerCommands", storages={@Storage(value="llm.mcpServers.xml", roamingType=RoamingType.LOCAL)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 >2\u00020\u0001:\u0001>B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bH\u0014J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070%J\u0006\u0010&\u001a\u00020\u0007J4\u0010'\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0007H\u0016J&\u0010+\u001a\u00020\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150(2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0007H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020/H\u0016J\b\u00102\u001a\u00020\u0012H\u0016J\b\u00103\u001a\u00020\u0012H\u0014J\u0016\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00150(H\u0002J\b\u00107\u001a\u00020\u0012H\u0002J\u000e\u00108\u001a\u0004\u0018\u00010\u0015*\u000209H\u0002J\u000f\u0010:\u001a\u0004\u0018\u000105H\u0001\u00a2\u0006\u0002\b;J\r\u0010<\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b=R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\nR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpApplicationServerConfigurationService;", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationServiceBase;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "value", "", "autoEnableExternalChanges", "getAutoEnableExternalChanges", "()Z", "setAutoEnableExternalChanges$intellij_ml_llm_mcp", "(Z)V", "mcpJsonPath", "Ljava/nio/file/Path;", "getMcpJsonPath", "()Ljava/nio/file/Path;", "showSettingsChangedNotification", "", "configurations", "", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "changeType", "Lcom/intellij/ml/llm/mcp/client/settings/McpConfigurationChangeType;", "updateCustomConfigurations", "changeSource", "Lcom/intellij/ml/llm/mcp/client/settings/McpConfigurationChangeSource;", "", "modifiable", "getModifiable", "_validationFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "watchRequest", "Lcom/intellij/openapi/vfs/LocalFileSystem$WatchRequest;", "stateLock", "", "getValidationFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "isValidated", "setConfigurations", "", "levelChangedConfigurations", "save", "reloadConfigurations", "newConfigurations", "init", "getState", "Lorg/jdom/Element;", "loadState", "state", "noStateLoaded", "validateState", "calculateConfigurationsHash", "", "commands", "showHashMismatchError", "toConfiguration", "Lcom/intellij/ml/llm/mcp/client/aie/McpProvisioningServer;", "getCommandsHash", "getCommandsHash$intellij_ml_llm_mcp", "resetValidation", "resetValidation$intellij_ml_llm_mcp", "Companion", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpApplicationServerConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpApplicationServerConfigurationService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpApplicationServerConfigurationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n1869#2,2:310\n1056#2:312\n1#3:313\n13#4:314\n*S KotlinDebug\n*F\n+ 1 McpApplicationServerConfigurationService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpApplicationServerConfigurationService\n*L\n65#1:310,2\n236#1:312\n44#1:314\n*E\n"})
public final class McpApplicationServerConfigurationService
extends McpServerConfigurationServiceBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    private boolean autoEnableExternalChanges;
    @NotNull
    private final Path mcpJsonPath;
    private volatile boolean modifiable;
    @NotNull
    private final MutableStateFlow<Boolean> _validationFlow;
    @Nullable
    private LocalFileSystem.WatchRequest watchRequest;
    @NotNull
    private final Object stateLock;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String SETTINGS_HASH_KEY = "mcp.settings.hash";
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "MCP Client";
    @NotNull
    private static final String NOTIFICATION_ID_SETTING_ERROR = "mcp.client.settings.error";

    public McpApplicationServerConfigurationService(@NotNull CoroutineScope cs) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(cs);
        this.cs = cs;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Path path2 = PathManager.getTempDir().resolve(UUID.randomUUID().toString()).resolve(".ai/mcp/mcp.json");
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        } else {
            String string = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
            Path path3 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            Path path4 = path3.resolve(Registry.Companion.stringValue("llm.mcp.client.global.mcp.json.path"));
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        }
        this.mcpJsonPath = path;
        this.modifiable = true;
        this._validationFlow = StateFlowKt.MutableStateFlow((Object)false);
        try {
            Path path5 = this.getMcpJsonPath().getParent();
            if (path5 != null) {
                Path it = path5;
                boolean bl = false;
                this.watchRequest = LocalFileSystem.getInstance().addRootToWatch(((Object)it).toString(), false);
            }
        }
        catch (Exception exception) {
            LOG.warn("Failed to register file watcher for " + this.getMcpJsonPath());
        }
        Job job2 = (Job)this.getScope().getCoroutineContext().get((CoroutineContext.Key)Job.Key);
        if (job2 != null) {
            job2.invokeOnCompletion(arg_0 -> McpApplicationServerConfigurationService._init_$lambda$1(this, arg_0));
        }
        this.stateLock = new Object();
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ McpApplicationServerConfigurationService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)AieBridgeService.Companion.getInstance().getProvisioningSettings()), (Function2)((Function2)new Function2<McpProvisioningSettings, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$1;
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ McpApplicationServerConfigurationService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                McpProvisioningSettings mcpProvisioningSettings = (McpProvisioningSettings)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$mapNotNullTo$iv$iv;
                                        void $this$mapNotNull$iv;
                                        void settings2;
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (settings2 == null) {
                                            return Unit.INSTANCE;
                                        }
                                        Iterable iterable = settings2.getServers();
                                        McpApplicationServerConfigurationService mcpApplicationServerConfigurationService = this.this$0;
                                        boolean $i$f$mapNotNull = false;
                                        void var7_7 = $this$mapNotNull$iv;
                                        Collection destination$iv$iv = new ArrayList();
                                        boolean $i$f$mapNotNullTo = false;
                                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                        boolean $i$f$forEach = false;
                                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                                        while (iterator.hasNext()) {
                                            McpServerConfiguration it$iv$iv;
                                            Object element$iv$iv$iv;
                                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                                            boolean bl = false;
                                            McpProvisioningServer it = (McpProvisioningServer)element$iv$iv;
                                            boolean bl2 = false;
                                            if (mcpApplicationServerConfigurationService.toConfiguration(it) == null) continue;
                                            boolean bl3 = false;
                                            destination$iv$iv.add(it$iv$iv);
                                        }
                                        List provisioningConfigurations = (List)destination$iv$iv;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)settings2);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)provisioningConfigurations);
                                        this.label = 1;
                                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.getLoadedFlow()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this.this$0, (List<? extends McpServerConfiguration>)provisioningConfigurations, (McpProvisioningSettings)settings2, null){
                                            int label;
                                            /* synthetic */ boolean Z$0;
                                            final /* synthetic */ McpApplicationServerConfigurationService this$0;
                                            final /* synthetic */ List<McpServerConfiguration> $provisioningConfigurations;
                                            final /* synthetic */ McpProvisioningSettings $settings;
                                            {
                                                this.this$0 = $receiver;
                                                this.$provisioningConfigurations = $provisioningConfigurations;
                                                this.$settings = $settings;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             * Could not resolve type clashes
                                             * Unable to fully structure code
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                var2_2 = this.Z$0;
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        if (loaded == false) {
                                                            return Unit.INSTANCE;
                                                        }
                                                        oldConfigurations = this.this$0.getConfigurations();
                                                        newConfigurations = new ArrayList<Object>();
                                                        for (Object provisioningConfiguration : this.$provisioningConfigurations) {
                                                            var9_12 = oldConfigurations;
                                                            for (T var11_16 : var9_12) {
                                                                it = (McpServerConfiguration)var11_16;
                                                                $i$a$-find-McpApplicationServerConfigurationService$4$1$1$oldConfiguration$1 = false;
                                                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)provisioningConfiguration.getName())) continue;
                                                                v0 = var11_16;
                                                                ** GOTO lbl20
                                                            }
                                                            v0 = null;
lbl20:
                                                            // 2 sources

                                                            oldConfiguration = v0;
                                                            if (oldConfiguration != null) {
                                                                enabled = oldConfiguration.getEnabled();
                                                                var10_13 = provisioningConfiguration;
                                                                newConfiguration = var10_13 instanceof McpServerCommand != false && oldConfiguration instanceof McpServerCommand != false ? (McpServerConfiguration)new McpServerCommand((McpServerCommand)oldConfiguration) : (var10_13 instanceof McpServerURL != false && oldConfiguration instanceof McpServerURL != false ? (McpServerConfiguration)new McpServerURL(oldConfiguration) : null);
                                                                if (newConfiguration == null) continue;
                                                                newConfiguration.copyFrom((McpServerConfiguration)provisioningConfiguration);
                                                                newConfiguration.setEnabled(enabled != false);
                                                                newConfigurations.add(newConfiguration);
                                                                continue;
                                                            }
                                                            Boxing.boxBoolean((boolean)newConfigurations.add(provisioningConfiguration));
                                                        }
                                                        stateChanged = this.this$0.getModifiable() != this.$settings.getAllowMcpServerManagement();
                                                        provisioningConfiguration = McpApplicationServerConfigurationService.access$getStateLock$p(this.this$0);
                                                        var7_8 = this.this$0;
                                                        enabled = this.$settings;
                                                        newConfiguration = provisioningConfiguration;
                                                        synchronized (newConfiguration) {
                                                            $i$a$-synchronized-McpApplicationServerConfigurationService$4$1$1$1 = false;
                                                            McpApplicationServerConfigurationService.access$get_validationFlow$p((McpApplicationServerConfigurationService)var7_8).setValue((Object)Boxing.boxBoolean((boolean)true));
                                                            McpApplicationServerConfigurationService.access$setModifiable$p((McpApplicationServerConfigurationService)var7_8, enabled.getAllowMcpServerManagement());
                                                            $i$a$-synchronized-McpApplicationServerConfigurationService$4$1$1$1 = Unit.INSTANCE;
                                                        }
                                                        if (!this.$settings.getAllowMcpServerManagement()) ** GOTO lbl84
                                                        if (this.$provisioningConfigurations.isEmpty()) {
                                                            if (stateChanged) {
                                                                this.this$0.fireConfigurationsChanged();
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                        provisioningConfiguration = oldConfigurations;
                                                        var7_8 = this.$provisioningConfigurations;
                                                        var22_22 = newConfigurations;
                                                        $i$f$filter = false;
                                                        newConfiguration = $this$filter$iv;
                                                        destination$iv$iv = new ArrayList<E>();
                                                        $i$f$filterTo = false;
                                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                                            oldCommand = (McpServerConfiguration)element$iv$iv;
                                                            $i$a$-filter-McpApplicationServerConfigurationService$4$1$1$2 = false;
                                                            $this$none$iv = (Iterable)var7_8;
                                                            $i$f$none = false;
                                                            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl70
                                                            v1 = true;
                                                            ** GOTO lbl78
lbl70:
                                                            // 2 sources

                                                            for (T element$iv : $this$none$iv) {
                                                                it = (McpServerConfiguration)element$iv;
                                                                $i$a$-none-McpApplicationServerConfigurationService$4$1$1$2$1 = false;
                                                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)oldCommand.getName())) continue;
                                                                v1 = false;
                                                                ** GOTO lbl78
                                                            }
                                                            v1 = true;
lbl78:
                                                            // 3 sources

                                                            if (!v1) continue;
                                                            destination$iv$iv.add(element$iv$iv);
                                                        }
                                                        var22_22.addAll((List)destination$iv$iv);
lbl84:
                                                        // 2 sources

                                                        McpApplicationServerConfigurationService.access$setConfigurations$s1650941645(this.this$0, newConfigurations, CollectionsKt.emptyList(), McpConfigurationChangeSource.AIE, true);
                                                        if (stateChanged) {
                                                            this.this$0.fireConfigurationsChanged();
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                var3_3.Z$0 = (Boolean)value;
                                                return (Continuation)var3_3;
                                            }

                                            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        List provisioningConfigurations = (List)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(McpProvisioningSettings p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean getAutoEnableExternalChanges() {
        return this.autoEnableExternalChanges;
    }

    public final void setAutoEnableExternalChanges$intellij_ml_llm_mcp(boolean bl) {
        this.autoEnableExternalChanges = bl;
    }

    @Override
    @NotNull
    public Path getMcpJsonPath() {
        return this.mcpJsonPath;
    }

    @Override
    public void showSettingsChangedNotification(@NotNull Collection<? extends McpServerConfiguration> configurations, @NotNull McpConfigurationChangeType changeType) {
        Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
        McpSettingsChangedNotification.INSTANCE.showSettingsChangedNotification(null, configurations, changeType);
    }

    @Override
    protected void updateCustomConfigurations(@NotNull McpConfigurationChangeSource changeSource, @NotNull List<McpServerConfiguration> configurations) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeSource), (String)"changeSource");
        Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
        if (changeSource == McpConfigurationChangeSource.NOTIFICATION) {
            Iterable $this$forEach$iv = configurations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                McpServerConfiguration it = (McpServerConfiguration)element$iv;
                boolean bl = false;
                it.setEnabled(!this.autoEnableExternalChanges);
            }
        }
    }

    public final boolean getModifiable() {
        return this.modifiable;
    }

    @NotNull
    public final SharedFlow<Boolean> getValidationFlow() {
        return FlowKt.asSharedFlow((MutableSharedFlow)((MutableSharedFlow)this._validationFlow));
    }

    public final boolean isValidated() {
        return (Boolean)this._validationFlow.getValue();
    }

    @Override
    public void setConfigurations(@NotNull List<? extends McpServerConfiguration> configurations, @NotNull Collection<? extends McpServerConfiguration> levelChangedConfigurations, @NotNull McpConfigurationChangeSource changeSource, boolean save) {
        Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter(levelChangedConfigurations, (String)"levelChangedConfigurations");
        Intrinsics.checkNotNullParameter((Object)((Object)changeSource), (String)"changeSource");
        if (!this.modifiable) {
            if (!levelChangedConfigurations.isEmpty()) {
                return;
            }
            List<McpServerConfiguration> existingConfigurations = this.getConfigurations();
            if (existingConfigurations.size() != configurations.size()) {
                return;
            }
            int n = ((Collection)existingConfigurations).size();
            for (int i = 0; i < n; ++i) {
                McpServerConfiguration newConfiguration;
                McpServerConfiguration existingConfiguration = existingConfigurations.get(i);
                if (existingConfiguration.isEquivalent(newConfiguration = configurations.get(i))) continue;
                return;
            }
        }
        super.setConfigurations(configurations, levelChangedConfigurations, changeSource, save);
    }

    @Override
    public void reloadConfigurations(@NotNull List<? extends McpServerConfiguration> newConfigurations, @NotNull McpConfigurationChangeSource changeSource, boolean init) {
        Intrinsics.checkNotNullParameter(newConfigurations, (String)"newConfigurations");
        Intrinsics.checkNotNullParameter((Object)((Object)changeSource), (String)"changeSource");
        if (init) {
            super.setConfigurations(newConfigurations, CollectionsKt.emptyList(), changeSource, false);
        } else {
            this.setConfigurations(newConfigurations, CollectionsKt.emptyList(), changeSource, false);
        }
    }

    @Override
    @NotNull
    public Element getState() {
        Element element2 = super.getState();
        element2.setAttribute("modifiable", String.valueOf(this.modifiable));
        if (!this.modifiable) {
            String hash = this.calculateConfigurationsHash(this.getConfigurations());
            String encryptedHash = McpHashEncryptionKt.encryptHash(hash);
            PropertiesComponent.getInstance().setValue(SETTINGS_HASH_KEY, encryptedHash);
        } else {
            PropertiesComponent.getInstance().setValue(SETTINGS_HASH_KEY, null);
        }
        element2.setAttribute("autoEnableExternalChanges", String.valueOf(this.autoEnableExternalChanges));
        return element2;
    }

    @Override
    public void loadState(@NotNull Element state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (RunOnceUtil.runOnceForApp((String)"MCP settings loaded", () -> McpApplicationServerConfigurationService.loadState$lambda$0(this))) {
            return;
        }
        Object object = state2.getAttributeValue("modifiable");
        this.modifiable = object != null && (object = StringsKt.toBooleanStrictOrNull((String)object)) != null ? (Boolean)object : true;
        Attribute attribute = state2.getAttribute("autoEnableExternalChanges");
        this.autoEnableExternalChanges = attribute != null ? attribute.getBooleanValue() : false;
        super.loadState(state2);
    }

    @Override
    public void noStateLoaded() {
        if (RunOnceUtil.runOnceForApp((String)"MCP settings loaded", McpApplicationServerConfigurationService::noStateLoaded$lambda$0)) {
            super.noStateLoaded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateState() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            if (!this._validationFlow.compareAndSet((Object)false, (Object)true)) {
                return;
            }
            String storedEncryptedHash = PropertiesComponent.getInstance().getValue(SETTINGS_HASH_KEY);
            if (storedEncryptedHash != null) {
                String storedHash = McpHashEncryptionKt.decryptHash(storedEncryptedHash);
                String currentHash = this.calculateConfigurationsHash(this.getConfigurations());
                if (this.modifiable || storedHash == null || !Intrinsics.areEqual((Object)storedHash, (Object)currentHash)) {
                    this.modifiable = false;
                    super.setConfigurations(CollectionsKt.emptyList(), CollectionsKt.emptyList(), McpConfigurationChangeSource.AIE, true);
                    this.showHashMismatchError();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String calculateConfigurationsHash(List<? extends McpServerConfiguration> commands) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        Iterable $this$sortedBy$iv = commands;
        boolean $i$f$sortedBy = false;
        for (McpServerConfiguration command : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                McpServerConfiguration it = (McpServerConfiguration)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (McpServerConfiguration)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        })) {
            byte[] byArray;
            String string;
            McpServerConfiguration mcpServerConfiguration;
            block6: {
                List<String> list;
                block8: {
                    block7: {
                        mcpServerConfiguration = command;
                        if (!(mcpServerConfiguration instanceof McpServerCommand)) break block6;
                        string = command.getName();
                        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                        digest.update(byArray2);
                        string = ((McpServerCommand)command).getProgramPath();
                        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                        digest.update(byArray3);
                        string = ((McpServerCommand)command).getArguments();
                        byte[] byArray4 = string.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
                        digest.update(byArray4);
                        string = ((McpServerCommand)command).getWorkingDirectory();
                        byte[] byArray5 = string.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"getBytes(...)");
                        digest.update(byArray5);
                        String string2 = ((McpServerCommand)command).getEnvData().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        string = string2;
                        byte[] byArray6 = string.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray6, (String)"getBytes(...)");
                        digest.update(byArray6);
                        list = command.getAllowedToolsNames();
                        if (list == null || (list = list.toString()) == null) break block7;
                        List<String> list2 = list;
                        byte[] byArray7 = ((String)((Object)list2)).getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray7, (String)"getBytes(...)");
                        list = (List<String>)byArray7;
                        if (byArray7 != null) break block8;
                    }
                    list = (List<String>)new byte[0];
                }
                digest.update((byte[])list);
                continue;
            }
            if (!(mcpServerConfiguration instanceof McpServerURL)) continue;
            string = command.getName();
            byte[] byArray8 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray8, (String)"getBytes(...)");
            digest.update(byArray8);
            string = ((McpServerURL)command).getUrl();
            byte[] byArray9 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray9, (String)"getBytes(...)");
            digest.update(byArray9);
            if (((McpServerURL)command).getType() != null) {
                String string3;
                byte[] byArray10 = string3.getBytes(Charsets.UTF_8);
                byArray = byArray10;
                Intrinsics.checkNotNullExpressionValue((Object)byArray10, (String)"getBytes(...)");
            } else {
                byArray = null;
            }
            digest.update(byArray);
            string = String.valueOf(((McpServerURL)command).getHeaders());
            byte[] byArray11 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray11, (String)"getBytes(...)");
            digest.update(byArray11);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, McpApplicationServerConfigurationService::calculateConfigurationsHash$lambda$1, (int)30, null);
    }

    private final void showHashMismatchError() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID);
        String string = McpBundle.message("ml.llm.mcp.settings.error.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = McpBundle.message("ml.llm.mcp.settings.error.notification.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        notificationGroup.createNotification(string, string2, NotificationType.ERROR).setDisplayId(NOTIFICATION_ID_SETTING_ERROR).notify(null);
    }

    private final McpServerConfiguration toConfiguration(McpProvisioningServer $this$toConfiguration) {
        McpServerConfiguration mcpServerConfiguration;
        McpProvisioningServerConfig mcpProvisioningServerConfig = $this$toConfiguration.getConfig();
        if (mcpProvisioningServerConfig instanceof StdioMcpProvisioningServerConfig) {
            Map map2;
            String string = $this$toConfiguration.getName();
            String string2 = ((StdioMcpProvisioningServerConfig)$this$toConfiguration.getConfig()).getCommand();
            List<String> list = ((StdioMcpProvisioningServerConfig)$this$toConfiguration.getConfig()).getArguments();
            if (list == null || (list = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)) == null) {
                list = "";
            }
            if ((map2 = ((StdioMcpProvisioningServerConfig)$this$toConfiguration.getConfig()).getEnvVariables()) == null) {
                map2 = MapsKt.emptyMap();
            }
            EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map)map2, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
            mcpServerConfiguration = new McpServerCommand(string, string2, (String)((Object)list), "", environmentVariablesData, false, McpServerConfigurationSource.AIE);
        } else if (mcpProvisioningServerConfig instanceof HttpMcpProvisioningServerConfig) {
            mcpServerConfiguration = new McpServerURL($this$toConfiguration.getName(), ((HttpMcpProvisioningServerConfig)$this$toConfiguration.getConfig()).getUrl(), ((HttpMcpProvisioningServerConfig)$this$toConfiguration.getConfig()).getType().name(), ((HttpMcpProvisioningServerConfig)$this$toConfiguration.getConfig()).getHeaders(), false, McpServerConfigurationSource.AIE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mcpServerConfiguration;
    }

    @TestOnly
    @Nullable
    public final String getCommandsHash$intellij_ml_llm_mcp() {
        String string;
        String encryptedHash;
        String string2 = encryptedHash = PropertiesComponent.getInstance().getValue(SETTINGS_HASH_KEY);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = McpHashEncryptionKt.decryptHash(it);
        } else {
            string = null;
        }
        return string;
    }

    @TestOnly
    public final void resetValidation$intellij_ml_llm_mcp() {
        this._validationFlow.setValue((Object)false);
        for (McpServerConfiguration configuration : this.getConfigurations()) {
            this.fireConfigurationRemoved(configuration);
        }
    }

    private static final Unit _init_$lambda$1(McpApplicationServerConfigurationService this$0, Throwable it) {
        block0: {
            LocalFileSystem.WatchRequest watchRequest = this$0.watchRequest;
            if (watchRequest == null) break block0;
            LocalFileSystem.WatchRequest it2 = watchRequest;
            boolean bl = false;
            LocalFileSystem.getInstance().removeWatchedRoot(it2);
        }
        return Unit.INSTANCE;
    }

    private static final void loadState$lambda$0(McpApplicationServerConfigurationService this$0) {
        this$0.loadOldConfigurations();
    }

    private static final void noStateLoaded$lambda$0() {
    }

    private static final CharSequence calculateConfigurationsHash$lambda$1(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final McpApplicationServerConfigurationService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Object access$getStateLock$p(McpApplicationServerConfigurationService $this) {
        return $this.stateLock;
    }

    public static final /* synthetic */ void access$setConfigurations$s1650941645(McpApplicationServerConfigurationService $this, List configurations, Collection levelChangedConfigurations, McpConfigurationChangeSource changeSource, boolean save) {
        super.setConfigurations(configurations, levelChangedConfigurations, changeSource, save);
    }

    public static final /* synthetic */ MutableStateFlow access$get_validationFlow$p(McpApplicationServerConfigurationService $this) {
        return $this._validationFlow;
    }

    public static final /* synthetic */ void access$setModifiable$p(McpApplicationServerConfigurationService $this, boolean bl) {
        $this.modifiable = bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(McpServerConfigurationServiceBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpApplicationServerConfigurationService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/mcp/client/settings/McpApplicationServerConfigurationService;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SETTINGS_HASH_KEY", "", "NOTIFICATION_GROUP_ID", "NOTIFICATION_ID_SETTING_ERROR", "intellij.ml.llm.mcp"})
    @SourceDebugExtension(value={"SMAP\nMcpApplicationServerConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpApplicationServerConfigurationService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpApplicationServerConfigurationService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,309:1\n42#2,3:310\n*S KotlinDebug\n*F\n+ 1 McpApplicationServerConfigurationService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpApplicationServerConfigurationService$Companion\n*L\n42#1:310,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final McpApplicationServerConfigurationService getInstance() {
            boolean $i$f$service = false;
            Class<McpApplicationServerConfigurationService> serviceClass$iv = McpApplicationServerConfigurationService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (McpApplicationServerConfigurationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

