/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.ml.llm.mcp.client.McpSettingsChangedNotification;
import com.intellij.ml.llm.mcp.client.settings.McpApplicationServerConfigurationService;
import com.intellij.ml.llm.mcp.client.settings.McpConfigurationChangeType;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfiguration;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationServiceBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="McpProjectServerCommands", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0014J\u001e\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J\r\u0010\u0018\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0019J\r\u0010\u001a\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpProjectServerConfigurationService;", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationServiceBase;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getConfigurations", "", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "mcpJsonPath", "Ljava/nio/file/Path;", "getMcpJsonPath", "()Ljava/nio/file/Path;", "fireConfigurationAdded", "", "configuration", "showSettingsChangedNotification", "configurations", "", "changeType", "Lcom/intellij/ml/llm/mcp/client/settings/McpConfigurationChangeType;", "requestRestart", "onProjectTrusted", "onProjectTrusted$intellij_ml_llm_mcp", "onProjectUntrusted", "onProjectUntrusted$intellij_ml_llm_mcp", "loadState", "state", "Lorg/jdom/Element;", "noStateLoaded", "Companion", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpProjectServerConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpProjectServerConfigurationService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpProjectServerConfigurationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class McpProjectServerConfigurationService
extends McpServerConfigurationServiceBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public McpProjectServerConfigurationService(@NotNull Project project2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(scope);
        this.project = project2;
    }

    @Override
    @NotNull
    public List<McpServerConfiguration> getConfigurations() {
        if (!TrustedProjects.isProjectTrusted((Project)this.project) || !McpApplicationServerConfigurationService.Companion.getInstance().getModifiable()) {
            return CollectionsKt.emptyList();
        }
        return super.getConfigurations();
    }

    @Override
    @Nullable
    public Path getMcpJsonPath() {
        Path path;
        String string;
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)this.project);
        if (virtualFile2 != null && (string = virtualFile2.getPath()) != null) {
            String it = string;
            boolean bl = false;
            Path path2 = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            path = path2.resolve(Registry.Companion.stringValue("llm.mcp.client.project.mcp.json.path"));
        } else {
            path = null;
        }
        return path;
    }

    @Override
    protected void fireConfigurationAdded(@NotNull McpServerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (!TrustedProjects.isProjectTrusted((Project)this.project)) {
            return;
        }
        super.fireConfigurationAdded(configuration);
    }

    @Override
    public void showSettingsChangedNotification(@NotNull Collection<? extends McpServerConfiguration> configurations, @NotNull McpConfigurationChangeType changeType) {
        Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
        McpSettingsChangedNotification.INSTANCE.showSettingsChangedNotification(this.project, configurations, changeType);
    }

    @Override
    public void requestRestart(@NotNull McpServerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (!TrustedProjects.isProjectTrusted((Project)this.project)) {
            return;
        }
        super.requestRestart(configuration);
    }

    public final void onProjectTrusted$intellij_ml_llm_mcp() {
        for (McpServerConfiguration configuration : super.getConfigurations()) {
            this.fireConfigurationAdded(configuration);
        }
    }

    public final void onProjectUntrusted$intellij_ml_llm_mcp() {
        for (McpServerConfiguration configuration : super.getConfigurations()) {
            this.fireConfigurationRemoved(configuration);
        }
    }

    @Override
    public void loadState(@NotNull Element state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (RunOnceUtil.runOnceForProject((Project)this.project, (String)"MCP Project settings loaded", () -> McpProjectServerConfigurationService.loadState$lambda$0(this))) {
            return;
        }
        super.loadState(state2);
    }

    @Override
    public void noStateLoaded() {
        if (RunOnceUtil.runOnceForProject((Project)this.project, (String)"MCP Project settings loaded", McpProjectServerConfigurationService::noStateLoaded$lambda$0)) {
            return;
        }
        super.noStateLoaded();
    }

    private static final void loadState$lambda$0(McpProjectServerConfigurationService this$0) {
        this$0.loadOldConfigurations();
    }

    private static final void noStateLoaded$lambda$0() {
    }

    @JvmStatic
    @NotNull
    public static final McpProjectServerConfigurationService getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpProjectServerConfigurationService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/mcp/client/settings/McpProjectServerConfigurationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.mcp"})
    @SourceDebugExtension(value={"SMAP\nMcpProjectServerConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpProjectServerConfigurationService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpProjectServerConfigurationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,75:1\n30#2,2:76\n*S KotlinDebug\n*F\n+ 1 McpProjectServerConfigurationService.kt\ncom/intellij/ml/llm/mcp/client/settings/McpProjectServerConfigurationService$Companion\n*L\n21#1:76,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final McpProjectServerConfigurationService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<McpProjectServerConfigurationService> serviceClass$iv = McpProjectServerConfigurationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (McpProjectServerConfigurationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

