/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.diagnostics;

import com.intellij.ml.diagnostics.DiagnosticEvent;
import com.intellij.ml.diagnostics.DiagnosticEventBus;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.ComputedDiff;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditComputed;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditContextComposed;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditDiffContent;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditEvent;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditEventPayload;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditModelCalled;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditModelResponse;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditPerformanceMetrics;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditPromptComposed;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditProviderFinished;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditProviderPerformanceMetrics;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditProviderReporter;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditTargetFile;
import com.intellij.ml.llm.nextEdits.common.pipeline.NextEditIterationFilterDescriptor;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditSuggestionSimilarityId;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0007H\u0016J\u0017\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.H\u0016\u00a2\u0006\u0004\b/\u00100J\u0017\u00101\u001a\u00020'2\u0006\u00102\u001a\u00020.H\u0016\u00a2\u0006\u0004\b3\u00100J\u0017\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020.H\u0016\u00a2\u0006\u0004\b6\u00100J\u0017\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020.H\u0016\u00a2\u0006\u0004\b9\u00100J\u0010\u0010:\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0007H\u0016J\b\u0010;\u001a\u00020'H\u0016J\u0010\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020\u0007H\u0016J \u0010>\u001a\u00020'2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020BH\u0016J\u0016\u0010C\u001a\u00020'2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\b\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010G\u001a\u00020'2\u0006\u0010H\u001a\u00020\t2\u0006\u0010I\u001a\u00020\tH\u0016J\u0010\u0010J\u001a\u00020'2\u0006\u0010K\u001a\u00020\u0007H\u0016J\n\u0010L\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010M\u001a\u0004\u0018\u00010\u0007H\u0016J\u000f\u0010N\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010OJ\u000f\u0010P\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010OJ\u000f\u0010Q\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010OJ\u000f\u0010R\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010OJ\n\u0010S\u001a\u0004\u0018\u00010\u0007H\u0016J\u0016\u0010T\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010%H\u0016J\b\u0010U\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010$\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010%0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditProviderReporterImpl;", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditProviderReporter;", "project", "Lcom/intellij/openapi/project/Project;", "requestId", "", "providerId", "", "processedResponseSize", "", "<init>", "(Lcom/intellij/openapi/project/Project;JLjava/lang/String;Ljava/lang/Integer;)V", "getProviderId", "()Ljava/lang/String;", "getProcessedResponseSize", "()Ljava/lang/Integer;", "setProcessedResponseSize", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "performanceMetrics", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditProviderPerformanceMetrics;", "taskId", "Ljava/util/concurrent/atomic/AtomicReference;", "filterReason", "Lcom/intellij/ml/llm/nextEdits/common/pipeline/NextEditIterationFilterDescriptor;", "totalInsertLength", "Ljava/util/concurrent/atomic/AtomicInteger;", "totalDeleteLength", "totalInsertedLinesNumber", "totalDeletedLinesNumber", "totalDiffs", "diffContents", "", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditDiffContent;", "requestContextJson", "rawModelOutput", "editableRegion", "Lkotlin/Pair;", "fire", "", "nextEditSessionMessage", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditEventPayload;", "onContextComposed", "prompt", "setRequestWaitingTime", "requestWaitingTime", "Lkotlin/time/Duration;", "setRequestWaitingTime-LRDsOJo", "(J)V", "setContextCollectionTime", "contextCollectionTime", "setContextCollectionTime-LRDsOJo", "setClientExecutionTime", "clientExecutionTime", "setClientExecutionTime-LRDsOJo", "setIterationFilterTime", "iterationFilterTime", "setIterationFilterTime-LRDsOJo", "onPromptComposed", "onModelCalled", "onClientResponse", "modelOutput", "onTargetFile", "before", "after", "suggestionId", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;", "onDiffComputed", "getComputedDiff", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/ComputedDiff;", "onFilteredSuggestion", "setEditableRegion", "start", "end", "setTaskId", "taskID", "getTaskId", "getContextComposed", "getRequestWaitingTime", "()Ljava/lang/Long;", "getContextCollectionTime", "getClientExecutionTime", "getIterationFilterTime", "getClientResponse", "getEditableRegion", "onProviderFinished", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditSessionEventsReporterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSessionEventsReporterImpl.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditProviderReporterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,564:1\n1#2:565\n*E\n"})
public final class NextEditProviderReporterImpl
implements NextEditProviderReporter {
    @NotNull
    private final Project project;
    private final long requestId;
    @NotNull
    private final String providerId;
    @Nullable
    private Integer processedResponseSize;
    @NotNull
    private final NextEditProviderPerformanceMetrics performanceMetrics;
    @NotNull
    private final AtomicReference<String> taskId;
    @NotNull
    private final AtomicReference<NextEditIterationFilterDescriptor> filterReason;
    @NotNull
    private final AtomicInteger totalInsertLength;
    @NotNull
    private final AtomicInteger totalDeleteLength;
    @NotNull
    private final AtomicInteger totalInsertedLinesNumber;
    @NotNull
    private final AtomicInteger totalDeletedLinesNumber;
    @NotNull
    private final AtomicInteger totalDiffs;
    @NotNull
    private final AtomicReference<List<NextEditDiffContent>> diffContents;
    @NotNull
    private final AtomicReference<String> requestContextJson;
    @NotNull
    private final AtomicReference<String> rawModelOutput;
    @NotNull
    private final AtomicReference<Pair<Integer, Integer>> editableRegion;

    public NextEditProviderReporterImpl(@NotNull Project project2, long requestId, @NotNull String providerId, @Nullable Integer processedResponseSize) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        this.project = project2;
        this.requestId = requestId;
        this.providerId = providerId;
        this.processedResponseSize = processedResponseSize;
        this.performanceMetrics = new NextEditProviderPerformanceMetrics(null, null, null, null, 15, null);
        this.taskId = new AtomicReference<Object>(null);
        this.filterReason = new AtomicReference<Object>(null);
        this.totalInsertLength = new AtomicInteger(0);
        this.totalDeleteLength = new AtomicInteger(0);
        this.totalInsertedLinesNumber = new AtomicInteger(0);
        this.totalDeletedLinesNumber = new AtomicInteger(0);
        this.totalDiffs = new AtomicInteger(0);
        this.diffContents = new AtomicReference<List>(CollectionsKt.emptyList());
        this.requestContextJson = new AtomicReference<Object>(null);
        this.rawModelOutput = new AtomicReference<Object>(null);
        this.editableRegion = new AtomicReference<Object>(null);
    }

    public /* synthetic */ NextEditProviderReporterImpl(Project project2, long l, String string, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        this(project2, l, string, n);
    }

    @Override
    @NotNull
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    @Nullable
    public Integer getProcessedResponseSize() {
        return this.processedResponseSize;
    }

    @Override
    public void setProcessedResponseSize(@Nullable Integer n) {
        this.processedResponseSize = n;
    }

    private final void fire(NextEditEventPayload nextEditSessionMessage) {
        DiagnosticEventBus.Companion.getInstance().fire(() -> NextEditProviderReporterImpl.fire$lambda$0(this, nextEditSessionMessage));
    }

    @Override
    public void onContextComposed(@NotNull String prompt2) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        this.requestContextJson.set(prompt2);
        this.fire(new NextEditContextComposed(prompt2));
    }

    @Override
    public void setRequestWaitingTime-LRDsOJo(long l) {
        this.performanceMetrics.getRequestWaitingTime().set(Duration.getInWholeMilliseconds-impl((long)l));
    }

    @Override
    public void setContextCollectionTime-LRDsOJo(long l) {
        this.performanceMetrics.getContextCollectionTime().set(Duration.getInWholeMilliseconds-impl((long)l));
    }

    @Override
    public void setClientExecutionTime-LRDsOJo(long l) {
        this.performanceMetrics.getClientExecutionTime().set(Duration.getInWholeMilliseconds-impl((long)l));
    }

    @Override
    public void setIterationFilterTime-LRDsOJo(long l) {
        this.performanceMetrics.getIterationFilterTime().set(Duration.getInWholeMilliseconds-impl((long)l));
    }

    @Override
    public void onPromptComposed(@NotNull String prompt2) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        this.fire(new NextEditPromptComposed(prompt2));
    }

    @Override
    public void onModelCalled() {
        this.fire(NextEditModelCalled.INSTANCE);
    }

    @Override
    public void onClientResponse(@NotNull String modelOutput) {
        Intrinsics.checkNotNullParameter((Object)modelOutput, (String)"modelOutput");
        this.rawModelOutput.set(modelOutput);
        this.fire(new NextEditModelResponse(modelOutput));
    }

    @Override
    public void onTargetFile(@NotNull String before, @NotNull String after, @NotNull NextEditSuggestionSimilarityId suggestionId) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        Intrinsics.checkNotNullParameter((Object)suggestionId, (String)"suggestionId");
        this.fire(new NextEditTargetFile(before, after, suggestionId));
    }

    @Override
    public void onDiffComputed(@NotNull List<NextEditDiffContent> diffContents) {
        int n;
        NextEditDiffContent it;
        int n2;
        Intrinsics.checkNotNullParameter(diffContents, (String)"diffContents");
        Iterable iterable = diffContents;
        AtomicInteger atomicInteger = this.totalInsertLength;
        int n3 = 0;
        for (Object t : iterable) {
            NextEditDiffContent nextEditDiffContent = (NextEditDiffContent)t;
            n2 = n3;
            boolean bl = false;
            n = it.getInsertedLength();
            n3 = n2 + n;
        }
        n2 = n3;
        atomicInteger.set(n2);
        iterable = diffContents;
        atomicInteger = this.totalDeleteLength;
        n3 = 0;
        for (Object t : iterable) {
            it = (NextEditDiffContent)t;
            n2 = n3;
            boolean bl = false;
            n = it.getDeletedLength();
            n3 = n2 + n;
        }
        n2 = n3;
        atomicInteger.set(n2);
        iterable = diffContents;
        atomicInteger = this.totalInsertedLinesNumber;
        n3 = 0;
        for (Object t : iterable) {
            it = (NextEditDiffContent)t;
            n2 = n3;
            boolean bl = false;
            n = it.getInsertedLinesNumber();
            n3 = n2 + n;
        }
        n2 = n3;
        atomicInteger.set(n2);
        iterable = diffContents;
        atomicInteger = this.totalDeletedLinesNumber;
        n3 = 0;
        for (Object t : iterable) {
            it = (NextEditDiffContent)t;
            n2 = n3;
            boolean bl = false;
            n = it.getDeletedLinesNumber();
            n3 = n2 + n;
        }
        n2 = n3;
        atomicInteger.set(n2);
        this.totalDiffs.set(diffContents.size());
        this.diffContents.set(diffContents);
        this.fire(new NextEditComputed(diffContents));
    }

    @Override
    @NotNull
    public ComputedDiff getComputedDiff() {
        int n = this.totalDiffs.get();
        int n2 = this.totalInsertLength.get();
        int n3 = this.totalDeleteLength.get();
        int n4 = this.totalInsertedLinesNumber.get();
        int n5 = this.totalDeletedLinesNumber.get();
        List<NextEditDiffContent> list = this.diffContents.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        return new ComputedDiff(n, n2, n3, n4, n5, list);
    }

    @Override
    public void onFilteredSuggestion(@NotNull NextEditIterationFilterDescriptor filterReason) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterReason), (String)"filterReason");
        this.filterReason.set(filterReason);
    }

    @Override
    public void setEditableRegion(int start2, int end) {
        this.editableRegion.set((Pair<Integer, Integer>)TuplesKt.to((Object)start2, (Object)end));
    }

    @Override
    public void setTaskId(@NotNull String taskID) {
        Intrinsics.checkNotNullParameter((Object)taskID, (String)"taskID");
        this.taskId.set(taskID);
    }

    @Override
    @Nullable
    public String getTaskId() {
        return this.taskId.get();
    }

    @Override
    @Nullable
    public String getContextComposed() {
        return this.requestContextJson.get();
    }

    @Override
    @Nullable
    public Long getRequestWaitingTime() {
        return this.performanceMetrics.getRequestWaitingTime().get();
    }

    @Override
    @Nullable
    public Long getContextCollectionTime() {
        return this.performanceMetrics.getContextCollectionTime().get();
    }

    @Override
    @Nullable
    public Long getClientExecutionTime() {
        return this.performanceMetrics.getClientExecutionTime().get();
    }

    @Override
    @Nullable
    public Long getIterationFilterTime() {
        return this.performanceMetrics.getIterationFilterTime().get();
    }

    @Override
    @Nullable
    public String getClientResponse() {
        return this.rawModelOutput.get();
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> getEditableRegion() {
        return this.editableRegion.get();
    }

    @Override
    public void onProviderFinished() {
        this.fire(new NextEditProviderFinished(this.getProviderId(), new NextEditPerformanceMetrics(this.performanceMetrics.getRequestWaitingTime().get(), this.performanceMetrics.getContextCollectionTime().get(), this.performanceMetrics.getClientExecutionTime().get(), this.performanceMetrics.getIterationFilterTime().get()), this.totalDiffs.get(), this.totalInsertLength.get(), this.totalDeleteLength.get(), this.totalInsertedLinesNumber.get(), this.totalDeletedLinesNumber.get(), this.filterReason.get()));
    }

    private static final DiagnosticEvent fire$lambda$0(NextEditProviderReporterImpl this$0, NextEditEventPayload $nextEditSessionMessage) {
        return (DiagnosticEvent)new NextEditEvent(this$0.project, this$0.requestId, $nextEditSessionMessage);
    }
}

