/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.diagnostics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.lang.Language;
import com.intellij.ml.diagnostics.DiagnosticEvent;
import com.intellij.ml.diagnostics.DiagnosticEventBus;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.ComputedDiff;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditActionContent;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditDiffAccepted;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditDiffContent;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditDiffRejected;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditDiffShown;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditEvent;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditEventPayload;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditJumpAccepted;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditJumpShown;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditPerformanceMetrics;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditProviderReporter;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditProviderSelected;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditSessionEventsReporter;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditSessionFinished;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditSessionInvalidState;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditStepsDescription;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditStepsRawDescription;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditTriggered;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.SelectedProviderData;
import com.intellij.ml.llm.nextEdits.backend.logs.NextEditLLMCollector;
import com.intellij.ml.llm.nextEdits.backend.logs.NextEditSessionTracker;
import com.intellij.ml.llm.nextEdits.backend.logs.NextEditTraceCollector;
import com.intellij.ml.llm.nextEdits.common.NextEditRating;
import com.intellij.ml.llm.nextEdits.common.NextEditSessionFinishType;
import com.intellij.ml.llm.nextEdits.common.NextEditStepViewType;
import com.intellij.ml.llm.nextEdits.common.NextEditTriggerReason;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditFrontendProviderId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 u2\u00020\u0001:\u0001uB)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010J\u001a\u00020G2\u0006\u0010K\u001a\u0002042\u0006\u00106\u001a\u000209H\u0016J\u001a\u0010L\u001a\u00020G2\u0006\u0010(\u001a\u00020\"2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\b\u0010O\u001a\u00020GH\u0016J\b\u0010P\u001a\u00020GH\u0016J7\u0010Q\u001a\u00020G2\u0006\u0010R\u001a\u0002092\u0006\u0010S\u001a\u0002012\u0006\u0010T\u001a\u0002092\u0006\u0010U\u001a\u0002092\b\u00102\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010VJ\u0018\u0010W\u001a\u00020G2\u0006\u0010R\u001a\u0002092\u0006\u0010S\u001a\u000201H\u0003J\u0010\u0010X\u001a\u00020G2\u0006\u0010Y\u001a\u00020ZH\u0016J4\u0010[\u001a\u00020G2\u0006\u0010\\\u001a\u0002092\u0006\u0010]\u001a\u0002092\u0006\u0010^\u001a\u00020\"2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0`H\u0016J\"\u0010a\u001a\u00020G2\u0006\u0010b\u001a\u00020c2\u0006\u0010Y\u001a\u00020Z2\b\u0010d\u001a\u0004\u0018\u00010eH\u0007J\"\u0010f\u001a\u00020G2\b\u0010d\u001a\u0004\u0018\u00010e2\u0006\u0010b\u001a\u00020c2\u0006\u0010g\u001a\u00020hH\u0002J\b\u0010i\u001a\u00020jH\u0002J\b\u0010k\u001a\u00020GH\u0002J\b\u0010l\u001a\u00020GH\u0002J\u001e\u0010m\u001a\u00020G2\u0006\u0010n\u001a\u00020j2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020\"0pH\u0002J\b\u0010q\u001a\u00020GH\u0016J\b\u0010r\u001a\u00020GH\u0016J\b\u0010s\u001a\u00020GH\u0016J\b\u0010t\u001a\u00020GH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00107\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u000209\u0018\u0001080\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001090\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020?0>8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bA\u0010BR\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020D0>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl;", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporter;", "project", "Lcom/intellij/openapi/project/Project;", "requestId", "", "language", "Lcom/intellij/lang/Language;", "clock", "Ljava/time/Clock;", "<init>", "(Lcom/intellij/openapi/project/Project;JLcom/intellij/lang/Language;Ljava/time/Clock;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRequestId", "()J", "created", "timeToShow", "Ljava/util/concurrent/atomic/AtomicReference;", "shownAt", "shownDuration", "suppressedDurationByInline", "suppressedDurationByLookup", "suppressedStartTimeByInline", "suppressedStartTimeByLookup", "shownDiffs", "Ljava/util/concurrent/atomic/AtomicInteger;", "insertedLength", "deletedLength", "insertedLinesNumber", "deletedLinesNumber", "stepsRawDescription", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditStepsRawDescription;", "taskId", "", "totalInsertLength", "totalDeleteLength", "totalInsertedLinesNumber", "totalDeletedLinesNumber", "totalDiffs", "providerId", "performanceMetrics", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditPerformanceMetrics;", "acceptedDiffs", "shownJumps", "acceptedJumps", "jumpShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "shownStepViewType", "Lcom/intellij/ml/llm/nextEdits/common/NextEditStepViewType;", "completionId", "triggerReason", "Lcom/intellij/ml/llm/nextEdits/common/NextEditTriggerReason;", "invalid", "caretOffset", "editableRegion", "Lkotlin/Pair;", "", "processedResponseSize", "rawModelOutput", "requestContextJson", "diffsContents", "", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditDiffContent;", "acceptedDiffsContents", "getAcceptedDiffsContents$annotations", "()V", "acceptedActionsContents", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditActionContent;", "finished", "fire", "", "nextEditSessionMessage", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditEventPayload;", "onTriggered", "trigger", "onProviderSelected", "providerReporter", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditProviderReporter;", "onJumpShown", "onJumpAccepted", "onStepShown", "stepIndex", "viewType", "startOffset", "endOffset", "(ILcom/intellij/ml/llm/nextEdits/common/NextEditStepViewType;IILjava/lang/Long;)V", "recordStepViewType", "onDiffAccepted", "rating", "Lcom/intellij/ml/llm/nextEdits/common/NextEditRating;", "onActionAccepted", "startLine", "endLine", "actionId", "actionLogParams", "", "onSessionFinishedIfNotFinished", "finishType", "Lcom/intellij/ml/llm/nextEdits/common/NextEditSessionFinishType;", "editorId", "Lcom/intellij/openapi/editor/impl/EditorId;", "tryStartTracking", "trackerEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "isVisible", "", "tryStartShowTime", "tryIncrementShowDuration", "checkValidity", "condition", "lazyMessage", "Lkotlin/Function0;", "onSuppressedByInline", "onSuppressedByLookup", "onUnsuppressedByInline", "onUnsuppressedByLookup", "Companion", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditSessionEventsReporterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSessionEventsReporterImpl.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,564:1\n42#2,3:565\n*S KotlinDebug\n*F\n+ 1 NextEditSessionEventsReporterImpl.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl\n*L\n325#1:565,3\n*E\n"})
public final class NextEditSessionEventsReporterImpl
implements NextEditSessionEventsReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final long requestId;
    @NotNull
    private final Language language;
    @NotNull
    private final Clock clock;
    private final long created;
    @NotNull
    private final AtomicReference<Long> timeToShow;
    @NotNull
    private final AtomicReference<Long> shownAt;
    @NotNull
    private final AtomicReference<Long> shownDuration;
    @NotNull
    private final AtomicReference<Long> suppressedDurationByInline;
    @NotNull
    private final AtomicReference<Long> suppressedDurationByLookup;
    @NotNull
    private final AtomicReference<Long> suppressedStartTimeByInline;
    @NotNull
    private final AtomicReference<Long> suppressedStartTimeByLookup;
    @NotNull
    private final AtomicInteger shownDiffs;
    @NotNull
    private final AtomicInteger insertedLength;
    @NotNull
    private final AtomicInteger deletedLength;
    @NotNull
    private final AtomicInteger insertedLinesNumber;
    @NotNull
    private final AtomicInteger deletedLinesNumber;
    @NotNull
    private final NextEditStepsRawDescription stepsRawDescription;
    @NotNull
    private final AtomicReference<String> taskId;
    @NotNull
    private final AtomicInteger totalInsertLength;
    @NotNull
    private final AtomicInteger totalDeleteLength;
    @NotNull
    private final AtomicInteger totalInsertedLinesNumber;
    @NotNull
    private final AtomicInteger totalDeletedLinesNumber;
    @NotNull
    private final AtomicInteger totalDiffs;
    @NotNull
    private final AtomicReference<String> providerId;
    @NotNull
    private final AtomicReference<NextEditPerformanceMetrics> performanceMetrics;
    @NotNull
    private final AtomicInteger acceptedDiffs;
    @NotNull
    private final AtomicInteger shownJumps;
    @NotNull
    private final AtomicInteger acceptedJumps;
    @NotNull
    private final AtomicBoolean jumpShown;
    @NotNull
    private AtomicReference<NextEditStepViewType> shownStepViewType;
    @NotNull
    private final AtomicReference<Long> completionId;
    @NotNull
    private final AtomicReference<NextEditTriggerReason> triggerReason;
    @NotNull
    private final AtomicBoolean invalid;
    @NotNull
    private final AtomicInteger caretOffset;
    @NotNull
    private final AtomicReference<Pair<Integer, Integer>> editableRegion;
    @NotNull
    private final AtomicReference<Integer> processedResponseSize;
    @NotNull
    private final AtomicReference<String> rawModelOutput;
    @NotNull
    private final AtomicReference<String> requestContextJson;
    @NotNull
    private final List<NextEditDiffContent> diffsContents;
    @NotNull
    private final List<NextEditDiffContent> acceptedDiffsContents;
    @NotNull
    private final List<NextEditActionContent> acceptedActionsContents;
    @NotNull
    private final AtomicBoolean finished;

    private NextEditSessionEventsReporterImpl(Project project2, long requestId, Language language, Clock clock) {
        this.project = project2;
        this.requestId = requestId;
        this.language = language;
        this.clock = clock;
        this.created = this.clock.millis();
        this.timeToShow = new AtomicReference<Object>(null);
        this.shownAt = new AtomicReference<Object>(null);
        this.shownDuration = new AtomicReference<Long>(0L);
        this.suppressedDurationByInline = new AtomicReference<Long>(0L);
        this.suppressedDurationByLookup = new AtomicReference<Long>(0L);
        this.suppressedStartTimeByInline = new AtomicReference<Object>(null);
        this.suppressedStartTimeByLookup = new AtomicReference<Object>(null);
        this.shownDiffs = new AtomicInteger(0);
        this.insertedLength = new AtomicInteger(0);
        this.deletedLength = new AtomicInteger(0);
        this.insertedLinesNumber = new AtomicInteger(0);
        this.deletedLinesNumber = new AtomicInteger(0);
        this.stepsRawDescription = new NextEditStepsRawDescription(null, 1, null);
        this.taskId = new AtomicReference<Object>(null);
        this.totalInsertLength = new AtomicInteger(0);
        this.totalDeleteLength = new AtomicInteger(0);
        this.totalInsertedLinesNumber = new AtomicInteger(0);
        this.totalDeletedLinesNumber = new AtomicInteger(0);
        this.totalDiffs = new AtomicInteger(0);
        this.providerId = new AtomicReference<Object>(null);
        this.performanceMetrics = new AtomicReference<Object>(null);
        this.acceptedDiffs = new AtomicInteger(0);
        this.shownJumps = new AtomicInteger(0);
        this.acceptedJumps = new AtomicInteger(0);
        this.jumpShown = new AtomicBoolean(false);
        this.shownStepViewType = new AtomicReference<Object>(null);
        this.completionId = new AtomicReference<Object>(null);
        this.triggerReason = new AtomicReference<NextEditTriggerReason>(NextEditTriggerReason.UNKNOWN);
        this.invalid = new AtomicBoolean(false);
        this.caretOffset = new AtomicInteger();
        this.editableRegion = new AtomicReference<Object>(null);
        this.processedResponseSize = new AtomicReference<Object>(null);
        this.rawModelOutput = new AtomicReference<Object>(null);
        this.requestContextJson = new AtomicReference<Object>(null);
        this.diffsContents = new ArrayList();
        this.acceptedDiffsContents = new ArrayList();
        this.acceptedActionsContents = new ArrayList();
        this.finished = new AtomicBoolean(false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final long getRequestId() {
        return this.requestId;
    }

    @Deprecated(message="use diffsContents instead ")
    private static /* synthetic */ void getAcceptedDiffsContents$annotations() {
    }

    private final void fire(NextEditEventPayload nextEditSessionMessage) {
        DiagnosticEventBus.Companion.getInstance().fire(() -> NextEditSessionEventsReporterImpl.fire$lambda$0(this, nextEditSessionMessage));
    }

    @Override
    public void onTriggered(@NotNull NextEditTriggerReason trigger, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)((Object)trigger), (String)"trigger");
        this.triggerReason.set(trigger);
        this.fire(new NextEditTriggered(trigger, caretOffset));
        this.caretOffset.set(caretOffset);
    }

    @Override
    public void onProviderSelected(@NotNull String providerId, @Nullable NextEditProviderReporter providerReporter) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        if (this.providerId.get() == null) {
            this.providerId.set(providerId);
            this.checkValidity(providerReporter != null, (Function0<String>)((Function0)() -> NextEditSessionEventsReporterImpl.onProviderSelected$lambda$0(providerId)));
            NextEditProviderReporter nextEditProviderReporter = providerReporter;
            if (nextEditProviderReporter != null) {
                NextEditProviderReporter it = nextEditProviderReporter;
                boolean bl = false;
                ComputedDiff computedDiff = providerReporter.getComputedDiff();
                this.taskId.set(providerReporter.getTaskId());
                this.totalDiffs.set(computedDiff.getDiffsCount());
                this.totalInsertLength.set(computedDiff.getTotalInsertLength());
                this.totalDeleteLength.set(computedDiff.getTotalDeleteLength());
                this.totalInsertedLinesNumber.set(computedDiff.getTotalInsertedLinesNumber());
                this.totalDeletedLinesNumber.set(computedDiff.getTotalDeletedLinesNumber());
                this.editableRegion.set(providerReporter.getEditableRegion());
                this.processedResponseSize.set(providerReporter.getProcessedResponseSize());
                this.performanceMetrics.set(new NextEditPerformanceMetrics(providerReporter.getRequestWaitingTime(), providerReporter.getContextCollectionTime(), providerReporter.getClientExecutionTime(), providerReporter.getIterationFilterTime()));
                this.rawModelOutput.set(providerReporter.getClientResponse());
                this.requestContextJson.set(providerReporter.getContextComposed());
                this.diffsContents.addAll((Collection<NextEditDiffContent>)computedDiff.getDiffContents());
            }
            this.fire(new NextEditProviderSelected(providerId));
        } else if (!Intrinsics.areEqual((Object)providerId, (Object)NextEditFrontendProviderId.BACKEND_CALL.getId())) {
            boolean bl = false;
            String string = "onProviderSelected can only be called second time from the " + NextEditFrontendProviderId.BACKEND_CALL.getId() + ". Actual: " + providerId;
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public void onJumpShown() {
        if (this.timeToShow.get() == null) {
            this.timeToShow.set(this.clock.millis() - this.created);
        }
        this.tryStartShowTime();
        if (!this.jumpShown.get()) {
            this.shownJumps.incrementAndGet();
            this.fire(NextEditJumpShown.INSTANCE);
            this.jumpShown.set(true);
        }
    }

    @Override
    public void onJumpAccepted() {
        this.checkValidity(this.jumpShown.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onJumpAccepted$lambda$0));
        this.tryIncrementShowDuration();
        this.acceptedJumps.incrementAndGet();
        this.fire(NextEditJumpAccepted.INSTANCE);
        this.jumpShown.set(false);
    }

    @Override
    public void onStepShown(int stepIndex, @NotNull NextEditStepViewType viewType, int startOffset, int endOffset, @Nullable Long completionId) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewType), (String)"viewType");
        this.recordStepViewType(stepIndex, viewType);
        if (this.timeToShow.get() == null) {
            this.timeToShow.set(this.clock.millis() - this.created);
        }
        this.tryStartShowTime();
        if (this.shownStepViewType.get() == null) {
            this.shownDiffs.incrementAndGet();
            this.checkValidity(this.shownDiffs.get() <= this.totalDiffs.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onStepShown$lambda$0));
            this.fire(new NextEditDiffShown(startOffset, endOffset));
            this.shownStepViewType.set(viewType);
            this.completionId.set(completionId);
        }
    }

    @Deprecated(message="will be moved to a separate event")
    private final void recordStepViewType(int stepIndex, NextEditStepViewType viewType) {
        List<NextEditStepViewType> stepsType = this.stepsRawDescription.getShownStepsViewType();
        while (stepsType.size() <= stepIndex) {
            stepsType.add(NextEditStepViewType.UNKNOWN);
        }
        stepsType.set(stepIndex, viewType);
    }

    @Override
    public void onDiffAccepted(@NotNull NextEditRating rating) {
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        int currentDiffIndex = this.acceptedDiffs.get();
        this.acceptedDiffs.incrementAndGet();
        this.checkValidity(this.acceptedDiffs.get() <= this.totalDiffs.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onDiffAccepted$lambda$0));
        NextEditStepViewType viewType = this.shownStepViewType.getAndSet(null);
        this.checkValidity(viewType != null, (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onDiffAccepted$lambda$1));
        this.checkValidity(!((Collection)this.diffsContents).isEmpty(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onDiffAccepted$lambda$2));
        this.checkValidity(currentDiffIndex < this.diffsContents.size(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onDiffAccepted$lambda$3));
        this.tryIncrementShowDuration();
        this.jumpShown.set(false);
        if (viewType == null || currentDiffIndex >= this.diffsContents.size()) {
            return;
        }
        NextEditDiffContent diffDetails = this.diffsContents.get(currentDiffIndex);
        this.fire(new NextEditDiffAccepted(viewType, this.completionId.getAndSet(null), diffDetails, rating));
        this.insertedLength.addAndGet(diffDetails.getInsertedLength());
        this.deletedLength.addAndGet(diffDetails.getDeletedLength());
        this.insertedLinesNumber.addAndGet(diffDetails.getInsertedLinesNumber());
        this.deletedLinesNumber.addAndGet(diffDetails.getDeletedLinesNumber());
    }

    @Override
    public void onActionAccepted(int startLine, int endLine, @NotNull String actionId, @NotNull Map<String, String> actionLogParams) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter(actionLogParams, (String)"actionLogParams");
        this.acceptedDiffs.incrementAndGet();
        this.checkValidity(this.acceptedDiffs.get() <= this.totalDiffs.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onActionAccepted$lambda$0));
        this.checkValidity(this.shownStepViewType.getAndSet(null) != null, (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onActionAccepted$lambda$1));
        this.tryIncrementShowDuration();
        NextEditActionContent acceptedAction = new NextEditActionContent(actionId, actionLogParams, startLine, endLine);
        this.acceptedActionsContents.add(acceptedAction);
        this.fire(acceptedAction);
        this.jumpShown.set(false);
    }

    @RequiresEdt
    public final void onSessionFinishedIfNotFinished(@NotNull NextEditSessionFinishType finishType, @NotNull NextEditRating rating, @Nullable EditorId editorId) {
        Intrinsics.checkNotNullParameter((Object)((Object)finishType), (String)"finishType");
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        if (this.finished.getAndSet(true)) {
            return;
        }
        this.tryIncrementShowDuration();
        NextEditStepViewType viewType = this.shownStepViewType.get();
        if (finishType != NextEditSessionFinishType.ACCEPTED && viewType != null) {
            this.checkValidity(this.totalDiffs.get() > this.acceptedDiffs.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onSessionFinishedIfNotFinished$lambda$0));
            int rejectedDiffIndex = this.acceptedDiffs.get();
            NextEditDiffContent rejectedDiff = this.diffsContents.get(rejectedDiffIndex);
            this.fire(new NextEditDiffRejected(finishType, viewType, this.completionId.getAndSet(null), rejectedDiff, rating));
        }
        Language language = this.language;
        NextEditTriggerReason nextEditTriggerReason = this.triggerReason.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)nextEditTriggerReason), (String)"get(...)");
        NextEditTriggerReason nextEditTriggerReason2 = nextEditTriggerReason;
        String string = this.providerId.get();
        int n = this.acceptedDiffs.get();
        int n2 = this.shownDiffs.get();
        int n3 = this.totalDiffs.get();
        int n4 = this.acceptedJumps.get();
        int n5 = this.shownJumps.get();
        Long l = this.timeToShow.get();
        Long l2 = this.shownDuration.get();
        Long l3 = this.suppressedDurationByInline.get();
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"get(...)");
        long l4 = ((Number)l3).longValue();
        Long l5 = this.suppressedDurationByLookup.get();
        Intrinsics.checkNotNullExpressionValue((Object)l5, (String)"get(...)");
        long l6 = ((Number)l5).longValue();
        NextEditStepsDescription nextEditStepsDescription = new NextEditStepsDescription(this.stepsRawDescription.getShownStepsViewType());
        boolean bl = this.invalid.get();
        int n6 = this.insertedLength.get();
        int n7 = this.deletedLength.get();
        int n8 = this.totalInsertLength.get();
        int n9 = this.totalDeleteLength.get();
        int n10 = this.totalInsertedLinesNumber.get();
        int n11 = this.totalDeletedLinesNumber.get();
        String string2 = this.taskId.get();
        String string3 = this.requestContextJson.get();
        String string4 = this.rawModelOutput.get();
        NextEditPerformanceMetrics nextEditPerformanceMetrics = this.performanceMetrics.get();
        NextEditPerformanceMetrics nextEditPerformanceMetrics2 = this.performanceMetrics.get();
        NextEditPerformanceMetrics nextEditPerformanceMetrics3 = this.performanceMetrics.get();
        NextEditPerformanceMetrics nextEditPerformanceMetrics4 = this.performanceMetrics.get();
        NextEditPerformanceMetrics nextEditPerformanceMetrics5 = new NextEditPerformanceMetrics(nextEditPerformanceMetrics != null ? nextEditPerformanceMetrics.getRequestWaitingTime() : null, nextEditPerformanceMetrics2 != null ? nextEditPerformanceMetrics2.getContextCollectionTime() : null, nextEditPerformanceMetrics3 != null ? nextEditPerformanceMetrics3.getClientExecutionTime() : null, nextEditPerformanceMetrics4 != null ? nextEditPerformanceMetrics4.getIterationFilterTime() : null);
        SelectedProviderData selectedProviderData = new SelectedProviderData(string2, n8, n9, n10, n11, nextEditPerformanceMetrics5, string3, string4);
        List<NextEditDiffContent> list = this.acceptedDiffsContents;
        List<NextEditActionContent> list2 = this.acceptedActionsContents;
        n10 = this.insertedLinesNumber.get();
        n11 = this.deletedLinesNumber.get();
        long l7 = this.clock.millis() - this.created;
        int n12 = this.caretOffset.get();
        this.fire(new NextEditSessionFinished(language, nextEditTriggerReason2, string, finishType, n, n2, n3, n4, n5, l, l2, l4, l6, nextEditStepsDescription, bl, n6, n7, n10, n11, l7, selectedProviderData, list2, list, n12));
        if (NextEditTraceCollector.INSTANCE.shouldTrackEditableRegion(this.requestId, finishType)) {
            this.tryStartTracking(editorId, finishType, NextEditTraceCollector.INSTANCE.getSESSION_STATE$intellij_ml_llm_nextEdits_backend());
        }
        if (NextEditLLMCollector.INSTANCE.shouldTrackEditableRegion(this.requestId, finishType)) {
            this.tryStartTracking(editorId, finishType, NextEditLLMCollector.INSTANCE.getSESSION_STATE$intellij_ml_llm_nextEdits_backend());
        }
    }

    private final void tryStartTracking(EditorId editorId, NextEditSessionFinishType finishType, VarargEventId trackerEvent) {
        block2: {
            Editor editor2;
            Pair<Integer, Integer> pair = this.editableRegion.get();
            if (pair == null) break block2;
            Pair<Integer, Integer> pair2 = pair;
            boolean bl = false;
            int start2 = ((Number)pair2.component1()).intValue();
            int end = ((Number)pair2.component2()).intValue();
            Integer n = this.processedResponseSize.get();
            int processedResponseSize = n != null ? n : 0;
            int editedRegionEnd = processedResponseSize > end - start2 ? start2 + processedResponseSize : end;
            EditorId editorId2 = editorId;
            Object object = editor2 = editorId2 != null ? EditorIdKt.findEditorOrNull((EditorId)editorId2) : null;
            if (editor2 != null) {
                TextRange textRange = new TextRange(Math.min(start2, editor2.getDocument().getTextLength()), Math.min(editedRegionEnd, editor2.getDocument().getTextLength()));
                RangeMarker rangeMarker = editor2.getDocument().createRangeMarker(textRange);
                Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
                RangeMarker rangeMarker2 = rangeMarker;
                boolean $i$f$service = false;
                Class<NextEditSessionTracker> serviceClass$iv = NextEditSessionTracker.class;
                Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object2 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((NextEditSessionTracker)object2).track(this.requestId, editor2, finishType, rangeMarker2, trackerEvent);
            }
        }
    }

    private final boolean isVisible() {
        return this.suppressedStartTimeByInline.get() == null && this.suppressedStartTimeByLookup.get() == null;
    }

    private final void tryStartShowTime() {
        if (!this.isVisible()) {
            return;
        }
        this.shownAt.set(this.clock.millis());
    }

    private final void tryIncrementShowDuration() {
        if (this.shownAt.get() != null && this.isVisible()) {
            Long l = this.shownAt.get();
            Intrinsics.checkNotNull((Object)l);
            long shown = ((Number)l).longValue();
            this.shownDuration.set(((Number)this.shownDuration.get()).longValue() + this.clock.millis() - shown);
            this.shownAt.set(null);
        }
    }

    private final void checkValidity(boolean condition, Function0<String> lazyMessage) {
        if (!condition) {
            this.fire(new NextEditSessionInvalidState((String)lazyMessage.invoke()));
            this.invalid.set(true);
        }
    }

    @Override
    public void onSuppressedByInline() {
        this.tryIncrementShowDuration();
        this.suppressedStartTimeByInline.set(this.clock.millis());
    }

    @Override
    public void onSuppressedByLookup() {
        this.tryIncrementShowDuration();
        this.suppressedStartTimeByLookup.set(this.clock.millis());
    }

    @Override
    public void onUnsuppressedByInline() {
        Long suppressionStartTime = this.suppressedStartTimeByInline.get();
        this.checkValidity(suppressionStartTime != null, (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onUnsuppressedByInline$lambda$0));
        Long l = suppressionStartTime;
        this.suppressedDurationByInline.set(((Number)this.suppressedDurationByInline.get()).longValue() + this.clock.millis() - (l != null ? l : 0L));
        this.suppressedStartTimeByInline.set(null);
        this.tryStartShowTime();
    }

    @Override
    public void onUnsuppressedByLookup() {
        Long suppressionStartTime = this.suppressedStartTimeByLookup.get();
        this.checkValidity(suppressionStartTime != null, (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onUnsuppressedByLookup$lambda$0));
        Long l = suppressionStartTime;
        this.suppressedDurationByLookup.set(((Number)this.suppressedDurationByLookup.get()).longValue() + this.clock.millis() - (l != null ? l : 0L));
        this.suppressedStartTimeByLookup.set(null);
        this.tryStartShowTime();
    }

    private static final DiagnosticEvent fire$lambda$0(NextEditSessionEventsReporterImpl this$0, NextEditEventPayload $nextEditSessionMessage) {
        return (DiagnosticEvent)new NextEditEvent(this$0.project, this$0.requestId, $nextEditSessionMessage);
    }

    private static final String onProviderSelected$lambda$0(String $providerId) {
        return "Provider(" + $providerId + ") reporter data is missing!";
    }

    private static final String onJumpAccepted$lambda$0() {
        return "Accepted jump was not shown";
    }

    private static final String onStepShown$lambda$0() {
        return "Shown more diffs than total";
    }

    private static final String onDiffAccepted$lambda$0() {
        return "Accepted more diffs than total";
    }

    private static final String onDiffAccepted$lambda$1() {
        return "Accepted diff was not shown";
    }

    private static final String onDiffAccepted$lambda$2() {
        return "No diff was set";
    }

    private static final String onDiffAccepted$lambda$3() {
        return "Accepted diff index out of diffsContents bounds";
    }

    private static final String onActionAccepted$lambda$0() {
        return "Accepted more diffs than total";
    }

    private static final String onActionAccepted$lambda$1() {
        return "Accepted diff was not shown";
    }

    private static final String onSessionFinishedIfNotFinished$lambda$0() {
        return "For a non accepted session, there should be some unaccepted diffs";
    }

    private static final String onUnsuppressedByInline$lambda$0() {
        return "Suppress by inline was not called before unsuppress";
    }

    private static final String onUnsuppressedByLookup$lambda$0() {
        return "Suppress by lookup was not called before unsuppress";
    }

    public /* synthetic */ NextEditSessionEventsReporterImpl(Project project2, long requestId, Language language, Clock clock, DefaultConstructorMarker $constructor_marker) {
        this(project2, requestId, language, clock);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "requestId", "", "clock", "Ljava/time/Clock;", "intellij.ml.llm.nextEdits.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditSessionEventsReporterImpl of(@NotNull Project project2, @NotNull Language language, long requestId) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC(...)");
            return new NextEditSessionEventsReporterImpl(project2, requestId, language, clock, null);
        }

        @TestOnly
        @NotNull
        public final NextEditSessionEventsReporterImpl of(@NotNull Project project2, @NotNull Language language, long requestId, @NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            return new NextEditSessionEventsReporterImpl(project2, requestId, language, clock, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

