/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.codeInsight;

import com.intellij.ml.llm.nextEdits.frontend.codeInsight.NextEditSuggestedRefactoringStateProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityListener;
import com.intellij.refactoring.suggested.SuggestedRefactoringState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R>\u0010\u0004\u001a2\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b \n*\u0017\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\t\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/codeInsight/NextEditSuggestedRefactoringAvailabilityListener;", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityListener;", "<init>", "()V", "editors", "", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "updated", "", "state", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "cleared", "disabled", "reset", "clearEditors", "reason", "Lcom/intellij/ml/llm/nextEdits/frontend/codeInsight/NextEditSuggestedRefactoringStateProcessor$StateUnsetReason;", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditSuggestedRefactoringAvailabilityListener
implements SuggestedRefactoringAvailabilityListener {
    @NotNull
    private final Set<Editor> editors;

    public NextEditSuggestedRefactoringAvailabilityListener() {
        Set set = ContainerUtil.createWeakSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createWeakSet(...)");
        this.editors = set;
    }

    public void updated(@NotNull SuggestedRefactoringState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        ThreadingAssertions.assertEventDispatchThread();
        PsiFile psiFile = state2.getAnchor().getContainingFile();
        Document document2 = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document2 == null) {
            return;
        }
        Document document3 = document2;
        Iterator iterator = EditorFactory.getInstance().editors(document3, psiFile.getProject()).iterator();
        while (iterator.hasNext()) {
            NextEditSuggestedRefactoringStateProcessor processor;
            Editor editor2 = (Editor)iterator.next();
            Intrinsics.checkNotNull((Object)editor2);
            if (NextEditSuggestedRefactoringStateProcessor.Companion.getOrNull(editor2) == null) continue;
            processor.setSuggestedRefactoringState(state2);
            this.editors.add(editor2);
        }
    }

    public void cleared() {
        ThreadingAssertions.assertEventDispatchThread();
        this.clearEditors(NextEditSuggestedRefactoringStateProcessor.StateUnsetReason.CLEARED);
    }

    public void disabled() {
        ThreadingAssertions.assertEventDispatchThread();
        this.clearEditors(NextEditSuggestedRefactoringStateProcessor.StateUnsetReason.DISABLED);
    }

    public void reset() {
        ThreadingAssertions.assertEventDispatchThread();
        Iterator<Editor> iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            NextEditSuggestedRefactoringStateProcessor processor;
            Editor editor2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (NextEditSuggestedRefactoringStateProcessor.Companion.getOrNull(editor2) == null) continue;
            processor.resetSuggestedRefactoringState();
        }
        this.editors.clear();
    }

    private final void clearEditors(NextEditSuggestedRefactoringStateProcessor.StateUnsetReason reason) {
        Iterator<Editor> iterator = this.editors.iterator();
        while (iterator.hasNext()) {
            NextEditSuggestedRefactoringStateProcessor processor;
            Editor editor2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (NextEditSuggestedRefactoringStateProcessor.Companion.getOrNull(editor2) == null) continue;
            processor.unsetSuggestedRefactoringState(reason);
        }
        this.editors.clear();
    }
}

