/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.completion.inline.sync;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.nextEdits.frontend.completion.inline.sync.InlineCompletionSessionState;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSession;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionManager;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.SuppressSessionGuardPurpose;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/completion/inline/sync/NextEditAndCompletionCoordinator;", "", "<init>", "()V", "inlineCompletionStarted", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "inlineCompletionShown", "inlineCompletionFinished", "nextEditShown", "install", "uninstall", "getNextEditSession", "Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSession;", "isInstalled", "", "Companion", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditAndCompletionCoordinator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<InlineCompletionSessionState> COMPLETION_STATE_KEY;

    @RequiresEdt
    public final void inlineCompletionStarted(@NotNull Editor editor2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            if (!this.isInstalled(editor2) || editor2.getUserData(COMPLETION_STATE_KEY) == InlineCompletionSessionState.COMPUTING) {
                return;
            }
            editor2.putUserData(COMPLETION_STATE_KEY, (Object)InlineCompletionSessionState.COMPUTING);
            NextEditSession nextEditSession = this.getNextEditSession(editor2);
            if (nextEditSession == null) break block1;
            nextEditSession.suppressIfNeeded(SuppressSessionGuardPurpose.INLINE_COMPLETION_COMPUTING);
        }
    }

    @RequiresEdt
    public final void inlineCompletionShown(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.isInstalled(editor2) || editor2.getUserData(COMPLETION_STATE_KEY) == InlineCompletionSessionState.SHOWING) {
            return;
        }
        editor2.putUserData(COMPLETION_STATE_KEY, (Object)InlineCompletionSessionState.SHOWING);
        NextEditSession nextEditSession = this.getNextEditSession(editor2);
        if (nextEditSession != null) {
            nextEditSession.suppressIfNeeded(SuppressSessionGuardPurpose.INLINE_COMPLETION_SHOWING);
            nextEditSession.unsuppress(SuppressSessionGuardPurpose.INLINE_COMPLETION_COMPUTING);
        }
    }

    @RequiresEdt
    public final void inlineCompletionFinished(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        ThreadingAssertions.assertEventDispatchThread();
        InlineCompletionSessionState currentState = (InlineCompletionSessionState)((Object)editor2.getUserData(COMPLETION_STATE_KEY));
        if (!this.isInstalled(editor2)) {
            return;
        }
        editor2.putUserData(COMPLETION_STATE_KEY, (Object)InlineCompletionSessionState.INACTIVE);
        NextEditSession nextEditSession = this.getNextEditSession(editor2);
        if (nextEditSession != null) {
            ApplicationKt.getApplication().invokeLater(() -> NextEditAndCompletionCoordinator.inlineCompletionFinished$lambda$0(editor2, this, nextEditSession, currentState));
        }
    }

    @RequiresEdt
    public final void nextEditShown(@NotNull Editor editor2) {
        InlineCompletionSessionState currentState;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.isInstalled(editor2)) {
            return;
        }
        InlineCompletionSessionState inlineCompletionSessionState = currentState = (InlineCompletionSessionState)((Object)editor2.getUserData(COMPLETION_STATE_KEY));
        switch (inlineCompletionSessionState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[inlineCompletionSessionState.ordinal()]) {
            case -1: 
            case 1: {
                break;
            }
            case 2: {
                NextEditSession nextEditSession = this.getNextEditSession(editor2);
                if (nextEditSession != null) {
                    nextEditSession.suppressIfNeeded(SuppressSessionGuardPurpose.INLINE_COMPLETION_COMPUTING);
                }
                break;
            }
            case 3: {
                NextEditSession nextEditSession = this.getNextEditSession(editor2);
                if (nextEditSession != null) {
                    nextEditSession.suppressIfNeeded(SuppressSessionGuardPurpose.INLINE_COMPLETION_SHOWING);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @RequiresEdt
    public final void install(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        ThreadingAssertions.assertEventDispatchThread();
        editor2.putUserData(COMPLETION_STATE_KEY, (Object)InlineCompletionSessionState.INACTIVE);
    }

    @RequiresEdt
    public final void uninstall(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        ThreadingAssertions.assertEventDispatchThread();
        editor2.putUserData(COMPLETION_STATE_KEY, null);
    }

    private final NextEditSession getNextEditSession(Editor editor2) {
        NextEditSessionManager nextEditSessionManager = NextEditSessionManager.Companion.getInstance(editor2);
        return nextEditSessionManager != null ? nextEditSessionManager.getSession() : null;
    }

    private final boolean isInstalled(Editor editor2) {
        return editor2.getUserData(COMPLETION_STATE_KEY) != null;
    }

    private static final void inlineCompletionFinished$lambda$0(Editor $editor, NextEditAndCompletionCoordinator this$0, NextEditSession $nextEditSession, InlineCompletionSessionState $currentState) {
        if ($editor.isDisposed()) {
            return;
        }
        if (this$0.getNextEditSession($editor) != $nextEditSession) {
            return;
        }
        InlineCompletionSessionState inlineCompletionSessionState = $currentState;
        switch (inlineCompletionSessionState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[inlineCompletionSessionState.ordinal()]) {
            case -1: 
            case 1: {
                break;
            }
            case 2: {
                $nextEditSession.unsuppress(SuppressSessionGuardPurpose.INLINE_COMPLETION_COMPUTING);
                break;
            }
            case 3: {
                $nextEditSession.unsuppress(SuppressSessionGuardPurpose.INLINE_COMPLETION_SHOWING);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static {
        Key key = Key.create((String)"next.edit.inline.completion.state");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COMPLETION_STATE_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/completion/inline/sync/NextEditAndCompletionCoordinator$Companion;", "", "<init>", "()V", "COMPLETION_STATE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/nextEdits/frontend/completion/inline/sync/InlineCompletionSessionState;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/ml/llm/nextEdits/frontend/completion/inline/sync/NextEditAndCompletionCoordinator;", "intellij.ml.llm.nextEdits.frontend"})
    @SourceDebugExtension(value={"SMAP\nNextEditAndCompletionCoordinator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditAndCompletionCoordinator.kt\ncom/intellij/ml/llm/nextEdits/frontend/completion/inline/sync/NextEditAndCompletionCoordinator$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,114:1\n42#2,3:115\n*S KotlinDebug\n*F\n+ 1 NextEditAndCompletionCoordinator.kt\ncom/intellij/ml/llm/nextEdits/frontend/completion/inline/sync/NextEditAndCompletionCoordinator$Companion\n*L\n111#1:115,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditAndCompletionCoordinator getInstance() {
            boolean $i$f$service = false;
            Class<NextEditAndCompletionCoordinator> serviceClass$iv = NextEditAndCompletionCoordinator.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (NextEditAndCompletionCoordinator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InlineCompletionSessionState.values().length];
            try {
                nArray[InlineCompletionSessionState.INACTIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineCompletionSessionState.COMPUTING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InlineCompletionSessionState.SHOWING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

