/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.listeners;

import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSession;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionManager;
import com.intellij.ml.llm.nextEdits.frontend.ui.refresh.NextEditViewRefreshReason;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingListener;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/listeners/NextEditRefreshOnFoldingChangesListener;", "Lcom/intellij/openapi/editor/ex/FoldingListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "foldingChanged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "onFoldProcessingStart", "", "onFoldRegionStateChange", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "onFoldProcessingEnd", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditRefreshOnFoldingChangesListener
implements FoldingListener {
    @NotNull
    private final Editor editor;
    @NotNull
    private final AtomicBoolean foldingChanged;

    public NextEditRefreshOnFoldingChangesListener(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.foldingChanged = new AtomicBoolean(false);
    }

    public void onFoldProcessingStart() {
        this.foldingChanged.set(false);
    }

    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.foldingChanged.set(true);
    }

    public void onFoldProcessingEnd() {
        Object object;
        if (this.foldingChanged.get() && (object = NextEditSessionManager.Companion.getInstance(this.editor)) != null && (object = ((NextEditSessionManager)object).getSession()) != null) {
            ((NextEditSession)object).refreshIfNeeded(NextEditViewRefreshReason.FoldingChanged.INSTANCE);
        }
        this.foldingChanged.set(false);
    }
}

