/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.listeners;

import com.intellij.ml.llm.nextEdits.common.NextEditTriggerReason;
import com.intellij.ml.llm.nextEdits.frontend.services.NextEditRequestService;
import com.intellij.ml.llm.nextEdits.frontend.settings.FrontendNextEditSettingsKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/listeners/TypingListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "<init>", "()V", "beforeEditorTyping", "", "c", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "afterEditorTyping", "Companion", "intellij.ml.llm.nextEdits.frontend"})
final class TypingListener
implements AnActionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Long> PREVIOUS_EDIT_TIME_KEY;

    public void beforeEditorTyping(char c, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        editor3.putUserData(PREVIOUS_EDIT_TIME_KEY, (Object)editor3.getDocument().getModificationStamp());
    }

    public void afterEditorTyping(char c, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Project project2 = editor3.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Long l = (Long)editor3.getUserData(PREVIOUS_EDIT_TIME_KEY);
        if (l == null) {
            return;
        }
        long prevEditTime = l;
        if (editor3.getDocument().getModificationStamp() == prevEditTime) {
            return;
        }
        if (!FrontendNextEditSettingsKt.isNextEditEnabled()) {
            return;
        }
        NextEditRequestService.Companion.getInstance(project3).newRequest(editor3, NextEditTriggerReason.TYPING);
    }

    static {
        Key key = Key.create((String)"next.edit.previous.edit.time");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PREVIOUS_EDIT_TIME_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/listeners/TypingListener$Companion;", "", "<init>", "()V", "PREVIOUS_EDIT_TIME_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

