/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.session.step.controller;

import com.intellij.ml.llm.nextEdits.frontend.feedback.NextEditSurveyStateComponent;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.SuppressSessionGuardPurpose;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditSimpleReplaceDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditDiffController;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditStepController;
import com.intellij.ml.llm.nextEdits.frontend.ui.refresh.NextEditViewRefreshReason;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditEditorUtil;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditSimpleReplaceDisplayer;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditStepDisplayer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditSimpleReplaceDiffController;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditDiffController$Base;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditSimpleReplaceDiffModel;", "diff", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditSimpleReplaceDiffModel;Lcom/intellij/openapi/fileTypes/FileType;)V", "getDisplayer", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditStepDisplayer;", "handleAfterAccept", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "makeVisible", "shouldRefreshOn", "", "reason", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshReason;", "getSuppressHandlerType", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditStepController$SuppressHandlerType;", "suppressPurpose", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/SuppressSessionGuardPurpose;", "onRepresentationUpdated", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditStepController$RepresentationUpdateHandler;", "startOffsetOfNextLineOrTextEnd", "", "offset", "intellij.ml.llm.nextEdits.frontend"})
@ApiStatus.Internal
public final class NextEditSimpleReplaceDiffController
extends NextEditDiffController.Base<NextEditSimpleReplaceDiffModel> {
    @NotNull
    private final FileType fileType;

    public NextEditSimpleReplaceDiffController(@NotNull NextEditSimpleReplaceDiffModel diff2, @NotNull FileType fileType2) {
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
        super((NextEditDiffModel)diff2);
        this.fileType = fileType2;
    }

    @Override
    @NotNull
    public NextEditStepDisplayer getDisplayer() {
        return new NextEditSimpleReplaceDisplayer((NextEditSimpleReplaceDiffModel)this.getDiff(), this.fileType);
    }

    @Override
    protected void handleAfterAccept(@NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        int offset = ((NextEditSimpleReplaceDiffModel)this.getDiff()).getModification().getStartOffset() + ((NextEditSimpleReplaceDiffModel)this.getDiff()).getModification().getNewContent().length();
        editor2.getCaretModel().moveToOffset(offset);
        NextEditEditorUtil.INSTANCE.makeVisible(editor2, offset);
        NextEditSurveyStateComponent.Companion.getInstance().fireSmallReplaceAccepted();
    }

    @Override
    public void makeVisible(@NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        NextEditSimpleReplaceDiffModel.Modification modification = ((NextEditSimpleReplaceDiffModel)this.getDiff()).getModification();
        int nextLineOffset = this.startOffsetOfNextLineOrTextEnd(editor2, modification.getEndOffset());
        TextRange visibleRange = new TextRange(modification.getStartOffset(), nextLineOffset);
        NextEditEditorUtil.INSTANCE.makeVisible(editor2, visibleRange);
    }

    @Override
    public boolean shouldRefreshOn(@NotNull Editor editor2, @NotNull Project project2, @NotNull NextEditViewRefreshReason reason) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        NextEditViewRefreshReason nextEditViewRefreshReason = reason;
        if (Intrinsics.areEqual((Object)nextEditViewRefreshReason, (Object)NextEditViewRefreshReason.BlockInlaysChanged.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)nextEditViewRefreshReason, (Object)NextEditViewRefreshReason.FontChanged.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)nextEditViewRefreshReason, (Object)NextEditViewRefreshReason.FoldingChanged.INSTANCE)) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    @NotNull
    public NextEditStepController.SuppressHandlerType getSuppressHandlerType(@NotNull Editor editor2, @NotNull Project project2, @NotNull SuppressSessionGuardPurpose suppressPurpose) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)suppressPurpose), (String)"suppressPurpose");
        return switch (WhenMappings.$EnumSwitchMapping$0[suppressPurpose.ordinal()]) {
            case 1 -> NextEditStepController.SuppressHandlerType.SUPPRESS;
            case 2 -> NextEditStepController.SuppressHandlerType.SUPPRESS;
            case 3 -> NextEditStepController.SuppressHandlerType.SUPPRESS;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public NextEditStepController.RepresentationUpdateHandler onRepresentationUpdated(@NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return NextEditStepController.RepresentationUpdateHandler.DO_NOTHING;
    }

    private final int startOffsetOfNextLineOrTextEnd(Editor editor2, int offset) {
        ThreadingAssertions.assertReadAccess();
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        if (offset >= document3.getTextLength()) {
            return document3.getTextLength();
        }
        int line = document3.getLineNumber(offset);
        if (line >= document3.getLineCount() - 1) {
            return Math.max(document3.getTextLength() - 1, 0);
        }
        return document3.getLineStartOffset(line + 1);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuppressSessionGuardPurpose.values().length];
            try {
                nArray[SuppressSessionGuardPurpose.INLINE_COMPLETION_COMPUTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuppressSessionGuardPurpose.INLINE_COMPLETION_SHOWING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuppressSessionGuardPurpose.LOOKUP_WINDOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

