/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JSeparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/ColoredSeparator;", "Ljavax/swing/JSeparator;", "color", "Ljava/awt/Color;", "thickness", "", "orientation", "<init>", "(Ljava/awt/Color;II)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "getPreferredSize", "Ljava/awt/Dimension;", "intellij.ml.llm.nextEdits.frontend"})
public final class ColoredSeparator
extends JSeparator {
    @Nullable
    private final Color color;
    private final int thickness;
    private final int orientation;

    public ColoredSeparator(@Nullable Color color, int thickness, int orientation) {
        super(orientation);
        this.color = color;
        this.thickness = thickness;
        this.orientation = orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.color == null) {
            return;
        }
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.color);
            if (this.orientation == 0) {
                g2d.fillRect(0, (this.getHeight() - this.thickness) / 2, this.getWidth(), this.thickness);
            } else {
                g2d.fillRect((this.getWidth() - this.thickness) / 2, 0, this.thickness, this.getHeight());
            }
        }
        finally {
            g2d.dispose();
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension basePreferredSize = super.getPreferredSize();
        return this.orientation == 0 ? new Dimension(basePreferredSize.width, this.thickness) : new Dimension(this.thickness, basePreferredSize.height);
    }
}

