/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.aiignore;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0007\u001a\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f*\u00020\u0005H\u0002\u001a\f\u0010\u0011\u001a\u00020\n*\u00020\u0012H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"AIIGNORE_FILENAME", "", "detectAiIgnore", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "competitorsFileNames", "", "allFileNames", "isPossiblePrivacyFile", "", "file", "detectPrivacyFiles", "", "guessAiIgnoreRootCandidates", "", "guessVcsRoot", "isProbablyAboutAiIgnore", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.ml.llm.privacy"})
@SourceDebugExtension(value={"SMAP\nAiIgnoreDetectionUtilsKt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiIgnoreDetectionUtilsKt.kt\ncom/intellij/ml/llm/privacy/aiignore/AiIgnoreDetectionUtilsKtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n1#2:70\n1617#3,9:60\n1869#3:69\n1870#3:71\n1626#3:72\n1563#3:73\n1634#3,3:74\n*S KotlinDebug\n*F\n+ 1 AiIgnoreDetectionUtilsKt.kt\ncom/intellij/ml/llm/privacy/aiignore/AiIgnoreDetectionUtilsKtKt\n*L\n32#1:70\n32#1:60,9\n32#1:69\n32#1:71\n32#1:72\n50#1:73\n50#1:74,3\n*E\n"})
public final class AiIgnoreDetectionUtilsKtKt {
    @NotNull
    public static final String AIIGNORE_FILENAME = ".aiignore";
    @NotNull
    private static final Set<String> competitorsFileNames;
    @NotNull
    private static final Set<String> allFileNames;

    @Nullable
    public static final VirtualFile detectAiIgnore(@NotNull Project project2) {
        VirtualFile virtualFile2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            for (VirtualFile it : (Iterable)AiIgnoreDetectionUtilsKtKt.guessAiIgnoreRootCandidates(project2)) {
                boolean bl = false;
                VirtualFile virtualFile3 = it.findChild(AIIGNORE_FILENAME);
                if (virtualFile3 == null) continue;
                virtualFile2 = virtualFile3;
                break block1;
            }
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    @RequiresReadLock
    public static final boolean isPossiblePrivacyFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        return allFileNames.contains(file2.getName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, VirtualFile> detectPrivacyFiles(@NotNull Project project2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List<VirtualFile> rootCandidates = AiIgnoreDetectionUtilsKtKt.guessAiIgnoreRootCandidates(project2);
        Iterable $this$mapNotNull$iv = competitorsFileNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            VirtualFile file2;
            String name;
            block2: {
                VirtualFile virtualFile2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                name = (String)element$iv$iv;
                boolean bl2 = false;
                for (VirtualFile it : (Iterable)rootCandidates) {
                    boolean bl3 = false;
                    VirtualFile virtualFile3 = it.findChild(name);
                    if (virtualFile3 == null) continue;
                    virtualFile2 = virtualFile3;
                    break block2;
                }
                virtualFile2 = file2 = null;
            }
            if ((file2 != null ? TuplesKt.to((Object)name, file2) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final List<VirtualFile> guessAiIgnoreRootCandidates(@NotNull Project project2) {
        List candidates;
        block0: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            candidates = CollectionsKt.toMutableList((Collection)AiIgnoreDetectionUtilsKtKt.guessVcsRoot(project2));
            VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project2);
            if (virtualFile2 == null) break block0;
            VirtualFile it = virtualFile2;
            boolean bl = false;
            candidates.add(it);
        }
        return CollectionsKt.distinct((Iterable)CollectionsKt.toList((Iterable)candidates));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> guessVcsRoot(Project $this$guessVcsRoot) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ArraysKt.toList((Object[])ProjectLevelVcsManager.Companion.getInstance($this$guessVcsRoot).getAllVcsRoots());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsRoot vcsRoot = (VcsRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isProbablyAboutAiIgnore(@NotNull VFileEvent $this$isProbablyAboutAiIgnore) {
        Intrinsics.checkNotNullParameter((Object)$this$isProbablyAboutAiIgnore, (String)"<this>");
        if ($this$isProbablyAboutAiIgnore instanceof VFileCreateEvent) {
            if (allFileNames.contains(((VFileCreateEvent)$this$isProbablyAboutAiIgnore).getChildName())) return true;
        }
        if ($this$isProbablyAboutAiIgnore instanceof VFileCopyEvent) {
            if (allFileNames.contains(((VFileCopyEvent)$this$isProbablyAboutAiIgnore).getNewChildName())) return true;
        }
        if ($this$isProbablyAboutAiIgnore instanceof VFilePropertyChangeEvent && Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)$this$isProbablyAboutAiIgnore).getPropertyName(), (Object)"name")) {
            Object object = ((VFilePropertyChangeEvent)$this$isProbablyAboutAiIgnore).getNewValue();
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            if (allFileNames.contains(object)) return true;
            Object object2 = ((VFilePropertyChangeEvent)$this$isProbablyAboutAiIgnore).getOldValue();
            if (object2 == null || (object2 = object2.toString()) == null) {
                object2 = "";
            }
            if (allFileNames.contains(object2)) return true;
        }
        if (!($this$isProbablyAboutAiIgnore instanceof VFileDeleteEvent)) return false;
        if (!allFileNames.contains(((VFileDeleteEvent)$this$isProbablyAboutAiIgnore).getFile().getName())) return false;
        return true;
    }

    static {
        Object[] objectArray = new String[]{".cursorignore", ".codeiumignore", ".aiexclude"};
        competitorsFileNames = SetsKt.setOf((Object[])objectArray);
        allFileNames = SetsKt.plus(competitorsFileNames, (Object)AIIGNORE_FILENAME);
    }
}

