/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.daemon;

import com.intellij.ml.llm.editor.common.progress.AICaretAttributeKeys;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptHighlightingUtil;
import com.intellij.ml.llm.rider.daemon.RiderInlinePromptEditorFilter;
import com.intellij.ml.llm.rider.daemon.RiderInlinePromptMarkupModelListenerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorHighlightingPredicate;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/rider/daemon/InlinePromptMarkupModelListener;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "Lcom/intellij/openapi/Disposable$Default;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "isPromptShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "afterRemoved", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterAdded", "addPredicate", "removePredicate", "intellij.ml.llm.rider"})
@SourceDebugExtension(value={"SMAP\nRiderInlinePromptMarkupModelListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderInlinePromptMarkupModelListener.kt\ncom/intellij/ml/llm/rider/daemon/InlinePromptMarkupModelListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n57#2:95\n35#2,2:96\n13#2:98\n57#2:99\n35#2,2:100\n13#2:102\n*S KotlinDebug\n*F\n+ 1 RiderInlinePromptMarkupModelListener.kt\ncom/intellij/ml/llm/rider/daemon/InlinePromptMarkupModelListener\n*L\n64#1:95\n64#1:96,2\n70#1:98\n81#1:99\n81#1:100,2\n83#1:102\n*E\n"})
final class InlinePromptMarkupModelListener
implements MarkupModelListener,
Disposable.Default {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final AtomicBoolean isPromptShown;

    public InlinePromptMarkupModelListener(@NotNull EditorImpl editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.isPromptShown = new AtomicBoolean();
    }

    public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (Intrinsics.areEqual((Object)highlighter.getTextAttributesKey(), (Object)AICaretAttributeKeys.INLINE_PROMPT_ATTRS)) {
            this.removePredicate();
            InlinePromptHighlightingUtil.INSTANCE.onInlinePromptNotFound((Editor)this.editor);
        }
    }

    public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (Intrinsics.areEqual((Object)highlighter.getTextAttributesKey(), (Object)AICaretAttributeKeys.INLINE_PROMPT_ATTRS)) {
            ApplicationKt.getApplication().invokeLater(() -> InlinePromptMarkupModelListener.afterAdded$lambda$0(this, highlighter));
        }
    }

    private final void addPredicate(RangeHighlighterEx highlighter) {
        if (this.isPromptShown.compareAndSet(false, true)) {
            ApplicationKt.getApplication().invokeLater(() -> InlinePromptMarkupModelListener.addPredicate$lambda$0(this, highlighter));
        }
    }

    private final void removePredicate() {
        if (this.isPromptShown.compareAndSet(true, false)) {
            ApplicationKt.getApplication().invokeLater(() -> InlinePromptMarkupModelListener.removePredicate$lambda$0(this));
        }
    }

    private static final void afterAdded$lambda$0(InlinePromptMarkupModelListener this$0, RangeHighlighterEx $highlighter) {
        this$0.addPredicate($highlighter);
    }

    private static final void addPredicate$lambda$0(InlinePromptMarkupModelListener this$0, RangeHighlighterEx $highlighter) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)this$0.editor.getDocument()), (Project)this$0.editor.getProject(), (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markup = (MarkupModelEx)markupModel;
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("InlinePromptEditorFilter is added to editor=" + this$0.editor);
        RiderInlinePromptEditorFilter filter2 = new RiderInlinePromptEditorFilter($highlighter);
        Disposer.register((Disposable)((Disposable)this$0), (Disposable)((Disposable)filter2));
        RiderInlinePromptEditorFilter prevFilter = (RiderInlinePromptEditorFilter)this$0.editor.addHighlightingPredicate(RiderInlinePromptMarkupModelListenerKt.access$getEDITOR_FILTER_KEY$p(), (EditorHighlightingPredicate)filter2);
        if (prevFilter != null) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(InlinePromptMarkupModelListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Inline prompt filter was already set for editor=" + this$0.editor);
            Disposer.dispose((Disposable)((Disposable)prevFilter));
        }
        markup.addMarkupModelListener((Disposable)filter2, (MarkupModelListener)filter2);
    }

    private static final void removePredicate$lambda$0(InlinePromptMarkupModelListener this$0) {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("InlinePromptEditorFilter is removed from editor=" + this$0.editor);
        RiderInlinePromptEditorFilter riderInlinePromptEditorFilter = (RiderInlinePromptEditorFilter)this$0.editor.removeHighlightingPredicate(RiderInlinePromptMarkupModelListenerKt.access$getEDITOR_FILTER_KEY$p());
        if (riderInlinePromptEditorFilter == null) {
            InlinePromptMarkupModelListener $this$removePredicate_u24lambda_u240_u240 = this$0;
            boolean bl = false;
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(InlinePromptMarkupModelListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Inline prompt filter was not set for editor=" + $this$removePredicate_u24lambda_u240_u240.editor);
            return;
        }
        RiderInlinePromptEditorFilter filter2 = riderInlinePromptEditorFilter;
        Disposer.dispose((Disposable)((Disposable)filter2));
    }
}

