/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.statistics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.ml.llm.riderNext.latest.chronicles.ai.RecapAgentResult;
import com.intellij.ml.llm.riderNext.latest.chronicles.ai.RecapLLMLog;
import com.intellij.ml.llm.riderNext.latest.chronicles.statistics.RecapActivityStatsPayload;
import com.intellij.ml.llm.riderNext.latest.chronicles.statistics.RecapRating;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleKind;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.RecapTimeInterval;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0016J\u0016\u0010,\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u0010-\u001a\u00020'J\u001e\u0010.\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001cR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/statistics/RecapFusLogger;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "CORRELATION_ID", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "UPDATED_INTENTIONALLY", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "INPUT_CHRONICLES_30M", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "INPUT_CHRONICLES_2H", "RESULT_ACTIVITIES_30M", "RESULT_ACTIVITIES_2H", "HAS_2H_INTERVAL", "TIME_INTERVAL", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapTimeInterval;", "ACTIVITY_INDEX", "RATE", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/statistics/RecapRating;", "CHRONICLES_IN_ACTIVITY", "VISIBLE_CHRONICLES_IN_ACTIVITY", "EXPANDED", "CHRONICLE_INDEX", "CHRONICLE_KIND", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleKind;", "UPDATE_EXEC", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "RATED_EXEC", "TOGGLE_EXPAND", "CHRONICLE_CLICK", "onRecapUpdated", "", "result", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ai/RecapAgentResult;", "forceRecalculation", "", "onRecapRated", "stats", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/statistics/RecapActivityStatsPayload;", "rating", "onExpandToggled", "expanded", "onChronicleClicked", "chronicleIndex", "", "chronicleKind", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecapFusLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapFusLogger.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/statistics/RecapFusLogger\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,116:1\n261#2,3:117\n261#2,3:120\n261#2,3:123\n*S KotlinDebug\n*F\n+ 1 RecapFusLogger.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/statistics/RecapFusLogger\n*L\n26#1:117,3\n28#1:120,3\n33#1:123,3\n*E\n"})
public final class RecapFusLogger
extends CounterUsagesCollector {
    @NotNull
    public static final RecapFusLogger INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final LongEventField CORRELATION_ID;
    @NotNull
    private static final BooleanEventField UPDATED_INTENTIONALLY;
    @NotNull
    private static final IntEventField INPUT_CHRONICLES_30M;
    @NotNull
    private static final IntEventField INPUT_CHRONICLES_2H;
    @NotNull
    private static final IntEventField RESULT_ACTIVITIES_30M;
    @NotNull
    private static final IntEventField RESULT_ACTIVITIES_2H;
    @NotNull
    private static final BooleanEventField HAS_2H_INTERVAL;
    @NotNull
    private static final EnumEventField<RecapTimeInterval> TIME_INTERVAL;
    @NotNull
    private static final IntEventField ACTIVITY_INDEX;
    @NotNull
    private static final EnumEventField<RecapRating> RATE;
    @NotNull
    private static final IntEventField CHRONICLES_IN_ACTIVITY;
    @NotNull
    private static final IntEventField VISIBLE_CHRONICLES_IN_ACTIVITY;
    @NotNull
    private static final BooleanEventField EXPANDED;
    @NotNull
    private static final IntEventField CHRONICLE_INDEX;
    @NotNull
    private static final EnumEventField<ChronicleKind> CHRONICLE_KIND;
    @NotNull
    private static final VarargEventId UPDATE_EXEC;
    @NotNull
    private static final VarargEventId RATED_EXEC;
    @NotNull
    private static final VarargEventId TOGGLE_EXPAND;
    @NotNull
    private static final VarargEventId CHRONICLE_CLICK;
    public static final int $stable;

    private RecapFusLogger() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void onRecapUpdated(@NotNull RecapAgentResult result2, boolean forceRecalculation) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        RecapLLMLog log2 = result2.getLog();
        EventPair[] eventPairArray = new EventPair[]{CORRELATION_ID.with((Object)log2.getCorrelationId().getId()), UPDATED_INTENTIONALLY.with((Object)forceRecalculation), INPUT_CHRONICLES_30M.with((Object)log2.getTrack30Min().getChroniclesCount()), INPUT_CHRONICLES_2H.with((Object)log2.getTrack2H().getChroniclesCount()), HAS_2H_INTERVAL.with((Object)(log2.getTrack2H().getResponseCount() > 0 ? 1 : 0)), RESULT_ACTIVITIES_30M.with((Object)log2.getTrack30Min().getResponseCount()), RESULT_ACTIVITIES_2H.with((Object)log2.getTrack2H().getResponseCount())};
        UPDATE_EXEC.log(eventPairArray);
    }

    public final void onRecapRated(@NotNull RecapActivityStatsPayload stats, @NotNull RecapRating rating) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)((Object)rating), (String)"rating");
        EventPair[] eventPairArray = new EventPair[]{CORRELATION_ID.with((Object)stats.getCorrelationId().getId()), ACTIVITY_INDEX.with((Object)stats.getIndex()), TIME_INTERVAL.with((Object)stats.getTimeInterval()), CHRONICLES_IN_ACTIVITY.with((Object)stats.getChroniclesCount()), VISIBLE_CHRONICLES_IN_ACTIVITY.with((Object)stats.getUniqueChroniclesCount()), RATE.with((Object)rating)};
        RATED_EXEC.log(eventPairArray);
    }

    public final void onExpandToggled(@NotNull RecapActivityStatsPayload stats, boolean expanded) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        EventPair[] eventPairArray = new EventPair[]{CORRELATION_ID.with((Object)stats.getCorrelationId().getId()), ACTIVITY_INDEX.with((Object)stats.getIndex()), TIME_INTERVAL.with((Object)stats.getTimeInterval()), CHRONICLES_IN_ACTIVITY.with((Object)stats.getChroniclesCount()), VISIBLE_CHRONICLES_IN_ACTIVITY.with((Object)stats.getUniqueChroniclesCount()), EXPANDED.with((Object)expanded)};
        TOGGLE_EXPAND.log(eventPairArray);
    }

    public final void onChronicleClicked(@NotNull RecapActivityStatsPayload stats, int chronicleIndex, @NotNull ChronicleKind chronicleKind) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)((Object)chronicleKind), (String)"chronicleKind");
        EventPair[] eventPairArray = new EventPair[]{CORRELATION_ID.with((Object)stats.getCorrelationId().getId()), ACTIVITY_INDEX.with((Object)stats.getIndex()), TIME_INTERVAL.with((Object)stats.getTimeInterval()), CHRONICLES_IN_ACTIVITY.with((Object)stats.getChroniclesCount()), VISIBLE_CHRONICLES_IN_ACTIVITY.with((Object)stats.getUniqueChroniclesCount()), CHRONICLE_INDEX.with((Object)chronicleIndex), CHRONICLE_KIND.with((Object)chronicleKind)};
        CHRONICLE_CLICK.log(eventPairArray);
    }

    static {
        EventFields $this$iv;
        INSTANCE = new RecapFusLogger();
        GROUP = new EventLogGroup("recap.usage", 4, "FUS", "Recap usage statistics", null, 16, null);
        CORRELATION_ID = EventFields.Long$default((String)"correlation_id", null, (int)2, null);
        UPDATED_INTENTIONALLY = EventFields.Boolean((String)"updated_intentionally");
        INPUT_CHRONICLES_30M = EventFields.Int((String)"input_chronicles_30m");
        INPUT_CHRONICLES_2H = EventFields.Int((String)"input_chronicles_2h");
        RESULT_ACTIVITIES_30M = EventFields.Int((String)"result_activities_30m");
        RESULT_ACTIVITIES_2H = EventFields.Int((String)"result_activities_2h");
        HAS_2H_INTERVAL = EventFields.Boolean((String)"has_2h_interval");
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String name$iv = "time_interval";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        TIME_INTERVAL = new EnumEventField(name$iv, RecapTimeInterval.class, null, transform$iv);
        ACTIVITY_INDEX = EventFields.Int((String)"activity_index");
        $this$iv = EventFields.INSTANCE;
        name$iv = "liked_disliked";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        RATE = new EnumEventField(name$iv, RecapRating.class, null, transform$iv);
        CHRONICLES_IN_ACTIVITY = EventFields.Int((String)"chronicles_in_activity");
        VISIBLE_CHRONICLES_IN_ACTIVITY = EventFields.Int((String)"visible_chronicles_in_activity");
        EXPANDED = EventFields.Boolean((String)"expanded");
        CHRONICLE_INDEX = EventFields.Int((String)"chronicle_index");
        $this$iv = EventFields.INSTANCE;
        name$iv = "chronicle_kind";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        CHRONICLE_KIND = new EnumEventField(name$iv, ChronicleKind.class, null, transform$iv);
        eventFieldArray = new EventField[]{CORRELATION_ID, UPDATED_INTENTIONALLY, INPUT_CHRONICLES_30M, INPUT_CHRONICLES_2H, HAS_2H_INTERVAL, RESULT_ACTIVITIES_30M, RESULT_ACTIVITIES_2H};
        UPDATE_EXEC = GROUP.registerVarargEvent("recap.usage.update.executed", "Recap update executed", eventFieldArray);
        eventFieldArray = new EventField[]{CORRELATION_ID, ACTIVITY_INDEX, TIME_INTERVAL, CHRONICLES_IN_ACTIVITY, VISIBLE_CHRONICLES_IN_ACTIVITY, RATE};
        RATED_EXEC = GROUP.registerVarargEvent("recap.usage.rated", "Recap activity was liked/disliked", eventFieldArray);
        eventFieldArray = new EventField[]{CORRELATION_ID, ACTIVITY_INDEX, TIME_INTERVAL, CHRONICLES_IN_ACTIVITY, VISIBLE_CHRONICLES_IN_ACTIVITY, EXPANDED};
        TOGGLE_EXPAND = GROUP.registerVarargEvent("recap.usage.toggle.expand", "User expanded/collapsed recap activity", eventFieldArray);
        eventFieldArray = new EventField[]{CORRELATION_ID, ACTIVITY_INDEX, TIME_INTERVAL, CHRONICLES_IN_ACTIVITY, VISIBLE_CHRONICLES_IN_ACTIVITY, CHRONICLE_INDEX, CHRONICLE_KIND};
        CHRONICLE_CLICK = GROUP.registerVarargEvent("recap.usage.chronicle.click", "User clicked on chronicle", eventFieldArray);
        $stable = 8;
    }
}

