/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.latest.LLMRiderNextBundle;
import com.intellij.ml.llm.riderNext.latest.chronicles.ChronicleEntry;
import com.intellij.ml.llm.riderNext.latest.chronicles.ChroniclePath;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleDetails;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleKind;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleNavigate;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleNavigateKt;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChroniclePresenter$;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChroniclePresenterWithDetails;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 .2\u00020\u0001:\u0002./B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eBS\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\r\u0010\u0012J\b\u0010 \u001a\u0004\u0018\u00010!J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0005H\u0016J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016\u00a8\u00060\u0080\u00e5\b\u0002\u0080\u00e5\b\u0004\u0080\u00e5\b\u0006\u0080\u00e5\b\u0007\u0080\u00e5\b\t\u0080\u00e5\b\u000b"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChroniclePresenter;", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleDetails;", "id", "", "title", "", "append", "kind", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleKind;", "timestamp", "", "entry", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;", "<init>", "(ILjava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleKind;JLcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IILjava/lang/String;Ljava/lang/String;Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleKind;JLcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getId", "()I", "getTitle", "()Ljava/lang/String;", "getAppend", "getKind", "()Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleKind;", "getTimestamp", "()J", "getEntry", "()Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;", "caption", "getCaption", "getNavigate", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChronicleNavigate;", "getDetails", "Ljava/awt/Component;", "project", "Lcom/intellij/openapi/project/Project;", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Companion", "$serializer", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public class ChroniclePresenter
implements ChronicleDetails {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    @NotNull
    private final String title;
    @NotNull
    private final String append;
    @NotNull
    private final ChronicleKind kind;
    private final long timestamp;
    @Nullable
    private final ChronicleEntry entry;
    public static final int $stable = 8;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public ChroniclePresenter(int id, @Nls @NotNull String title, @NotNull String append, @NotNull ChronicleKind kind, long timestamp, @Nullable ChronicleEntry entry) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)append, (String)"append");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.id = id;
        this.title = title;
        this.append = append;
        this.kind = kind;
        this.timestamp = timestamp;
        this.entry = entry;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getAppend() {
        return this.append;
    }

    @NotNull
    public final ChronicleKind getKind() {
        return this.kind;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public final ChronicleEntry getEntry() {
        return this.entry;
    }

    @NotNull
    public final String getCaption() {
        return this.title + " " + this.append;
    }

    @Nullable
    public final ChronicleNavigate getNavigate() {
        ChronicleEntry chronicleEntry = this.entry;
        return chronicleEntry != null ? ChronicleNavigateKt.createNavigate(chronicleEntry) : null;
    }

    @Override
    @Nullable
    public Component getDetails(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder(JBUI.Borders.empty((int)5));
        JPanel detailsPanel = new JPanel(new BorderLayout());
        detailsPanel.setAlignmentX(0.0f);
        detailsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        JButton navigateButton = new JButton("Navigate");
        navigateButton.addActionListener(arg_0 -> ChroniclePresenter.getDetails$lambda$0(this, project2, arg_0));
        detailsPanel.add((Component)navigateButton, "South");
        panel2.add(detailsPanel);
        return panel2;
    }

    @NotNull
    public String toString() {
        return "Chronicle(chronicle_id='" + this.id + "', caption='" + this.getCaption() + "', timestamp=" + Companion.formatChronicleDateTime(this.timestamp) + ")";
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self(ChroniclePresenter self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeIntElement(serialDesc, 0, self.id);
        output.encodeStringElement(serialDesc, 1, self.title);
        output.encodeStringElement(serialDesc, 2, self.append);
        output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)lazyArray[3].getValue(), (Object)self.kind);
        output.encodeLongElement(serialDesc, 4, self.timestamp);
        output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), (Object)self.entry);
    }

    public /* synthetic */ ChroniclePresenter(int seen0, int id, String title, String append, ChronicleKind kind, long timestamp, ChronicleEntry entry, SerializationConstructorMarker serializationConstructorMarker) {
        if (63 != (0x3F & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)63, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.id = id;
        this.title = title;
        this.append = append;
        this.kind = kind;
        this.timestamp = timestamp;
        this.entry = entry;
    }

    private static final void getDetails$lambda$0(ChroniclePresenter this$0, Project $project, ActionEvent it) {
        ChronicleNavigate navigate2 = this$0.getNavigate();
        if (navigate2 != null) {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(navigate2, $project, null){
                int label;
                final /* synthetic */ ChronicleNavigate $navigate;
                final /* synthetic */ Project $project;
                {
                    this.$navigate = $navigate;
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$navigate.navigate(this.$project, (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> ChronicleKind.Companion.serializer()), null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> ChronicleEntry.Companion.serializer())};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChroniclePresenter$Companion;", "", "<init>", "()V", "formatChronicleDateTime", "", "timestamp", "", "fromEvent", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/ChroniclePresenter;", "id", "", "entry", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.ml.llm.riderNext.latest"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatChronicleDateTime(long timestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd-MM-yyyy");
            String string = dateFormat.format(new Date(timestamp));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @NotNull
        public final ChroniclePresenter fromEvent(int id, @NotNull ChronicleEntry entry) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Object append = "";
            ChronicleEntry chronicleEntry = entry;
            if (chronicleEntry instanceof ChronicleEntry.Idle) {
                pair = TuplesKt.to((Object)LLMRiderNextBundle.message("long.idle", new Object[0]), (Object)((Object)ChronicleKind.Idle));
            } else if (chronicleEntry instanceof ChronicleEntry.Shutdown) {
                pair = TuplesKt.to((Object)LLMRiderNextBundle.message("shut.down", new Object[0]), (Object)((Object)ChronicleKind.Shutdown));
            } else if (chronicleEntry instanceof ChronicleEntry.Startup) {
                pair = TuplesKt.to((Object)LLMRiderNextBundle.message("startup", new Object[0]), (Object)((Object)ChronicleKind.Startup));
            } else if (chronicleEntry instanceof ChronicleEntry.Run) {
                Object[] objectArray = new Object[]{((ChronicleEntry.Run)entry).getConfigName()};
                pair = TuplesKt.to((Object)LLMRiderNextBundle.message("run.0", objectArray), (Object)((Object)ChronicleKind.Run));
            } else {
                if (chronicleEntry instanceof ChronicleEntry.Tests) {
                    return new ChroniclePresenterWithDetails(id, ((ChronicleEntry.Tests)entry).getDetails(), ((ChronicleEntry.Tests)entry).getOverview(), "", ChronicleKind.Tests, ((ChronicleEntry.Tests)entry).getTimestamp(), entry);
                }
                if (chronicleEntry instanceof ChronicleEntry.FileSwitch) {
                    append = ((ChronicleEntry.FileSwitch)entry).getPosition();
                    fileName = ((ChronicleEntry.FileSwitch)entry).getPath().getRelativePath().getFileName();
                    var7_8 = new Object[1];
                    Intrinsics.checkNotNull((Object)fileName);
                    var7_8[0] = fileName;
                    pair = TuplesKt.to((Object)LLMRiderNextBundle.message("switched.to.file.0", var7_8), (Object)((Object)ChronicleKind.FileSwitch));
                } else if (chronicleEntry instanceof ChronicleEntry.FindUsages) {
                    Object object = ((ChronicleEntry.FindUsages)entry).getPath();
                    fileName = object != null && (object = ((ChroniclePath)object).getRelativePath()) != null && (object = object.getFileName()) != null ? (Comparable)object : (Comparable)((Object)LLMRiderNextBundle.message("unknown", new Object[0]));
                    var7_8 = new Object[]{((ChronicleEntry.FindUsages)entry).getToken(), fileName};
                    pair = TuplesKt.to((Object)LLMRiderNextBundle.message("find.usages.0.in.1", var7_8), (Object)((Object)ChronicleKind.FindUsages));
                } else if (chronicleEntry instanceof ChronicleEntry.FindInFile) {
                    fileName = new Object[]{((ChronicleEntry.FindInFile)entry).getSearchPattern()};
                    pair = TuplesKt.to((Object)LLMRiderNextBundle.message("search.pattern.0", fileName), (Object)((Object)ChronicleKind.FindInFile));
                } else if (chronicleEntry instanceof ChronicleEntry.FindInPath) {
                    fileName = new Object[]{((ChronicleEntry.FindInPath)entry).getSearchPattern()};
                    pair = TuplesKt.to((Object)LLMRiderNextBundle.message("search.pattern.01", fileName), (Object)((Object)ChronicleKind.FindInPath));
                } else if (chronicleEntry instanceof ChronicleEntry.GotoDeclaration) {
                    Object object = ((ChronicleEntry.GotoDeclaration)entry).getPath();
                    fileName = object != null && (object = ((ChroniclePath)object).getRelativePath()) != null && (object = object.getFileName()) != null ? (Comparable)object : (Comparable)((Object)LLMRiderNextBundle.message("unknown", new Object[0]));
                    var7_8 = new Object[]{((ChronicleEntry.GotoDeclaration)entry).getToken(), fileName};
                    pair = TuplesKt.to((Object)LLMRiderNextBundle.message("goto.declaration.or.usages.0.1", var7_8), (Object)((Object)ChronicleKind.GotoDeclaration));
                } else {
                    if (chronicleEntry instanceof ChronicleEntry.DocumentChange) {
                        String append2 = "during " + ((ChronicleEntry.DocumentChange)entry).getDurationMs() + "ms";
                        Path fileName = ((ChronicleEntry.DocumentChange)entry).getPath().getRelativePath().getFileName();
                        Object[] objectArray = new Object[1];
                        Intrinsics.checkNotNull((Object)fileName);
                        objectArray[0] = fileName;
                        String title = LLMRiderNextBundle.message("document.change.0", objectArray);
                        return new ChroniclePresenterWithDetails(id, ((ChronicleEntry.DocumentChange)entry).getDiff(), title, append2, ChronicleKind.CodeChanges, ((ChronicleEntry.DocumentChange)entry).getTimestamp(), entry);
                    }
                    if (chronicleEntry instanceof ChronicleEntry.BreakpointSet) {
                        append2 = new Object[]{((ChronicleEntry.BreakpointSet)entry).getDisplayText()};
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("breakpoint.set.0", append2), (Object)((Object)ChronicleKind.BreakpointSet));
                    } else if (chronicleEntry instanceof ChronicleEntry.BreakpointRemoved) {
                        append2 = new Object[]{((ChronicleEntry.BreakpointRemoved)entry).getDisplayText()};
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("breakpoint.removed.0", append2), (Object)((Object)ChronicleKind.BreakpointRemoved));
                    } else if (chronicleEntry instanceof ChronicleEntry.BreakpointHit) {
                        append2 = new Object[]{((ChronicleEntry.BreakpointHit)entry).getMessage()};
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("stopped.on.breakpoint.0", append2), (Object)((Object)ChronicleKind.BreakpointHit));
                    } else if (chronicleEntry instanceof ChronicleEntry.DebugStart) {
                        append2 = new Object[]{((ChronicleEntry.DebugStart)entry).getConfigName()};
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("debug.started.0", append2), (Object)((Object)ChronicleKind.DebugStart));
                    } else if (chronicleEntry instanceof ChronicleEntry.DebugStop) {
                        append2 = new Object[]{((ChronicleEntry.DebugStop)entry).getConfigName()};
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("debug.stopped.0", append2), (Object)((Object)ChronicleKind.DebugStop));
                    } else if (chronicleEntry instanceof ChronicleEntry.BuildStart) {
                        append2 = new Object[]{((ChronicleEntry.BuildStart)entry).getRunConfiguration()};
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("build.started.0", append2), (Object)((Object)ChronicleKind.BuildStart));
                    } else if (chronicleEntry instanceof ChronicleEntry.BuildSuccess) {
                        append2 = new Object[]{((ChronicleEntry.BuildSuccess)entry).getRunConfiguration()};
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("build.success.0", append2), (Object)((Object)ChronicleKind.BuildSuccess));
                    } else if (chronicleEntry instanceof ChronicleEntry.BuildFailed) {
                        append = ((ChronicleEntry.BuildFailed)entry).getReason();
                        append2 = new Object[]{((ChronicleEntry.BuildFailed)entry).getRunConfiguration()};
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("build.failed.0", append2), (Object)((Object)ChronicleKind.BuildFailed));
                    } else if (chronicleEntry instanceof ChronicleEntry.Scroll) {
                        append = "(" + ((ChronicleEntry.Scroll)entry).getDurationMs() + "ms)";
                        fileName = ((ChronicleEntry.Scroll)entry).getPath().getRelativePath().getFileName();
                        var7_8 = new Object[1];
                        Intrinsics.checkNotNull((Object)fileName);
                        var7_8[0] = fileName;
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("read.file.0", var7_8), (Object)((Object)ChronicleKind.Scroll));
                    } else if (chronicleEntry instanceof ChronicleEntry.ChangeBranches) {
                        fileName = new Object[]{((ChronicleEntry.ChangeBranches)entry).getBranchName()};
                        pair = TuplesKt.to((Object)LLMRiderNextBundle.message("checkout.branch.0", fileName), (Object)((Object)ChronicleKind.ChangeBranches));
                    } else {
                        if (chronicleEntry instanceof ChronicleEntry.NewFile) {
                            Object[] objectArray = new Object[2];
                            String string = ((ChronicleEntry.NewFile)entry).getCommand();
                            if (string == null) {
                                string = "";
                            }
                            objectArray[0] = string;
                            Intrinsics.checkNotNullExpressionValue((Object)((ChronicleEntry.NewFile)entry).getPath().getRelativePath().getFileName(), (String)"getFileName(...)");
                            String title = LLMRiderNextBundle.message("new.file.0.1", objectArray);
                            return new ChroniclePresenterWithDetails(id, ((ChronicleEntry.NewFile)entry).getContent(), title, "", ChronicleKind.NewFile, ((ChronicleEntry.NewFile)entry).getTimestamp(), entry);
                        }
                        if (chronicleEntry instanceof ChronicleEntry.DeleteFile) {
                            Object[] title = new Object[2];
                            String string = ((ChronicleEntry.DeleteFile)entry).getCommand();
                            if (string == null) {
                                string = "";
                            }
                            title[0] = string;
                            Intrinsics.checkNotNullExpressionValue((Object)((ChronicleEntry.DeleteFile)entry).getPath().getRelativePath().getFileName(), (String)"getFileName(...)");
                            pair = TuplesKt.to((Object)LLMRiderNextBundle.message("deleted.file.0.1", title), (Object)((Object)ChronicleKind.DeleteFile));
                        } else if (chronicleEntry instanceof ChronicleEntry.MoveFile) {
                            fileName = ((ChronicleEntry.MoveFile)entry).getFromPath().getRelativePath().getFileName();
                            var7_8 = new Object[1];
                            Intrinsics.checkNotNull((Object)fileName);
                            var7_8[0] = fileName;
                            pair = TuplesKt.to((Object)LLMRiderNextBundle.message("moved.file.0.1", var7_8), (Object)((Object)ChronicleKind.MoveFile));
                        } else if (chronicleEntry instanceof ChronicleEntry.CopyFile) {
                            fileName = ((ChronicleEntry.CopyFile)entry).getFromPath().getRelativePath().getFileName();
                            var7_8 = new Object[1];
                            Intrinsics.checkNotNull((Object)fileName);
                            var7_8[0] = fileName;
                            pair = TuplesKt.to((Object)LLMRiderNextBundle.message("copied.file.0.1", var7_8), (Object)((Object)ChronicleKind.CopyFile));
                        } else {
                            if (chronicleEntry instanceof ChronicleEntry.AiCodeGeneration) {
                                return new ChroniclePresenterWithDetails(id, ((ChronicleEntry.AiCodeGeneration)entry).getDiff(), ((ChronicleEntry.AiCodeGeneration)entry).getSummary(), "", ChronicleKind.AiCodeGeneration, ((ChronicleEntry.AiCodeGeneration)entry).getTimestamp(), entry);
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
            }
            Pair pair2 = pair;
            String title = (String)pair2.component1();
            ChronicleKind kind = (ChronicleKind)((Object)pair2.component2());
            return new ChroniclePresenter(id, title, (String)append, kind, entry.getTimestamp(), entry);
        }

        @NotNull
        public final KSerializer<ChroniclePresenter> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

