/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.ui.progresses.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ml.llm.riderNext.latest.frozen.ui.progresses.data.ProgressService;
import com.intellij.ml.llm.riderNext.latest.frozen.ui.progresses.data.ProgressesData;
import com.intellij.ml.llm.riderNext.latest.frozen.ui.progresses.ui.BaseProgressPane;
import com.intellij.ml.llm.riderNext.latest.progresses.ui.list.XNextProgressList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.html.UtilsKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/ui/progresses/ui/XNextStatusBarProgressPopup;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Lcom/intellij/openapi/ui/popup/JBPopup;", "balloon", "setBalloon", "(Lcom/intellij/openapi/ui/popup/JBPopup;)V", "opened", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "getOpened", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "createPopup", "builder", "Lcom/intellij/openapi/ui/popup/ComponentPopupBuilder;", "rootPane", "Ljavax/swing/JRootPane;", "estimatedPanelHeight", "", "hidePopup", "", "onClick", "showPopup", "updateContentUI", "jbScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "cancelPopup", "Companion", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nXNextStatusBarProgressPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XNextStatusBarProgressPopup.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/ui/progresses/ui/XNextStatusBarProgressPopup\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,153:1\n30#2,2:154\n*S KotlinDebug\n*F\n+ 1 XNextStatusBarProgressPopup.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/ui/progresses/ui/XNextStatusBarProgressPopup\n*L\n126#1:154,2\n*E\n"})
public final class XNextStatusBarProgressPopup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private JBPopup balloon;
    @NotNull
    private final MutableStateFlow<Boolean> opened;
    public static final int $stable = 8;
    private static final int PREFERRED_WIDTH = 300;
    private static final int MAX_COUNT = 4;

    public XNextStatusBarProgressPopup(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.opened = StateFlowKt.MutableStateFlow((Object)false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void setBalloon(JBPopup value) {
        if (Intrinsics.areEqual((Object)this.balloon, (Object)value)) {
            return;
        }
        this.balloon = value;
        boolean res2 = value != null;
        this.opened.tryEmit((Object)res2);
    }

    @NotNull
    public final MutableStateFlow<Boolean> getOpened() {
        return this.opened;
    }

    private final JBPopup createPopup(ComponentPopupBuilder builder, JRootPane rootPane, int estimatedPanelHeight) {
        int n;
        int scaledWidth = JBUI.scale((int)300);
        Dimension size2 = new Dimension(scaledWidth, estimatedPanelHeight);
        builder.setMinSize(size2);
        JBPopup jBPopup = builder.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup myPopup = jBPopup;
        int titleHeight = myPopup instanceof AbstractPopup ? ((AbstractPopup)myPopup).getHeaderPreferredSize().height : 0;
        Dimension popupSize = new Dimension(size2.width, size2.height + titleHeight + JBUI.scale((int)5));
        myPopup.getContent().setPreferredSize(popupSize);
        InternalUICustomization internalUICustomization = InternalUICustomization.Companion.getInstance();
        boolean bl = internalUICustomization != null ? internalUICustomization.isSingleStripe() : false;
        if (bl) {
            n = JBUI.scale((int)30);
        } else {
            Window window = SwingUtilities.getWindowAncestor(rootPane);
            if (window != null) {
                StatusBarEx sb;
                Window frame = window;
                boolean bl2 = false;
                n = frame instanceof JFrame ? ((sb = (StatusBarEx)((IdeFrame)frame).getStatusBar()) != null && sb.isVisible() ? sb.getSize().height : 0) : 0;
            } else {
                n = 0;
            }
        }
        int statusBarHeight = n;
        RelativePoint relativePoint = new RelativePoint((Component)rootPane, new Point(rootPane.getX() + rootPane.getWidth() - popupSize.width - JBUI.scale((int)10), rootPane.getY() + rootPane.getHeight() - statusBarHeight - popupSize.height - JBUI.scale((int)10)));
        myPopup.show(relativePoint);
        this.setBalloon(myPopup);
        return myPopup;
    }

    public final void hidePopup() {
        this.cancelPopup();
    }

    public final void onClick(@NotNull JRootPane rootPane) {
        Intrinsics.checkNotNullParameter((Object)rootPane, (String)"rootPane");
        JBPopup jBPopup = this.balloon;
        if (jBPopup != null) {
            JBPopup it = jBPopup;
            boolean bl = false;
            it.cancel();
            this.setBalloon(null);
        } else {
            XNextStatusBarProgressPopup $this$onClick_u24lambda_u241 = this;
            boolean bl = false;
            $this$onClick_u24lambda_u241.showPopup(rootPane);
        }
    }

    private final void showPopup(JRootPane rootPane) {
        XNextProgressList content2 = XNextProgressList.Companion.createInPopupList(this.project);
        JComponent component2 = content2.component();
        JBScrollPane scrollPane = new JBScrollPane((Component)component2, 20, 31);
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, component2);
        Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder, (String)"createComponentPopupBuilder(...)");
        ComponentPopupBuilder builder = componentPopupBuilder;
        builder.setNormalWindowLevel(true);
        builder.setMovable(true);
        builder.setResizable(true);
        builder.setTitle(IdeBundle.message((String)"progress.window.title", (Object[])new Object[0]));
        builder.setCancelOnClickOutside(false);
        builder.setRequestFocus(true);
        builder.setBelongsToGlobalPopupStack(false);
        builder.setLocateWithinScreenBounds(false);
        builder.setCancelButton((IconButton)new MinimizeButton(IdeBundle.message((String)"tooltip.hide", (Object[])new Object[0])));
        builder.addListener(new JBPopupListener(this){
            final /* synthetic */ XNextStatusBarProgressPopup this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClosed(LightweightWindowEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                XNextStatusBarProgressPopup.access$setBalloon(this.this$0, null);
            }
        });
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProgressService> serviceClass$iv = ProgressService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProgressService service = (ProgressService)object;
        int count = Math.min(((ProgressesData)service.getProgressesDataFlow$intellij_ml_llm_riderNext_latest().getValue()).getAllProgresses().size(), 4);
        int height = count * ((BaseProgressPane)content2.getPaneCreator().invoke()).getEstimatedPanelHeight() + (count - 1) * JBUI.scale((int)10);
        Insets insets = component2.getInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        int estimatedPaneHeight = height + UtilsKt.getHeight((Insets)insets);
        JBPopup popup2 = this.createPopup(builder, rootPane, estimatedPaneHeight);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)popup2);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> XNextStatusBarProgressPopup.showPopup$lambda$0(this, scrollPane, arg_0));
        this.updateContentUI(scrollPane);
    }

    private final void updateContentUI(JBScrollPane jbScrollPane) {
        IJSwingUtilities.updateComponentTreeUI((Component)((Component)jbScrollPane));
        if (ExperimentalUI.Companion.isNewUI()) {
            jbScrollPane.getViewport().setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
        }
        jbScrollPane.setBorder(null);
    }

    private final void cancelPopup() {
        block0: {
            JBPopup jBPopup = this.balloon;
            if (jBPopup == null) break block0;
            JBPopup it = jBPopup;
            boolean bl = false;
            it.cancel();
            this.setBalloon(null);
        }
    }

    private static final void showPopup$lambda$0(XNextStatusBarProgressPopup this$0, JBScrollPane $scrollPane, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateContentUI($scrollPane);
    }

    public static final /* synthetic */ void access$setBalloon(XNextStatusBarProgressPopup $this, JBPopup value) {
        $this.setBalloon(value);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/ui/progresses/ui/XNextStatusBarProgressPopup$Companion;", "", "<init>", "()V", "PREFERRED_WIDTH", "", "MAX_COUNT", "getInstance", "Lcom/intellij/ml/llm/riderNext/latest/frozen/ui/progresses/ui/XNextStatusBarProgressPopup;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.riderNext.latest"})
    @SourceDebugExtension(value={"SMAP\nXNextStatusBarProgressPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XNextStatusBarProgressPopup.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/ui/progresses/ui/XNextStatusBarProgressPopup$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,153:1\n30#2,2:154\n*S KotlinDebug\n*F\n+ 1 XNextStatusBarProgressPopup.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/ui/progresses/ui/XNextStatusBarProgressPopup$Companion\n*L\n37#1:154,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XNextStatusBarProgressPopup getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<XNextStatusBarProgressPopup> serviceClass$iv = XNextStatusBarProgressPopup.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (XNextStatusBarProgressPopup)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

