/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.git.recap;

import com.intellij.ml.llm.riderNext.latest.frozen.recap.vcs.RecapCommitInformationProvider;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.vcs.RecapLatestCommits;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogProvider;
import git4idea.GitUtil;
import git4idea.history.GitLogUtil;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/recap/RecapGitCommitInformationProvider;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/vcs/RecapCommitInformationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "calculateCommitsInfo", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/vcs/RecapLatestCommits;", "intellij.ml.llm.riderNext.latest.git"})
public final class RecapGitCommitInformationProvider
extends RecapCommitInformationProvider {
    @NotNull
    private final Project project;

    public RecapGitCommitInformationProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    @Nullable
    public RecapLatestCommits calculateCommitsInfo() {
        for (GitRepository repo : GitUtil.getRepositoryManager((Project)this.project).getRepositories()) {
            VcsLogProvider.DetailedLogData gitLog;
            String[] stringArray = new String[]{"-2"};
            Intrinsics.checkNotNullExpressionValue((Object)GitLogUtil.collectMetadata((Project)this.project, (VirtualFile)repo.getRoot(), (String[])stringArray), (String)"collectMetadata(...)");
            if (gitLog.getCommits().isEmpty()) continue;
            VcsCommitMetadata latestCommit = null;
            VcsCommitMetadata beforeLatestCommit = null;
            for (VcsCommitMetadata commit : gitLog.getCommits()) {
                if (latestCommit == null) {
                    latestCommit = commit;
                    continue;
                }
                beforeLatestCommit = commit;
                break;
            }
            if (latestCommit == null) continue;
            return new RecapLatestCommits(latestCommit, beforeLatestCommit);
        }
        return null;
    }
}

