/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.git.selfReview.agent.rulesVerifier.tools;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.usages.impl.UsagePreviewPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"getRealTextRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "infoRange", "Lcom/intellij/openapi/util/ProperTextRange;", "getUsageCodeSnippet", "Lcom/intellij/ml/llm/privacy/PSString;", "usageRange", "numberOfContextLines", "", "intellij.ml.llm.riderNext.latest.git"})
public final class FindPatternToolKt {
    private static final TextRange getRealTextRange(PsiElement element2, ProperTextRange infoRange) {
        TextRange usageRange = UsagePreviewPanel.Companion.calculateHighlightingRangeForUsage(element2, infoRange);
        if (element2 instanceof PsiNamedElement && !(element2 instanceof PsiFile)) {
            usageRange = UsagePreviewPanel.Companion.getNameElementTextRange(element2);
        }
        TextRange textRange = InjectedLanguageManager.getInstance((Project)element2.getProject()).injectedToHost(element2, usageRange);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"injectedToHost(...)");
        usageRange = textRange;
        return usageRange;
    }

    private static final PSString getUsageCodeSnippet(PsiElement element2, TextRange usageRange, int numberOfContextLines) {
        PsiFile topLevelFile;
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)element2.getProject());
        Document doc = docManager.getDocument(topLevelFile = InjectedLanguageManager.getInstance((Project)element2.getProject()).getTopLevelFile(element2));
        if (doc == null) {
            return null;
        }
        int usageStartLineNumber = doc.getLineNumber(usageRange.getStartOffset());
        int usageEndLineNumber = doc.getLineNumber(usageRange.getStartOffset());
        int contextStartLineNumber = Math.max(0, usageStartLineNumber - numberOfContextLines);
        int startOffset = doc.getLineStartOffset(contextStartLineNumber);
        int endOffset = doc.getLineEndOffset(Math.min(usageEndLineNumber + numberOfContextLines, doc.getLineCount() - 1));
        Project project2 = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        PSString text2 = ExtensionsKtKt.privacySafe(doc, project2).getText(new TextRange(startOffset, endOffset));
        Language language = element2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return PSStringOperatorsKt.wrapCodeIntoMarkdownSnippet((PSString)ExtensionsKtKt.getPrivacySafe(language).getDisplayName(), (PSString)text2);
    }

    public static final /* synthetic */ TextRange access$getRealTextRange(PsiElement element2, ProperTextRange infoRange) {
        return FindPatternToolKt.getRealTextRange(element2, infoRange);
    }

    public static final /* synthetic */ PSString access$getUsageCodeSnippet(PsiElement element2, TextRange usageRange, int numberOfContextLines) {
        return FindPatternToolKt.getUsageCodeSnippet(element2, usageRange, numberOfContextLines);
    }
}

