/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.rider.projectTemplates;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/rider/projectTemplates/ProjectTemplateFiles;", "", "solutionDirectory", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getSolutionDirectory", "()Ljava/nio/file/Path;", "temporaryDirectory", "getTemporaryDirectory", "intellij.ml.llm.riderNext.latest.rider"})
public final class ProjectTemplateFiles {
    @NotNull
    private final Path solutionDirectory;
    @NotNull
    private final Path temporaryDirectory;

    public ProjectTemplateFiles(@NotNull Path solutionDirectory) {
        Intrinsics.checkNotNullParameter((Object)solutionDirectory, (String)"solutionDirectory");
        this.solutionDirectory = solutionDirectory;
        if (!this.solutionDirectory.isAbsolute()) {
            throw new Exception("Target directory is not a absolute");
        }
        Path path = Files.createTempDirectory(this.solutionDirectory.getFileName() + "_temp", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        this.temporaryDirectory = path;
    }

    @NotNull
    public final Path getSolutionDirectory() {
        return this.solutionDirectory;
    }

    @NotNull
    public final Path getTemporaryDirectory() {
        return this.temporaryDirectory;
    }
}

