/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.Group;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.LlmDescribableError;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.PatchLinePrivacyWrapper;
import com.intellij.ml.llm.vcs.diff.groupedDiff.llmRequest.TextFilePatchPrivacyWrapperKt;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u00c6\u0003J7\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/ChangeWithFileNotInGroupError;", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/LlmDescribableError;", "file", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "change", "Lcom/intellij/openapi/diff/impl/patch/PatchLine;", "group", "Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/Group;", "allowedGroups", "", "<init>", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;Lcom/intellij/openapi/diff/impl/patch/PatchLine;Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/Group;Ljava/util/List;)V", "getFile", "()Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "getChange", "()Lcom/intellij/openapi/diff/impl/patch/PatchLine;", "getGroup", "()Lcom/intellij/ml/llm/vcs/diff/groupedDiff/llmRequest/Group;", "getAllowedGroups", "()Ljava/util/List;", "descriptionForLlm", "Lcom/intellij/ml/llm/privacy/PSString;", "getDescriptionForLlm", "()Lcom/intellij/ml/llm/privacy/PSString;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.vcs.diff"})
public final class ChangeWithFileNotInGroupError
implements LlmDescribableError {
    @NotNull
    private final TextFilePatch file;
    @NotNull
    private final PatchLine change;
    @NotNull
    private final Group group;
    @NotNull
    private final List<Group> allowedGroups;

    public ChangeWithFileNotInGroupError(@NotNull TextFilePatch file2, @NotNull PatchLine change, @NotNull Group group, @NotNull List<Group> allowedGroups) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(allowedGroups, (String)"allowedGroups");
        this.file = file2;
        this.change = change;
        this.group = group;
        this.allowedGroups = allowedGroups;
    }

    @NotNull
    public final TextFilePatch getFile() {
        return this.file;
    }

    @NotNull
    public final PatchLine getChange() {
        return this.change;
    }

    @NotNull
    public final Group getGroup() {
        return this.group;
    }

    @NotNull
    public final List<Group> getAllowedGroups() {
        return this.allowedGroups;
    }

    @Override
    @NotNull
    public PSString getDescriptionForLlm() {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{TextFilePatchPrivacyWrapperKt.getFileNamePS(this.file), PSStringOperatorsKt.toPSString((int)this.change.getPatchFileLineNumber()), new PatchLinePrivacyWrapper(this.change).getText(), PSStringOperatorsKt.toPSString((int)this.group.getId()), PSStringKt.joinToString$default((Iterable)this.allowedGroups, null, null, null, (int)0, null, ChangeWithFileNotInGroupError::_get_descriptionForLlm_$lambda$0, (int)31, null)};
        return ConstantsKt.getPrivacyConst((String)"\n            **CHANGE ASSIGNED TO WRONG GROUP:**\n            A change was assigned to a group, but the file it belongs to is not included in that group. Only assign changes from this file to one of the allowed groups. Maybe you were inaccurate and included a couple of lines from this file when trying to assign changes from the next file? Even a single `+` couldn't be assigned incorrectly!\n            File: %s\n            Diff line number: %s\n            Line: %s\n            Wrong group: %s\n            Allowed groups: %s\n            Answer with only one group_id to which this change belongs.\n            ").trimIndent().format(pSStringConvertibleArray);
    }

    @NotNull
    public final TextFilePatch component1() {
        return this.file;
    }

    @NotNull
    public final PatchLine component2() {
        return this.change;
    }

    @NotNull
    public final Group component3() {
        return this.group;
    }

    @NotNull
    public final List<Group> component4() {
        return this.allowedGroups;
    }

    @NotNull
    public final ChangeWithFileNotInGroupError copy(@NotNull TextFilePatch file2, @NotNull PatchLine change, @NotNull Group group, @NotNull List<Group> allowedGroups) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(allowedGroups, (String)"allowedGroups");
        return new ChangeWithFileNotInGroupError(file2, change, group, allowedGroups);
    }

    public static /* synthetic */ ChangeWithFileNotInGroupError copy$default(ChangeWithFileNotInGroupError changeWithFileNotInGroupError, TextFilePatch textFilePatch, PatchLine patchLine, Group group, List list, int n, Object object) {
        if ((n & 1) != 0) {
            textFilePatch = changeWithFileNotInGroupError.file;
        }
        if ((n & 2) != 0) {
            patchLine = changeWithFileNotInGroupError.change;
        }
        if ((n & 4) != 0) {
            group = changeWithFileNotInGroupError.group;
        }
        if ((n & 8) != 0) {
            list = changeWithFileNotInGroupError.allowedGroups;
        }
        return changeWithFileNotInGroupError.copy(textFilePatch, patchLine, group, list);
    }

    @NotNull
    public String toString() {
        return "ChangeWithFileNotInGroupError(file=" + this.file + ", change=" + this.change + ", group=" + this.group + ", allowedGroups=" + this.allowedGroups + ")";
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + this.change.hashCode();
        result2 = result2 * 31 + this.group.hashCode();
        result2 = result2 * 31 + ((Object)this.allowedGroups).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChangeWithFileNotInGroupError)) {
            return false;
        }
        ChangeWithFileNotInGroupError changeWithFileNotInGroupError = (ChangeWithFileNotInGroupError)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)changeWithFileNotInGroupError.file)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.change, (Object)changeWithFileNotInGroupError.change)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.group, (Object)changeWithFileNotInGroupError.group)) {
            return false;
        }
        return Intrinsics.areEqual(this.allowedGroups, changeWithFileNotInGroupError.allowedGroups);
    }

    private static final PrivacySafe _get_descriptionForLlm_$lambda$0(Group it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PrivacySafe)PSStringOperatorsKt.toPSString((int)it.getId());
    }
}

