/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.internal;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.vcs.internal.CommitStats;
import com.intellij.ml.llm.vcs.internal.CommitStatsKt;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitCommit;
import git4idea.repo.GitRepository;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/vcs/internal/GitCommitStats;", "Lcom/intellij/ml/llm/vcs/internal/CommitStats;", "commit", "Lgit4idea/GitCommit;", "repo", "Lgit4idea/repo/GitRepository;", "<init>", "(Lgit4idea/GitCommit;Lgit4idea/repo/GitRepository;)V", "getCommit", "()Lgit4idea/GitCommit;", "getRepo", "()Lgit4idea/repo/GitRepository;", "instanceId", "", "getInstanceId", "()Ljava/lang/String;", "id", "getId", "taskRef", "getTaskRef", "implChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "getImplChanges", "()Ljava/util/List;", "testChanges", "getTestChanges", "fullMessage", "Lcom/intellij/ml/llm/privacy/PSString;", "getFullMessage", "()Lcom/intellij/ml/llm/privacy/PSString;", "createdAt", "Ljava/time/OffsetDateTime;", "getCreatedAt", "()Ljava/time/OffsetDateTime;", "baseCommit", "getBaseCommit", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nCommitStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitStats.kt\ncom/intellij/ml/llm/vcs/internal/GitCommitStats\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n774#2:102\n865#2,2:103\n774#2:105\n865#2,2:106\n*S KotlinDebug\n*F\n+ 1 CommitStats.kt\ncom/intellij/ml/llm/vcs/internal/GitCommitStats\n*L\n62#1:102\n62#1:103,2\n64#1:105\n64#1:106,2\n*E\n"})
public final class GitCommitStats
implements CommitStats {
    @NotNull
    private final GitCommit commit;
    @NotNull
    private final GitRepository repo;
    @NotNull
    private final String instanceId;
    @NotNull
    private final String id;
    @NotNull
    private final String taskRef;
    @NotNull
    private final PSString fullMessage;
    @NotNull
    private final OffsetDateTime createdAt;

    public GitCommitStats(@NotNull GitCommit commit, @NotNull GitRepository repo) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        this.commit = commit;
        this.repo = repo;
        String string = this.commit.getId().toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortString(...)");
        this.instanceId = string;
        String string2 = this.commit.getId().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        this.id = string2;
        String string3 = this.commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFullMessage(...)");
        this.taskRef = CommitStatsKt.access$determineTaskRef(string3);
        this.fullMessage = ExtensionsKtKt.getPrivacySafe((VcsCommitMetadata)this.commit).getFullMessage();
        this.createdAt = CommitStatsKt.access$toOffsetDateTime(this.commit.getCommitTime());
    }

    @NotNull
    public final GitCommit getCommit() {
        return this.commit;
    }

    @NotNull
    public final GitRepository getRepo() {
        return this.repo;
    }

    @Override
    @NotNull
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getTaskRef() {
        return this.taskRef;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Change> getImplChanges() {
        void $this$filterTo$iv$iv;
        Collection collection = this.commit.getChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Change it = (Change)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!CommitStatsKt.isTest(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Change> getTestChanges() {
        void $this$filterTo$iv$iv;
        Collection collection = this.commit.getChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Change it = (Change)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!CommitStatsKt.isTest(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public PSString getFullMessage() {
        return this.fullMessage;
    }

    @Override
    @NotNull
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @NotNull
    public String getBaseCommit() {
        List list = this.commit.getParents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
        Object object = (Hash)CollectionsKt.firstOrNull((List)list);
        if (object == null || (object = object.asString()) == null) {
            object = "";
        }
        return object;
    }
}

