/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.injected.editor.MarkupModelWindow;
import com.intellij.inlinePrompt.InlinePrompt;
import com.intellij.lang.Language;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptExtensionPoints;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptCompletionConfidence;", "Lcom/intellij/codeInsight/completion/CompletionConfidence;", "<init>", "()V", "shouldSkipAutopopup", "Lcom/intellij/util/ThreeState;", "editor", "Lcom/intellij/openapi/editor/Editor;", "contextElement", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "", "intellij.ml.llm.inlinePromptDetector"})
final class InlinePromptCompletionConfidence
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull Editor editor, @NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Language language = psiFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        if (InlinePromptExtensionPoints.INSTANCE.findDetectorByLanguage(language2) == null) {
            return ThreeState.UNSURE;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document == null) {
            return ThreeState.UNSURE;
        }
        Document document2 = document;
        MarkupModel model = DocumentMarkupModel.forDocument((Document)document2, (Project)psiFile.getProject(), (boolean)true);
        if (model instanceof MarkupModelWindow) {
            return ThreeState.UNSURE;
        }
        if (InlinePrompt.isInlinePromptShown$default((Editor)editor, null, null, (int)6, null)) {
            return ThreeState.YES;
        }
        return ThreeState.UNSURE;
    }
}

