/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.api.AddDataRow;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.GroupBy;
import org.jetbrains.kotlinx.dataframe.api.SortDsl;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.api.UpdateKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.columns.ValueColumn;
import org.jetbrains.kotlinx.dataframe.impl.api.ColumnSetWithSortFlag;
import org.jetbrains.kotlinx.dataframe.impl.api.SortColumnDescriptor;
import org.jetbrains.kotlinx.dataframe.impl.api.SortDirection;
import org.jetbrains.kotlinx.dataframe.impl.api.SortFlag;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.missing.MissingColumnGroup;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a|\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012J\u0010\u0004\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00030\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0005j\f\u0012\u0004\u0012\u0002H\u0003\u0012\u0002\b\u0003`\f\u00a2\u0006\u0002\b\u000bH\u0000\u001a~\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\r\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102N\u0010\u0004\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00020\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\n0\u0005j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u000e`\f\u00a2\u0006\u0002\b\u000bH\u0000\u001a\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\n\u0012\u0002\b\u00030\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0080\u0001\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u00020\r2N\u0010\u0004\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00020\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\n0\u0005j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u000e`\f\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a&\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001c\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a&\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001f\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u001f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\f\u0010 \u001a\u00020!*\u00020!H\u0000\u00a8\u0006\""}, d2={"sortByImpl", "Lorg/jetbrains/kotlinx/dataframe/api/GroupBy;", "T", "G", "columns", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/SortDsl;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/api/SortColumnsSelector;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "C", "unresolvedColumnsPolicy", "Lorg/jetbrains/kotlinx/dataframe/columns/UnresolvedColumnsPolicy;", "createComparator", "Ljava/util/Comparator;", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "nullsLast", "", "getSortColumns", "", "Lorg/jetbrains/kotlinx/dataframe/impl/api/SortColumnDescriptor;", "addFlag", "Lorg/jetbrains/kotlinx/dataframe/impl/api/ColumnSetWithSortFlag;", "flag", "Lorg/jetbrains/kotlinx/dataframe/impl/api/SortFlag;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "reversed", "Lorg/jetbrains/kotlinx/dataframe/impl/api/SortDirection;", "core"})
@SourceDebugExtension(value={"SMAP\nsort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sort.kt\norg/jetbrains/kotlinx/dataframe/impl/api/SortKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1557#2:127\n1628#2,3:128\n2669#2,7:131\n827#2:138\n855#2,2:139\n1557#2:141\n1628#2,3:142\n*S KotlinDebug\n*F\n+ 1 sort.kt\norg/jetbrains/kotlinx/dataframe/impl/api/SortKt\n*L\n45#1:127\n45#1:128,3\n50#1:131,7\n74#1:138\n74#1:139,2\n75#1:141\n75#1:142,3\n*E\n"})
public final class SortKt {
    @NotNull
    public static final <T, G> GroupBy<T, G> sortByImpl(@NotNull GroupBy<? extends T, ? extends G> $this$sortByImpl, @NotNull Function2<? super SortDsl<? extends G>, ? super SortDsl<? extends G>, ? extends ColumnsResolver<?>> columns2) {
        Intrinsics.checkNotNullParameter($this$sortByImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return TypeConversionsKt.asGroupBy(SortKt.sortByImpl(UpdateKt.with(UpdateKt.update(GroupBy.DefaultImpls.toDataFrame$default($this$sortByImpl, null, 1, null), (arg_0, arg_1) -> SortKt.sortByImpl$lambda$0($this$sortByImpl, arg_0, arg_1)), (arg_0, arg_1) -> SortKt.sortByImpl$lambda$1(columns2, arg_0, arg_1)), UnresolvedColumnsPolicy.Skip, (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(columns2, (int)2)), (arg_0, arg_1) -> SortKt.sortByImpl$lambda$2($this$sortByImpl, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> DataFrame<T> sortByImpl(@NotNull DataFrame<? extends T> $this$sortByImpl, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super SortDsl<? extends T>, ? super SortDsl<? extends T>, ? extends ColumnsResolver<? extends C>> columns2) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$sortByImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        List<SortColumnDescriptor<?>> sortColumns = SortKt.getSortColumns($this$sortByImpl, columns2, unresolvedColumnsPolicy);
        if (sortColumns.isEmpty()) {
            return $this$sortByImpl;
        }
        Iterable $this$map$iv = sortColumns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Comparator<Integer> comparator;
            void it;
            SortColumnDescriptor sortColumnDescriptor = (SortColumnDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getDirection().ordinal()]) {
                case 1: {
                    comparator = SortKt.createComparator(it.getColumn(), it.getNullsLast());
                    break;
                }
                case 2: {
                    comparator = SortKt.createComparator(it.getColumn(), it.getNullsLast()).reversed();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(comparator);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            Comparator $i$f$mapTo2 = (Comparator)iterator$iv.next();
            Comparator a = (Comparator)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)a);
            Intrinsics.checkNotNull((Object)b);
            accumulator$iv = ComparisonsKt.then((Comparator)a, (Comparator)b);
        }
        Comparator compChain = (Comparator)accumulator$iv;
        Iterable iterable2 = (Iterable)RangesKt.until((int)0, (int)DataFrameKt.getNrow($this$sortByImpl));
        Intrinsics.checkNotNull((Object)compChain);
        List permutation = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)compChain);
        return $this$sortByImpl.get(permutation);
    }

    public static /* synthetic */ DataFrame sortByImpl$default(DataFrame dataFrame, UnresolvedColumnsPolicy unresolvedColumnsPolicy, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            unresolvedColumnsPolicy = UnresolvedColumnsPolicy.Fail;
        }
        return SortKt.sortByImpl(dataFrame, unresolvedColumnsPolicy, function2);
    }

    @NotNull
    public static final Comparator<Integer> createComparator(@NotNull DataColumn<?> $this$createComparator, boolean nullsLast) {
        Intrinsics.checkNotNullParameter($this$createComparator, (String)"<this>");
        UtilsKt.assertIsComparable($this$createComparator);
        Comparator valueComparator = SortKt::createComparator$lambda$5;
        Comparator comparatorWithNulls = nullsLast ? ComparisonsKt.nullsLast((Comparator)valueComparator) : ComparisonsKt.nullsFirst((Comparator)valueComparator);
        return (arg_0, arg_1) -> SortKt.createComparator$lambda$6(comparatorWithNulls, $this$createComparator, arg_0, arg_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> List<SortColumnDescriptor<?>> getSortColumns(@NotNull DataFrame<? extends T> $this$getSortColumns, @NotNull Function2<? super SortDsl<? extends T>, ? super SortDsl<? extends T>, ? extends ColumnsResolver<? extends C>> columns2, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy) {
        void $this$mapTo$iv$iv;
        ColumnWithPath it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getSortColumns, (String)"<this>");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Iterable $this$filterNot$iv = UtilsKt.resolve(ConstructorsKt.toColumnSetForSort(columns2), $this$getSortColumns, unresolvedColumnsPolicy);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ColumnWithPath)element$iv$iv;
            boolean bl = false;
            if (it.getData() instanceof MissingColumnGroup) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SortColumnDescriptor sortColumnDescriptor;
            it = (ColumnWithPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DataColumn col = it.getData();
            if (col instanceof SortColumnDescriptor) {
                sortColumnDescriptor = (SortColumnDescriptor)col;
            } else if (col instanceof ValueColumn) {
                sortColumnDescriptor = new SortColumnDescriptor((ValueColumn)col, null, false, 6, null);
            } else {
                throw new IllegalStateException("Can not use " + (Object)((Object)DataColumnKt.getKind(col)) + " as sort column");
            }
            collection.add(sortColumnDescriptor);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <C> ColumnSetWithSortFlag<C> addFlag(@NotNull ColumnsResolver<? extends C> $this$addFlag, @NotNull SortFlag flag) {
        Intrinsics.checkNotNullParameter($this$addFlag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)flag), (String)"flag");
        return new ColumnSetWithSortFlag<C>($this$addFlag, flag);
    }

    @NotNull
    public static final <C> ColumnWithPath<C> addFlag(@NotNull ColumnWithPath<? extends C> $this$addFlag, @NotNull SortFlag flag) {
        SortColumnDescriptor sortColumnDescriptor;
        block9: {
            DataColumn<C> col;
            block10: {
                DataColumn<C> dataColumn;
                block8: {
                    Intrinsics.checkNotNullParameter($this$addFlag, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)((Object)flag), (String)"flag");
                    dataColumn = col = $this$addFlag.getData();
                    if (!(dataColumn instanceof SortColumnDescriptor)) break block8;
                    switch (WhenMappings.$EnumSwitchMapping$1[flag.ordinal()]) {
                        case 1: {
                            sortColumnDescriptor = new SortColumnDescriptor(((SortColumnDescriptor)col).getColumn(), SortKt.reversed(((SortColumnDescriptor)col).getDirection()), ((SortColumnDescriptor)col).getNullsLast());
                            break block9;
                        }
                        case 2: {
                            sortColumnDescriptor = new SortColumnDescriptor(((SortColumnDescriptor)col).getColumn(), ((SortColumnDescriptor)col).getDirection(), true);
                            break block9;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (!(dataColumn instanceof ValueColumn)) break block10;
                switch (WhenMappings.$EnumSwitchMapping$1[flag.ordinal()]) {
                    case 1: {
                        sortColumnDescriptor = new SortColumnDescriptor((ValueColumn)col, SortDirection.Desc, false, 4, null);
                        break block9;
                    }
                    case 2: {
                        sortColumnDescriptor = new SortColumnDescriptor((ValueColumn)col, SortDirection.Asc, true);
                        break block9;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            throw new IllegalArgumentException("Can not apply sort flag to column kind " + (Object)((Object)DataColumnKt.getKind(col)));
        }
        return UtilsKt.addPath(sortColumnDescriptor, $this$addFlag.getPath());
    }

    @NotNull
    public static final SortDirection reversed(@NotNull SortDirection $this$reversed) {
        SortDirection sortDirection;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$reversed), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$reversed.ordinal()]) {
            case 1: {
                sortDirection = SortDirection.Desc;
                break;
            }
            case 2: {
                sortDirection = SortDirection.Asc;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sortDirection;
    }

    private static final ColumnsResolver sortByImpl$lambda$0(GroupBy $this_sortByImpl, ColumnsSelectionDsl $this$update, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $this_sortByImpl.getGroups();
    }

    private static final DataFrame sortByImpl$lambda$1(Function2 $columns, AddDataRow $this$with, DataFrame it) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$this$with");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SortKt.sortByImpl(it, UnresolvedColumnsPolicy.Skip, $columns);
    }

    private static final SingleColumn sortByImpl$lambda$2(GroupBy $this_sortByImpl, ColumnsSelectionDsl $this$asGroupBy, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)$this$asGroupBy, (String)"$this$asGroupBy");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CastKt.castFrameColumn(DataFrameGetKt.getFrameColumn((ColumnsContainer)it, $this_sortByImpl.getGroups().name()));
    }

    private static final int createComparator$lambda$5(Object left, Object right) {
        Intrinsics.checkNotNull((Object)left, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any?>");
        return ((Comparable)left).compareTo(right);
    }

    private static final int createComparator$lambda$6(Comparator $comparatorWithNulls, DataColumn $this_createComparator, Integer left, Integer right) {
        Intrinsics.checkNotNull((Object)left);
        Object t = $this_createComparator.get(left);
        Intrinsics.checkNotNull((Object)right);
        return $comparatorWithNulls.compare(t, $this_createComparator.get(right));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SortDirection.values().length];
            try {
                nArray[SortDirection.Asc.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortDirection.Desc.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SortFlag.values().length];
            try {
                nArray[SortFlag.Reversed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortFlag.NullsLast.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

