/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.code.indexing.model;

import ai.grazie.code.indexing.model.ExperimentalIndices;
import ai.grazie.code.indexing.model.IndexAlias;
import ai.grazie.code.indexing.model.ProductionIndices;
import ai.grazie.utils.StringValueClassSerializer;
import ai.grazie.utils.mpp.MPPLogger;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lai/grazie/code/indexing/model/IndexAliasSerializer;", "Lkotlinx/serialization/KSerializer;", "Lai/grazie/code/indexing/model/IndexAlias;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "createFromTypeName", "typeName", "", "createFromTypeString", "oldFormatJsonObject", "Lkotlinx/serialization/json/JsonObject;", "alias", "StringSerializer", "model-indexing"})
public final class IndexAliasSerializer
implements KSerializer<IndexAlias> {
    @NotNull
    public static final IndexAliasSerializer INSTANCE = new IndexAliasSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = StringSerializer.INSTANCE.getDescriptor();

    private IndexAliasSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull IndexAlias value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((JsonEncoder)encoder).encodeJsonElement((JsonElement)this.oldFormatJsonObject(value));
    }

    @NotNull
    public IndexAlias deserialize(@NotNull Decoder decoder) {
        IndexAlias indexAlias;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonElement element = ((JsonDecoder)decoder).decodeJsonElement();
        if (element instanceof JsonPrimitive && ((JsonPrimitive)element).isString()) {
            String typeString = ((JsonPrimitive)element).getContent();
            indexAlias = this.createFromTypeString(typeString);
        } else if (element instanceof JsonObject && ((JsonObject)element).containsKey((Object)"name")) {
            Object object = (JsonElement)((JsonObject)element).get((Object)"name");
            if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
                object = "";
            }
            Object typeValue = object;
            indexAlias = this.createFromTypeName((String)typeValue);
        } else {
            MPPLogger.warning$default(IndexAlias.Companion.getLogger(), null, () -> IndexAliasSerializer.deserialize$lambda$0(element), 1, null);
            indexAlias = ProductionIndices.CodeBlocks.INSTANCE;
        }
        return indexAlias;
    }

    @Deprecated(message="Will be removed when all clients are updated")
    private final IndexAlias createFromTypeName(String typeName) {
        return switch (typeName) {
            case "ai.grazie.code.indexing.model.ProductionIndices.CodeBlocks" -> ProductionIndices.CodeBlocks.INSTANCE;
            case "ai.grazie.code.indexing.model.ProductionIndices.Symbols" -> ProductionIndices.Symbols.INSTANCE;
            case "ai.grazie.code.indexing.model.ProductionIndices.Files" -> ProductionIndices.Files.INSTANCE;
            case "ai.grazie.code.indexing.model.ExperimentalIndices.Raptor" -> ExperimentalIndices.Raptor.INSTANCE;
            case "ai.grazie.code.indexing.model.ExperimentalIndices.Commits" -> ExperimentalIndices.Commits.INSTANCE;
            default -> {
                MPPLogger.warning$default(IndexAlias.Companion.getLogger(), null, () -> IndexAliasSerializer.createFromTypeName$lambda$1(typeName), 1, null);
                yield ProductionIndices.CodeBlocks.INSTANCE;
            }
        };
    }

    private final IndexAlias createFromTypeString(String typeName) {
        IndexAlias indexAlias;
        String string = typeName;
        if (Intrinsics.areEqual((Object)string, (Object)ProductionIndices.CodeBlocks.INSTANCE.getId())) {
            indexAlias = ProductionIndices.CodeBlocks.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string, (Object)ProductionIndices.Symbols.INSTANCE.getId())) {
            indexAlias = ProductionIndices.Symbols.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string, (Object)ProductionIndices.Files.INSTANCE.getId())) {
            indexAlias = ProductionIndices.Files.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string, (Object)ExperimentalIndices.Raptor.INSTANCE.getId())) {
            indexAlias = ExperimentalIndices.Raptor.INSTANCE;
        } else if (Intrinsics.areEqual((Object)string, (Object)ExperimentalIndices.Commits.INSTANCE.getId())) {
            indexAlias = ExperimentalIndices.Commits.INSTANCE;
        } else {
            MPPLogger.warning$default(IndexAlias.Companion.getLogger(), null, () -> IndexAliasSerializer.createFromTypeString$lambda$2(typeName), 1, null);
            indexAlias = ProductionIndices.CodeBlocks.INSTANCE;
        }
        return indexAlias;
    }

    private final JsonObject oldFormatJsonObject(IndexAlias alias) {
        String string;
        IndexAlias indexAlias = alias;
        if (indexAlias instanceof ProductionIndices.CodeBlocks) {
            string = "ProductionIndices.CodeBlocks";
        } else if (indexAlias instanceof ProductionIndices.Files) {
            string = "ProductionIndices.Files";
        } else if (indexAlias instanceof ProductionIndices.Symbols) {
            string = "ProductionIndices.Symbols";
        } else if (indexAlias instanceof ExperimentalIndices.Raptor) {
            string = "ExperimentalIndices.Raptor";
        } else if (indexAlias instanceof ExperimentalIndices.Commits) {
            string = "ExperimentalIndices.Commits";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String name2 = string;
        return new JsonObject(MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)JsonElementKt.JsonPrimitive((String)("ai.grazie.code.indexing.model." + name2)))));
    }

    private static final String deserialize$lambda$0(JsonElement $element) {
        return "Unknown index alias format: " + $element + " " + Reflection.getOrCreateKotlinClass($element.getClass()).getSimpleName();
    }

    private static final String createFromTypeName$lambda$1(String $typeName) {
        return "Unknown index alias when createFromTypeName: " + $typeName;
    }

    private static final String createFromTypeString$lambda$2(String $typeName) {
        return "Unknown index alias: " + $typeName;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lai/grazie/code/indexing/model/IndexAliasSerializer$StringSerializer;", "Lai/grazie/utils/StringValueClassSerializer;", "Lai/grazie/code/indexing/model/IndexAlias;", "<init>", "()V", "model-indexing"})
    private static final class StringSerializer
    extends StringValueClassSerializer<IndexAlias> {
        @NotNull
        public static final StringSerializer INSTANCE = new StringSerializer();

        private StringSerializer() {
            super("IndexAlias", StringSerializer::_init_$lambda$0, StringSerializer::_init_$lambda$1);
        }

        private static final IndexAlias _init_$lambda$0(String typeName) {
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            return INSTANCE.createFromTypeString(typeName);
        }

        private static final String _init_$lambda$1(IndexAlias value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value.getId().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }
    }
}

