/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp.time;

import ai.grazie.utils.mpp.time.TimeInterval$;
import ai.grazie.utils.mpp.time.Timestamp;
import ai.grazie.utils.multiplatform.SafeJsExport;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SafeJsExport
@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u0012\u001a\u00020\u0010J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006%"}, d2={"Lai/grazie/utils/mpp/time/TimeInterval;", "", "start", "Lai/grazie/utils/mpp/time/Timestamp;", "endExclusive", "<init>", "(Lai/grazie/utils/mpp/time/Timestamp;Lai/grazie/utils/mpp/time/Timestamp;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILai/grazie/utils/mpp/time/Timestamp;Lai/grazie/utils/mpp/time/Timestamp;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getStart", "()Lai/grazie/utils/mpp/time/Timestamp;", "getEndExclusive", "contains", "", "point", "isEmpty", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$utils_common", "Companion", "$serializer", "utils-common"})
public final class TimeInterval {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Timestamp start;
    @NotNull
    private final Timestamp endExclusive;
    @NotNull
    private static final TimeInterval EMPTY = new TimeInterval(Timestamp.Companion.epoch(), Timestamp.Companion.epoch());

    public TimeInterval(@NotNull Timestamp start2, @NotNull Timestamp endExclusive) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        this.start = start2;
        this.endExclusive = endExclusive;
    }

    @NotNull
    public final Timestamp getStart() {
        return this.start;
    }

    @NotNull
    public final Timestamp getEndExclusive() {
        return this.endExclusive;
    }

    public final boolean contains(@NotNull Timestamp point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.start.compareTo(point) <= 0 && point.compareTo(this.endExclusive) < 0;
    }

    public final boolean isEmpty() {
        return this.start.compareTo(this.endExclusive) >= 0;
    }

    @NotNull
    public final Timestamp component1() {
        return this.start;
    }

    @NotNull
    public final Timestamp component2() {
        return this.endExclusive;
    }

    @NotNull
    public final TimeInterval copy(@NotNull Timestamp start2, @NotNull Timestamp endExclusive) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        return new TimeInterval(start2, endExclusive);
    }

    public static /* synthetic */ TimeInterval copy$default(TimeInterval timeInterval, Timestamp timestamp, Timestamp timestamp2, int n, Object object) {
        if ((n & 1) != 0) {
            timestamp = timeInterval.start;
        }
        if ((n & 2) != 0) {
            timestamp2 = timeInterval.endExclusive;
        }
        return timeInterval.copy(timestamp, timestamp2);
    }

    @NotNull
    public String toString() {
        return "TimeInterval(start=" + this.start + ", endExclusive=" + this.endExclusive + ")";
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = result2 * 31 + this.endExclusive.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TimeInterval)) {
            return false;
        }
        TimeInterval timeInterval = (TimeInterval)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)timeInterval.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endExclusive, (Object)timeInterval.endExclusive);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$utils_common(TimeInterval self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)Timestamp.Serializer.INSTANCE, (Object)self.start);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)Timestamp.Serializer.INSTANCE, (Object)self.endExclusive);
    }

    public /* synthetic */ TimeInterval(int seen0, Timestamp start2, Timestamp endExclusive, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.start = start2;
        this.endExclusive = endExclusive;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lai/grazie/utils/mpp/time/TimeInterval$Companion;", "", "<init>", "()V", "EMPTY", "Lai/grazie/utils/mpp/time/TimeInterval;", "getEMPTY", "()Lai/grazie/utils/mpp/time/TimeInterval;", "sinceEpoch", "to", "Lai/grazie/utils/mpp/time/Timestamp;", "tillMax", "from", "serializer", "Lkotlinx/serialization/KSerializer;", "utils-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeInterval getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final TimeInterval sinceEpoch(@NotNull Timestamp to) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            return new TimeInterval(Timestamp.Companion.epoch(), to);
        }

        @NotNull
        public final TimeInterval tillMax(@NotNull Timestamp from) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            return new TimeInterval(from, Timestamp.Companion.max());
        }

        @NotNull
        public final KSerializer<TimeInterval> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

