/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.features.opentelemetry.span;

import ai.koog.agents.features.opentelemetry.attribute.CommonAttributes;
import ai.koog.agents.features.opentelemetry.attribute.SpanAttributes;
import ai.koog.agents.features.opentelemetry.span.CryptographyUtilKt;
import ai.koog.agents.features.opentelemetry.span.GenAIAgentSpan;
import ai.koog.agents.features.opentelemetry.span.NodeExecuteSpan;
import ai.koog.prompt.llm.LLMProvider;
import ai.koog.prompt.llm.LLModel;
import io.opentelemetry.api.trace.SpanKind;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Lai/koog/agents/features/opentelemetry/span/InferenceSpan;", "Lai/koog/agents/features/opentelemetry/span/GenAIAgentSpan;", "parent", "Lai/koog/agents/features/opentelemetry/span/NodeExecuteSpan;", "provider", "Lai/koog/prompt/llm/LLMProvider;", "runId", "", "model", "Lai/koog/prompt/llm/LLModel;", "content", "temperature", "", "maxTokens", "", "<init>", "(Lai/koog/agents/features/opentelemetry/span/NodeExecuteSpan;Lai/koog/prompt/llm/LLMProvider;Ljava/lang/String;Lai/koog/prompt/llm/LLModel;Ljava/lang/String;DLjava/lang/Integer;)V", "getProvider", "()Lai/koog/prompt/llm/LLMProvider;", "getRunId", "()Ljava/lang/String;", "getModel", "()Lai/koog/prompt/llm/LLModel;", "getContent", "getTemperature", "()D", "getMaxTokens", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "spanId", "getSpanId", "kind", "Lio/opentelemetry/api/trace/SpanKind;", "getKind", "()Lio/opentelemetry/api/trace/SpanKind;", "Companion", "agents-features-opentelemetry"})
public final class InferenceSpan
extends GenAIAgentSpan {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LLMProvider provider;
    @NotNull
    private final String runId;
    @NotNull
    private final LLModel model;
    @NotNull
    private final String content;
    private final double temperature;
    @Nullable
    private final Integer maxTokens;
    @NotNull
    private final String spanId;
    @NotNull
    private final SpanKind kind;

    public InferenceSpan(@NotNull NodeExecuteSpan parent, @NotNull LLMProvider provider, @NotNull String runId, @NotNull LLModel model, @NotNull String content2, double temperature, @Nullable Integer maxTokens) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)runId, (String)"runId");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            super(parent);
            this.provider = provider;
            this.runId = runId;
            this.model = model;
            this.content = content2;
            this.temperature = temperature;
            this.maxTokens = maxTokens;
            this.spanId = InferenceSpan.Companion.createIdFromParent(parent.getSpanId(), this.content);
            this.kind = SpanKind.CLIENT;
            this.addAttribute(new SpanAttributes.Operation.Name(SpanAttributes.Operation.OperationNameType.CHAT));
            this.addAttribute(new CommonAttributes.System(this.provider));
            this.addAttribute(new SpanAttributes.Conversation.Id(this.runId));
            this.addAttribute(new SpanAttributes.Request.Model(this.model));
            this.addAttribute(new SpanAttributes.Request.Temperature(this.temperature));
            Integer n = this.maxTokens;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.addAttribute(new SpanAttributes.Request.MaxTokens(it));
        }
    }

    public /* synthetic */ InferenceSpan(NodeExecuteSpan nodeExecuteSpan, LLMProvider lLMProvider, String string, LLModel lLModel, String string2, double d, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            n = null;
        }
        this(nodeExecuteSpan, lLMProvider, string, lLModel, string2, d, n);
    }

    @NotNull
    public final LLMProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final String getRunId() {
        return this.runId;
    }

    @NotNull
    public final LLModel getModel() {
        return this.model;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    @Nullable
    public final Integer getMaxTokens() {
        return this.maxTokens;
    }

    @Override
    @NotNull
    public String getSpanId() {
        return this.spanId;
    }

    @Override
    @NotNull
    public SpanKind getKind() {
        return this.kind;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lai/koog/agents/features/opentelemetry/span/InferenceSpan$Companion;", "", "<init>", "()V", "createId", "", "agentId", "runId", "nodeName", "nodeId", "content", "createIdFromParent", "parentId", "agents-features-opentelemetry"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String createId(@NotNull String agentId, @NotNull String runId, @NotNull String nodeName, @NotNull String nodeId, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
            Intrinsics.checkNotNullParameter((Object)runId, (String)"runId");
            Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
            Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return this.createIdFromParent(NodeExecuteSpan.Companion.createId(agentId, runId, nodeName, nodeId), content2);
        }

        private final String createIdFromParent(String parentId, String content2) {
            return parentId + ".llm." + CryptographyUtilKt.sha256base64(content2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

