/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.prompt.executor.ollama.client.dto;

import ai.koog.agents.core.tools.ToolDescriptor;
import ai.koog.prompt.dsl.Prompt;
import ai.koog.prompt.executor.ollama.client.dto.OllamaChatMessageDTO;
import ai.koog.prompt.executor.ollama.client.dto.OllamaToolCallDTO;
import ai.koog.prompt.executor.ollama.client.dto.OllamaToolDTO;
import ai.koog.prompt.executor.ollama.tools.json.JSONSchemaFunctionConverterKt;
import ai.koog.prompt.llm.LLMCapability;
import ai.koog.prompt.llm.LLModel;
import ai.koog.prompt.message.AttachmentContent;
import ai.koog.prompt.message.ContentPart;
import ai.koog.prompt.message.Message;
import ai.koog.prompt.message.ResponseMetaInfo;
import ai.koog.prompt.params.LLMParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0002*\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0003H\u0000\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"toOllamaChatMessages", "", "Lai/koog/prompt/executor/ollama/client/dto/OllamaChatMessageDTO;", "Lai/koog/prompt/dsl/Prompt;", "model", "Lai/koog/prompt/llm/LLModel;", "toOllamaChatMessage", "Lai/koog/prompt/message/Message$User;", "toOllamaTool", "Lai/koog/prompt/executor/ollama/client/dto/OllamaToolDTO;", "Lai/koog/agents/core/tools/ToolDescriptor;", "extractOllamaJsonFormat", "Lkotlinx/serialization/json/JsonObject;", "getFirstToolCall", "Lai/koog/prompt/message/Message$Tool$Call;", "responseMetadata", "Lai/koog/prompt/message/ResponseMetaInfo;", "getToolCalls", "generateToolCallId", "", "toolName", "content", "index", "", "prompt-executor-ollama-client"})
@SourceDebugExtension(value={"SMAP\nOllamaConverters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OllamaConverters.kt\nai/koog/prompt/executor/ollama/client/dto/OllamaConvertersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,185:1\n1869#2,2:186\n1573#2:190\n1604#2,3:191\n1607#2:195\n1#3:188\n205#4:189\n205#4:194\n*S KotlinDebug\n*F\n+ 1 OllamaConverters.kt\nai/koog/prompt/executor/ollama/client/dto/OllamaConvertersKt\n*L\n65#1:186,2\n154#1:190\n154#1:191,3\n154#1:195\n133#1:189\n156#1:194\n*E\n"})
public final class OllamaConvertersKt {
    @NotNull
    public static final List<OllamaChatMessageDTO> toOllamaChatMessages(@NotNull Prompt $this$toOllamaChatMessages, @NotNull LLModel model) {
        Intrinsics.checkNotNullParameter((Object)$this$toOllamaChatMessages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        List messages = new ArrayList();
        for (Message message : $this$toOllamaChatMessages.getMessages()) {
            OllamaChatMessageDTO ollamaChatMessageDTO;
            Message message2 = message;
            if (message2 instanceof Message.System) {
                ollamaChatMessageDTO = new OllamaChatMessageDTO("system", message.getContent(), null, null, 12, null);
            } else if (message2 instanceof Message.User) {
                ollamaChatMessageDTO = OllamaConvertersKt.toOllamaChatMessage((Message.User)message, model);
            } else if (message2 instanceof Message.Assistant) {
                ollamaChatMessageDTO = new OllamaChatMessageDTO("assistant", message.getContent(), null, null, 12, null);
            } else if (message2 instanceof Message.Tool.Call) {
                ollamaChatMessageDTO = new OllamaChatMessageDTO("assistant", "", null, CollectionsKt.listOf((Object)new OllamaToolCallDTO(new OllamaToolCallDTO.Call(((Message.Tool.Call)message).getTool(), Json.Default.parseToJsonElement(message.getContent())))), 4, null);
            } else if (message2 instanceof Message.Tool.Result) {
                ollamaChatMessageDTO = new OllamaChatMessageDTO("tool", message.getContent(), null, null, 12, null);
            } else {
                if (message2 instanceof Message.Reasoning) {
                    throw new NotImplementedError("Reasoning is not supported by Ollama");
                }
                throw new NoWhenBranchMatchedException();
            }
            OllamaChatMessageDTO converted = ollamaChatMessageDTO;
            messages.add(converted);
        }
        return messages;
    }

    /*
     * WARNING - void declaration
     */
    private static final OllamaChatMessageDTO toOllamaChatMessage(Message.User $this$toOllamaChatMessage, LLModel model) {
        void it;
        List images;
        List list2;
        List $this$toOllamaChatMessage_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = $this$toOllamaChatMessage.getParts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContentPart part = (ContentPart)element$iv;
            boolean bl2 = false;
            ContentPart contentPart = part;
            if (contentPart instanceof ContentPart.Text) continue;
            if (contentPart instanceof ContentPart.Image) {
                if (!model.getCapabilities().contains(LLMCapability.Vision.Image.INSTANCE)) {
                    boolean $i$a$-require-OllamaConvertersKt$toOllamaChatMessage$images$1$1$22 = false;
                    String $i$a$-require-OllamaConvertersKt$toOllamaChatMessage$images$1$1$22 = "Model " + model.getId() + " doesn't support images";
                    throw new IllegalArgumentException($i$a$-require-OllamaConvertersKt$toOllamaChatMessage$images$1$1$22.toString());
                }
                AttachmentContent content2 = ((ContentPart.Image)part).getContent();
                if (!(content2 instanceof AttachmentContent.Binary)) {
                    throw new IllegalArgumentException("Unsupported image attachment content: " + Reflection.getOrCreateKotlinClass(content2.getClass()));
                }
                String image = ((AttachmentContent.Binary)content2).asBase64();
                $this$toOllamaChatMessage_u24lambda_u242.add(image);
                continue;
            }
            throw new IllegalArgumentException("Unsupported attachment type: " + part);
        }
        $this$toOllamaChatMessage_u24lambda_u242 = list2 = (images = CollectionsKt.build((List)list2));
        String string = $this$toOllamaChatMessage.getContent();
        String string2 = "user";
        boolean bl3 = false;
        boolean bl4 = !((Collection)it).isEmpty();
        List list3 = bl4 ? list2 : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        List list4 = null;
        List list5 = list3;
        String string3 = string;
        String string4 = string2;
        return new OllamaChatMessageDTO(string4, string3, list5, list4, n, defaultConstructorMarker);
    }

    @NotNull
    public static final OllamaToolDTO toOllamaTool(@NotNull ToolDescriptor $this$toOllamaTool) {
        Intrinsics.checkNotNullParameter((Object)$this$toOllamaTool, (String)"<this>");
        JsonObject jsonSchema = JSONSchemaFunctionConverterKt.toJSONSchema($this$toOllamaTool);
        return new OllamaToolDTO("function", new OllamaToolDTO.Definition($this$toOllamaTool.getName(), $this$toOllamaTool.getDescription(), (JsonElement)jsonSchema));
    }

    @Nullable
    public static final JsonObject extractOllamaJsonFormat(@NotNull Prompt $this$extractOllamaJsonFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$extractOllamaJsonFormat, (String)"<this>");
        LLMParams.Schema schema = $this$extractOllamaJsonFormat.getParams().getSchema();
        return schema instanceof LLMParams.Schema.JSON ? ((LLMParams.Schema.JSON)schema).getSchema() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Message.Tool.Call getFirstToolCall(@NotNull OllamaChatMessageDTO $this$getFirstToolCall, @NotNull ResponseMetaInfo responseMetadata) {
        void this_$iv;
        Json json;
        Intrinsics.checkNotNullParameter((Object)$this$getFirstToolCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
        Collection collection = $this$getFirstToolCall.getToolCalls();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        OllamaToolCallDTO ollamaToolCallDTO = (OllamaToolCallDTO)CollectionsKt.firstOrNull($this$getFirstToolCall.getToolCalls());
        if (ollamaToolCallDTO == null) {
            return null;
        }
        OllamaToolCallDTO toolCall = ollamaToolCallDTO;
        String name2 = toolCall.getFunction().getName();
        Json json2 = json = JsonKt.Json$default(null, OllamaConvertersKt::getFirstToolCall$lambda$4, (int)1, null);
        JsonElement value$iv = toolCall.getFunction().getArguments();
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String content2 = this_$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value$iv);
        return new Message.Tool.Call(OllamaConvertersKt.generateToolCallId$default(name2, content2, 0, 4, null), name2, content2, responseMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Message.Tool.Call> getToolCalls(@NotNull OllamaChatMessageDTO $this$getToolCalls, @NotNull ResponseMetaInfo responseMetadata) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getToolCalls, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)responseMetadata, (String)"responseMetadata");
        Collection collection = $this$getToolCalls.getToolCalls();
        if (collection == null || collection.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapIndexed$iv = $this$getToolCalls.getToolCalls();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void this_$iv;
            void toolCall;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OllamaToolCallDTO ollamaToolCallDTO = (OllamaToolCallDTO)item$iv$iv;
            int n2 = n;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String name2 = toolCall.getFunction().getName();
            Json json = (Json)Json.Default;
            JsonElement value$iv = toolCall.getFunction().getArguments();
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String content2 = this_$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value$iv);
            collection2.add(new Message.Tool.Call(OllamaConvertersKt.generateToolCallId(name2, content2, (int)index), name2, content2, responseMetadata));
        }
        return (List)destination$iv$iv;
    }

    private static final String generateToolCallId(String toolName, String content2, int index) {
        String combined = toolName + ":" + content2 + ":" + index;
        int hashCode = combined.hashCode();
        return "ollama_tool_call_" + UInt.toString-impl((int)UInt.constructor-impl((int)hashCode));
    }

    static /* synthetic */ String generateToolCallId$default(String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return OllamaConvertersKt.generateToolCallId(string, string2, n);
    }

    private static final Unit getFirstToolCall$lambda$4(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setAllowStructuredMapKeys(true);
        return Unit.INSTANCE;
    }
}

