/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.compat;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncSupport;
import org.apache.hc.client5.http.impl.compat.SharedInputBuffer;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.io.support.ClassicResponseBuilder;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Timeout;

@Experimental
@Internal
class ClassicToAsyncResponseConsumer
implements AsyncResponseConsumer<Void> {
    private final int initialBufferSize;
    private final Timeout timeout;
    private final CountDownLatch countDownLatch;
    private final AtomicReference<ResponseData> responseRef;
    private final AtomicReference<FutureCallback<Void>> callbackRef;
    private final AtomicReference<SharedInputBuffer> bufferRef;
    private final AtomicReference<Exception> exceptionRef;

    public ClassicToAsyncResponseConsumer(int initialBufferSize, Timeout timeout) {
        this.initialBufferSize = Args.positive(initialBufferSize, "Initial buffer size");
        this.timeout = timeout;
        this.countDownLatch = new CountDownLatch(1);
        this.responseRef = new AtomicReference();
        this.callbackRef = new AtomicReference();
        this.bufferRef = new AtomicReference();
        this.exceptionRef = new AtomicReference();
    }

    public ClassicToAsyncResponseConsumer(Timeout timeout) {
        this(2048, timeout);
    }

    void propagateException() throws IOException {
        Exception ex = this.exceptionRef.getAndSet(null);
        if (ex != null) {
            ClassicToAsyncSupport.rethrow(ex);
        }
    }

    void fireComplete() throws IOException {
        FutureCallback callback2 = this.callbackRef.getAndSet(null);
        if (callback2 != null) {
            callback2.completed(null);
        }
    }

    public ClassicHttpResponse blockWaiting() throws IOException, InterruptedException {
        if (this.timeout == null) {
            this.countDownLatch.await();
        } else if (!this.countDownLatch.await(this.timeout.getDuration(), this.timeout.getTimeUnit())) {
            throw new InterruptedIOException("Timeout blocked waiting for input (" + this.timeout + ")");
        }
        this.propagateException();
        ResponseData r = this.responseRef.getAndSet(null);
        Asserts.notNull(r, "HTTP response is missing");
        SharedInputBuffer inputBuffer = this.bufferRef.get();
        return ClassicResponseBuilder.create(r.head.getCode()).setHeaders(r.head.getHeaders()).setVersion(r.head.getVersion()).setEntity(r.entityDetails != null ? new IncomingHttpEntity(new InternalInputStream(inputBuffer), r.entityDetails) : null).build();
    }

    @Override
    public void consumeResponse(HttpResponse asyncResponse, EntityDetails entityDetails, HttpContext context2, FutureCallback<Void> resultCallback) throws HttpException, IOException {
        this.callbackRef.set(resultCallback);
        ResponseData responseData = new ResponseData(asyncResponse, entityDetails);
        this.responseRef.set(responseData);
        if (entityDetails != null) {
            this.bufferRef.set(new SharedInputBuffer(this.initialBufferSize));
        } else {
            this.fireComplete();
        }
        this.countDownLatch.countDown();
    }

    @Override
    public void informationResponse(HttpResponse response2, HttpContext context2) throws HttpException, IOException {
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        SharedInputBuffer buffer = this.bufferRef.get();
        if (buffer != null) {
            buffer.updateCapacity(capacityChannel);
        }
    }

    @Override
    public final void consume(ByteBuffer src) throws IOException {
        SharedInputBuffer buffer = this.bufferRef.get();
        if (buffer != null) {
            buffer.fill(src);
        }
    }

    @Override
    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        SharedInputBuffer buffer = this.bufferRef.get();
        if (buffer != null) {
            buffer.markEndStream();
        }
    }

    @Override
    public final void failed(Exception cause) {
        try {
            this.exceptionRef.set(cause);
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    @Override
    public void releaseResources() {
    }

    static class IncomingHttpEntity
    implements HttpEntity {
        private final InputStream content;
        private final EntityDetails entityDetails;

        IncomingHttpEntity(InputStream content2, EntityDetails entityDetails) {
            this.content = content2;
            this.entityDetails = entityDetails;
        }

        @Override
        public boolean isRepeatable() {
            return false;
        }

        @Override
        public boolean isChunked() {
            return this.entityDetails.isChunked();
        }

        @Override
        public long getContentLength() {
            return this.entityDetails.getContentLength();
        }

        @Override
        public String getContentType() {
            return this.entityDetails.getContentType();
        }

        @Override
        public String getContentEncoding() {
            return this.entityDetails.getContentEncoding();
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            return this.content;
        }

        @Override
        public boolean isStreaming() {
            return this.content != null;
        }

        @Override
        public void writeTo(OutputStream outStream) throws IOException {
            AbstractHttpEntity.writeTo(this, outStream);
        }

        @Override
        public Supplier<List<? extends Header>> getTrailers() {
            return null;
        }

        @Override
        public Set<String> getTrailerNames() {
            return Collections.emptySet();
        }

        @Override
        public void close() throws IOException {
            Closer.close(this.content);
        }

        public String toString() {
            return this.entityDetails.toString();
        }
    }

    class InternalInputStream
    extends InputStream {
        private final SharedInputBuffer buffer;

        InternalInputStream(SharedInputBuffer buffer) {
            Args.notNull(buffer, "Input buffer");
            this.buffer = buffer;
        }

        @Override
        public int available() throws IOException {
            ClassicToAsyncResponseConsumer.this.propagateException();
            return this.buffer.length();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ClassicToAsyncResponseConsumer.this.propagateException();
            if (len == 0) {
                return 0;
            }
            int bytesRead = this.buffer.read(b, off, len, ClassicToAsyncResponseConsumer.this.timeout);
            if (bytesRead == -1) {
                ClassicToAsyncResponseConsumer.this.fireComplete();
            }
            return bytesRead;
        }

        @Override
        public int read(byte[] b) throws IOException {
            ClassicToAsyncResponseConsumer.this.propagateException();
            if (b == null) {
                return 0;
            }
            int bytesRead = this.buffer.read(b, 0, b.length, ClassicToAsyncResponseConsumer.this.timeout);
            if (bytesRead == -1) {
                ClassicToAsyncResponseConsumer.this.fireComplete();
            }
            return bytesRead;
        }

        @Override
        public int read() throws IOException {
            ClassicToAsyncResponseConsumer.this.propagateException();
            int b = this.buffer.read(ClassicToAsyncResponseConsumer.this.timeout);
            if (b == -1) {
                ClassicToAsyncResponseConsumer.this.fireComplete();
            }
            return b;
        }

        @Override
        public void close() throws IOException {
            byte[] tmp = new byte[1024];
            while (this.read(tmp) >= 0) {
            }
            super.close();
        }
    }

    static class ResponseData {
        final HttpResponse head;
        final EntityDetails entityDetails;

        ResponseData(HttpResponse head, EntityDetails entityDetails) {
            this.head = head;
            this.entityDetails = entityDetails;
        }
    }
}

