/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.util.Iterator;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicTokenIterator;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpRequest request, HttpResponse response2, HttpContext context2) {
        Iterator<Header> headerIterator;
        ProtocolVersion ver;
        Header teh;
        Args.notNull(response2, "HTTP response");
        if (request != null) {
            if (request.containsHeader("Content-Length") && request.containsHeader("Transfer-Encoding")) {
                return false;
            }
            Iterator<String> it = MessageSupport.iterateTokens(request, "Connection");
            while (it.hasNext()) {
                String token = it.next();
                if (!"close".equalsIgnoreCase(token)) continue;
                return false;
            }
        }
        if ((teh = response2.getFirstHeader("Transfer-Encoding")) == null && MessageSupport.canResponseHaveBody(request != null ? request.getMethod() : null, response2) && response2.countHeaders("Content-Length") != 1) {
            return false;
        }
        ProtocolVersion protocolVersion = ver = response2.getVersion() != null ? response2.getVersion() : context2.getProtocolVersion();
        if (ver.lessEquals(HttpVersion.HTTP_1_0) && teh != null) {
            return false;
        }
        if (response2.getCode() == 204) {
            Header clh = response2.getFirstHeader("Content-Length");
            if (clh != null) {
                try {
                    long contentLen = Long.parseLong(clh.getValue());
                    if (contentLen > 0L) {
                        return false;
                    }
                }
                catch (NumberFormatException contentLen) {
                    // empty catch block
                }
            }
            if (response2.containsHeader("Transfer-Encoding")) {
                return false;
            }
        }
        if (!(headerIterator = response2.headerIterator("Connection")).hasNext()) {
            headerIterator = response2.headerIterator("Proxy-Connection");
        }
        if (headerIterator.hasNext()) {
            if (ver.greaterEquals(HttpVersion.HTTP_1_1)) {
                BasicTokenIterator it = new BasicTokenIterator(headerIterator);
                while (it.hasNext()) {
                    String token = (String)it.next();
                    if (!"close".equalsIgnoreCase(token)) continue;
                    return false;
                }
                return true;
            }
            BasicTokenIterator it = new BasicTokenIterator(headerIterator);
            while (it.hasNext()) {
                String token = (String)it.next();
                if (!"keep-alive".equalsIgnoreCase(token)) continue;
                return true;
            }
            return false;
        }
        return ver.greaterEquals(HttpVersion.HTTP_1_1);
    }
}

