/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseConnControl
implements HttpResponseInterceptor {
    public static final ResponseConnControl INSTANCE = new ResponseConnControl();

    @Override
    public void process(HttpResponse response2, EntityDetails entity, HttpContext localContext) throws HttpException, IOException {
        Args.notNull(response2, "HTTP response");
        Args.notNull(localContext, "HTTP context");
        HttpCoreContext context2 = HttpCoreContext.cast(localContext);
        int status = response2.getCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response2.setHeader("Connection", "close");
            return;
        }
        if (!response2.containsHeader("Connection")) {
            ProtocolVersion ver = context2.getProtocolVersion();
            if (entity != null && entity.getContentLength() < 0L && ver.lessEquals(HttpVersion.HTTP_1_0)) {
                response2.setHeader("Connection", "close");
            } else {
                HttpRequest request = context2.getRequest();
                boolean closeRequested = false;
                boolean keepAliveRequested = false;
                if (request != null) {
                    Iterator<HeaderElement> it = MessageSupport.iterate(request, "Connection");
                    while (it.hasNext()) {
                        HeaderElement he = it.next();
                        if (he.getName().equalsIgnoreCase("close")) {
                            closeRequested = true;
                            break;
                        }
                        if (!he.getName().equalsIgnoreCase("keep-alive")) continue;
                        keepAliveRequested = true;
                    }
                }
                if (closeRequested) {
                    response2.addHeader("Connection", "close");
                } else if (response2.containsHeader("Upgrade")) {
                    response2.addHeader("Connection", "upgrade");
                } else if (keepAliveRequested) {
                    response2.addHeader("Connection", "keep-alive");
                } else if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    response2.addHeader("Connection", "close");
                }
            }
        }
    }
}

